/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.execution.datasources.parquet;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.MessageType;
import org.apache.sedona.common.utils.GeomUtils;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.SpecializedGetters;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.catalyst.util.MapData;
import org.apache.spark.sql.execution.datasources.DataSourceUtils$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetMetaData$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.GeoParquetWriteSupport$GeometryColumnBoundingBox$;
import org.apache.spark.sql.execution.datasources.parquet.GeometryFieldMetaData;
import org.apache.spark.sql.execution.datasources.parquet.ParquetReadSupport$;
import org.apache.spark.sql.execution.datasources.parquet.ParquetWriteSupport$;
import org.apache.spark.sql.execution.datasources.parquet.SparkToParquetSchemaConverter;
import org.apache.spark.sql.internal.LegacyBehaviorPolicy$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.sql.package$;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.ArrayType;
import org.apache.spark.sql.types.BinaryType$;
import org.apache.spark.sql.types.BooleanType$;
import org.apache.spark.sql.types.ByteType$;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType$;
import org.apache.spark.sql.types.Decimal;
import org.apache.spark.sql.types.Decimal$;
import org.apache.spark.sql.types.DecimalType;
import org.apache.spark.sql.types.DecimalType$;
import org.apache.spark.sql.types.DoubleType$;
import org.apache.spark.sql.types.FloatType$;
import org.apache.spark.sql.types.IntegerType$;
import org.apache.spark.sql.types.LongType$;
import org.apache.spark.sql.types.MapType;
import org.apache.spark.sql.types.ShortType$;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType$;
import org.apache.spark.sql.types.UserDefinedType;
import org.json4s.DefaultFormats$;
import org.json4s.Extraction$;
import org.json4s.Formats;
import org.json4s.JsonAST;
import org.json4s.jackson.JsonMethods$;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.io.WKBWriter;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\r-h\u0001\u0002-Z\u0001!DQA \u0001\u0005\u0002},a!!\u0002\u0001\t\u0005\u001d\u0001bCA\u0016\u0001\u0001\u0007\t\u0019!C\u0005\u0003[A1\"a\u000f\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002>!Y\u00111\t\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0018\u0011-\t)\u0005\u0001a\u0001\u0002\u0004%I!a\u0012\t\u0017\u0005M\u0003\u00011AA\u0002\u0013%\u0011Q\u000b\u0005\f\u00033\u0002\u0001\u0019!A!B\u0013\tI\u0005C\u0006\u0002\\\u0001\u0001\r\u00111A\u0005\n\u0005u\u0003bCA7\u0001\u0001\u0007\t\u0019!C\u0005\u0003_B1\"a\u001d\u0001\u0001\u0004\u0005\t\u0015)\u0003\u0002`!Y\u0011Q\u000f\u0001A\u0002\u0003\u0007I\u0011BA<\u0011-\ty\b\u0001a\u0001\u0002\u0004%I!!!\t\u0017\u0005\u0015\u0005\u00011A\u0001B\u0003&\u0011\u0011\u0010\u0005\f\u0003\u000f\u0003\u0001\u0019!a\u0001\n\u0013\tI\tC\u0006\u0002(\u0002\u0001\r\u00111A\u0005\n\u0005%\u0006bCAW\u0001\u0001\u0007\t\u0011)Q\u0005\u0003\u0017C\u0011\"a,\u0001\u0005\u0004%I!!-\t\u0011\u0005m\u0006\u0001)A\u0005\u0003gC\u0011\"!0\u0001\u0005\u0004%I!!-\t\u0011\u0005}\u0006\u0001)A\u0005\u0003gC\u0011\"!1\u0001\u0005\u0004%I!a1\t\u0011\u00055\u0007\u0001)A\u0005\u0003\u000bD\u0011\"a4\u0001\u0005\u0004%I!!5\t\u0011\u0005e\u0007\u0001)A\u0005\u0003'D\u0011\"a7\u0001\u0005\u0004%I!!8\t\u0011\u0005\u001d\b\u0001)A\u0005\u0003?D\u0011\"!;\u0001\u0005\u0004%I!a1\t\u0011\u0005-\b\u0001)A\u0005\u0003\u000bD\u0011\"!<\u0001\u0005\u0004%I!!8\t\u0011\u0005=\b\u0001)A\u0005\u0003?D\u0011\"!=\u0001\u0005\u0004%I!a=\t\u0011\t=\b\u0001)A\u0005\u0003kD\u0011B!=\u0001\u0001\u0004%IAa=\t\u0013\tm\b\u00011A\u0005\n\tu\b\u0002CB\u0001\u0001\u0001\u0006KA!>\t\u0013\r\r\u0001\u00011A\u0005\n\r\u0015\u0001\"CB\u0010\u0001\u0001\u0007I\u0011BB\u0011\u0011!\u0019)\u0003\u0001Q!\n\r\u001d\u0001\"CB\u0014\u0001\t\u0007I\u0011BB\u0015\u0011!\u0019i\u0003\u0001Q\u0001\n\r-\u0002bBB\u0018\u0001\u0011\u00053\u0011\u0007\u0005\b\u0007?\u0002A\u0011IB1\u0011\u001d\u0019)\u0007\u0001C!\u0007OBqa!\u001d\u0001\t\u0003\u001a\u0019\bC\u0004\u0004z\u0001!Iaa\u001f\t\u000f\r\u0015\u0005\u0001\"\u0003\u0004\b\"I1\u0011\u0014\u0001\u0012\u0002\u0013%11\u0014\u0005\b\u0007?\u0003A\u0011BBQ\u0011\u001d\u0019Y\u000b\u0001C\u0001\u0007[Cqa!/\u0001\t\u0013\u0019Y\fC\u0004\u0004H\u0002!Ia!3\t\u000f\rU\u0007\u0001\"\u0003\u0004X\"911\u001c\u0001\u0005\n\ruwa\u0002B\u00163\"\u0005!Q\u0006\u0004\u00071fC\tAa\f\t\ryDD\u0011\u0001B\u001c\r\u0019\u0011I\u0004\u000f\u0001\u0003<!1aP\u000fC\u0001\u0005{A\u0011Ba\u0011;\u0005\u0004%\tA!\u0012\t\u0011\t\u0005&\b)A\u0005\u0005\u000fB\u0011Ba);\u0005\u0004%\tA!*\t\u0011\tu&\b)A\u0005\u0005OCqAa\";\t\u0003\u0011yL\u0002\u0004\u0003Ja\u0002!1\n\u0005\u000b\u0005\u001b\n%\u00111A\u0005\u0002\t=\u0003B\u0003B,\u0003\n\u0005\r\u0011\"\u0001\u0003Z!Q!QL!\u0003\u0002\u0003\u0006KA!\u0015\t\u0015\t}\u0013I!a\u0001\n\u0003\u0011y\u0005\u0003\u0006\u0003b\u0005\u0013\t\u0019!C\u0001\u0005GB!Ba\u001aB\u0005\u0003\u0005\u000b\u0015\u0002B)\u0011)\u0011I'\u0011BA\u0002\u0013\u0005!q\n\u0005\u000b\u0005W\n%\u00111A\u0005\u0002\t5\u0004B\u0003B9\u0003\n\u0005\t\u0015)\u0003\u0003R!Q!1O!\u0003\u0002\u0004%\tAa\u0014\t\u0015\tU\u0014I!a\u0001\n\u0003\u00119\b\u0003\u0006\u0003|\u0005\u0013\t\u0011)Q\u0005\u0005#BaA`!\u0005\u0002\tu\u0004b\u0002BD\u0003\u0012\u0005!\u0011R\u0004\n\u0005\u0007D\u0014\u0011!E\u0001\u0005\u000b4\u0011B!\u00139\u0003\u0003E\tAa2\t\ry\fF\u0011\u0001Be\u0011%\u0011Y-UI\u0001\n\u0003\u0011i\rC\u0005\u0003dF\u000b\n\u0011\"\u0001\u0003N\"I!Q])\u0012\u0002\u0013\u0005!Q\u001a\u0005\n\u0005O\f\u0016\u0013!C\u0001\u0005\u001bDqA!;9\t\u0013\u0011YO\u0001\fHK>\u0004\u0016M]9vKR<&/\u001b;f'V\u0004\bo\u001c:u\u0015\tQ6,A\u0004qCJ\fX/\u001a;\u000b\u0005qk\u0016a\u00033bi\u0006\u001cx.\u001e:dKNT!AX0\u0002\u0013\u0015DXmY;uS>t'B\u00011b\u0003\r\u0019\u0018\u000f\u001c\u0006\u0003E\u000e\fQa\u001d9be.T!\u0001Z3\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00051\u0017aA8sO\u000e\u00011c\u0001\u0001jqB\u0019!\u000e\u001d:\u000e\u0003-T!\u0001\\7\u0002\u0007\u0005\u0004\u0018N\u0003\u0002o_\u00061\u0001.\u00193p_BT!AW2\n\u0005E\\'\u0001D,sSR,7+\u001e9q_J$\bCA:w\u001b\u0005!(BA;`\u0003!\u0019\u0017\r^1msN$\u0018BA<u\u0005-Ie\u000e^3s]\u0006d'k\\<\u0011\u0005edX\"\u0001>\u000b\u0005m\f\u0017\u0001C5oi\u0016\u0014h.\u00197\n\u0005uT(a\u0002'pO\u001eLgnZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0005\u0005\u0001cAA\u0002\u00015\t\u0011LA\u0006WC2,Xm\u0016:ji\u0016\u0014\bCCA\u0005\u0003\u001f\t\u0019\"a\b\u0002&5\u0011\u00111\u0002\u0006\u0003\u0003\u001b\tQa]2bY\u0006LA!!\u0005\u0002\f\tIa)\u001e8di&|gN\r\t\u0005\u0003+\tY\"\u0004\u0002\u0002\u0018)\u0019\u0011\u0011\u0004;\u0002\u0017\u0015D\bO]3tg&|gn]\u0005\u0005\u0003;\t9B\u0001\nTa\u0016\u001c\u0017.\u00197ju\u0016$w)\u001a;uKJ\u001c\b\u0003BA\u0005\u0003CIA!a\t\u0002\f\t\u0019\u0011J\u001c;\u0011\t\u0005%\u0011qE\u0005\u0005\u0003S\tYA\u0001\u0003V]&$\u0018AB:dQ\u0016l\u0017-\u0006\u0002\u00020A!\u0011\u0011GA\u001c\u001b\t\t\u0019DC\u0002\u00026}\u000bQ\u0001^=qKNLA!!\u000f\u00024\tQ1\u000b\u001e:vGR$\u0016\u0010]3\u0002\u0015M\u001c\u0007.Z7b?\u0012*\u0017\u000f\u0006\u0003\u0002&\u0005}\u0002\"CA!\t\u0005\u0005\t\u0019AA\u0018\u0003\rAH%M\u0001\bg\u000eDW-\\1!\u0003A\u0011xn\u001c;GS\u0016dGm\u0016:ji\u0016\u00148/\u0006\u0002\u0002JA1\u0011\u0011BA&\u0003\u001fJA!!\u0014\u0002\f\t)\u0011I\u001d:bsB\u0019\u0011\u0011\u000b\u0002\u000e\u0003\u0001\tAC]8pi\u001aKW\r\u001c3Xe&$XM]:`I\u0015\fH\u0003BA\u0013\u0003/B\u0011\"!\u0011\b\u0003\u0003\u0005\r!!\u0013\u0002#I|w\u000e\u001e$jK2$wK]5uKJ\u001c\b%\u0001\bsK\u000e|'\u000fZ\"p]N,X.\u001a:\u0016\u0005\u0005}\u0003\u0003BA1\u0003Sj!!a\u0019\u000b\u00071\f)GC\u0002\u0002h=\f!![8\n\t\u0005-\u00141\r\u0002\u000f%\u0016\u001cwN\u001d3D_:\u001cX/\\3s\u0003I\u0011XmY8sI\u000e{gn];nKJ|F%Z9\u0015\t\u0005\u0015\u0012\u0011\u000f\u0005\n\u0003\u0003R\u0011\u0011!a\u0001\u0003?\nqB]3d_J$7i\u001c8tk6,'\u000fI\u0001\u0019oJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$XCAA=!\u0011\tI!a\u001f\n\t\u0005u\u00141\u0002\u0002\b\u0005>|G.Z1o\u0003q9(/\u001b;f\u0019\u0016<\u0017mY=QCJ\fX/\u001a;G_Jl\u0017\r^0%KF$B!!\n\u0002\u0004\"I\u0011\u0011I\u0007\u0002\u0002\u0003\u0007\u0011\u0011P\u0001\u001aoJLG/\u001a'fO\u0006\u001c\u0017\u0010U1scV,GOR8s[\u0006$\b%A\npkR\u0004X\u000f\u001e+j[\u0016\u001cH/Y7q)f\u0004X-\u0006\u0002\u0002\fB!\u0011QRAP\u001d\u0011\ty)!'\u000f\t\u0005E\u0015QS\u0007\u0003\u0003'S!a_0\n\t\u0005]\u00151S\u0001\b'Fc5i\u001c8g\u0013\u0011\tY*!(\u00025A\u000b'/];fi>+H\u000f];u)&lWm\u001d;b[B$\u0016\u0010]3\u000b\t\u0005]\u00151S\u0005\u0005\u0003C\u000b\u0019KA\u0003WC2,X-\u0003\u0003\u0002&\u0006-!aC#ok6,'/\u0019;j_:\fqc\\;uaV$H+[7fgR\fW\u000e\u001d+za\u0016|F%Z9\u0015\t\u0005\u0015\u00121\u0016\u0005\n\u0003\u0003\u0002\u0012\u0011!a\u0001\u0003\u0017\u000bAc\\;uaV$H+[7fgR\fW\u000e\u001d+za\u0016\u0004\u0013a\u0004;j[\u0016\u001cH/Y7q\u0005V4g-\u001a:\u0016\u0005\u0005M\u0006CBA\u0005\u0003\u0017\n)\f\u0005\u0003\u0002\n\u0005]\u0016\u0002BA]\u0003\u0017\u0011AAQ=uK\u0006\u0001B/[7fgR\fW\u000e\u001d\"vM\u001a,'\u000fI\u0001\u000eI\u0016\u001c\u0017.\\1m\u0005V4g-\u001a:\u0002\u001d\u0011,7-[7bY\n+hMZ3sA\u0005\u0011B-\u0019;fi&lWMU3cCN,Wj\u001c3f+\t\t)\r\u0005\u0003\u0002H\u0006}e\u0002BAI\u0003\u0013LA!a3\u0002\u0014\u0006!B*Z4bGf\u0014U\r[1wS>\u0014\bk\u001c7jGf\f1\u0003Z1uKRLW.\u001a*fE\u0006\u001cX-T8eK\u0002\na\u0002Z1uKJ+'-Y:f\rVt7-\u0006\u0002\u0002TBA\u0011\u0011BAk\u0003?\ty\"\u0003\u0003\u0002X\u0006-!!\u0003$v]\u000e$\u0018n\u001c82\u0003=!\u0017\r^3SK\n\f7/\u001a$v]\u000e\u0004\u0013a\u0005;j[\u0016\u001cH/Y7q%\u0016\u0014\u0017m]3Gk:\u001cWCAAp!!\tI!!6\u0002b\u0006\u0005\b\u0003BA\u0005\u0003GLA!!:\u0002\f\t!Aj\u001c8h\u0003Q!\u0018.\\3ti\u0006l\u0007OU3cCN,g)\u001e8dA\u0005y\u0011N\u001c;:mI+'-Y:f\u001b>$W-\u0001\tj]RLdGU3cCN,Wj\u001c3fA\u0005y\u0011N\u001c;:mI+'-Y:f\rVt7-\u0001\tj]RLdGU3cCN,g)\u001e8dA\u0005)r-Z8nKR\u0014\u0018pQ8mk6t\u0017J\u001c4p\u001b\u0006\u0004XCAA{!!\t9P!\u0001\u0002 \t\u0015QBAA}\u0015\u0011\tY0!@\u0002\u000f5,H/\u00192mK*!\u0011q`A\u0006\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u0007\tIPA\u0002NCB\u00042Aa\u0002;\u001d\r\u0011Ia\u000e\b\u0005\u0005\u0017\u0011IC\u0004\u0003\u0003\u000e\t\u001db\u0002\u0002B\b\u0005KqAA!\u0005\u0003$9!!1\u0003B\u0011\u001d\u0011\u0011)Ba\b\u000f\t\t]!QD\u0007\u0003\u00053Q1Aa\u0007h\u0003\u0019a$o\\8u}%\ta-\u0003\u0002eK&\u0011!mY\u0005\u0003A\u0006L!AX0\n\u0005qk\u0016B\u0001.\\\u0003Y9Um\u001c)beF,X\r^,sSR,7+\u001e9q_J$\bcAA\u0002qM\u0019\u0001H!\r\u0011\t\u0005%!1G\u0005\u0005\u0005k\tYA\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005[\u0011!cR3p[\u0016$(/_\"pYVlg.\u00138g_N\u0019!H!\r\u0015\u0005\t}\u0002c\u0001B!u5\t\u0001(\u0001\u0003cE>DXC\u0001B$!\r\u0011\t%\u0011\u0002\u001a\u000f\u0016|W.\u001a;ss\u000e{G.^7o\u0005>,h\u000eZ5oO\n{\u0007pE\u0002B\u0005c\tA!\\5o1V\u0011!\u0011\u000b\t\u0005\u0003\u0013\u0011\u0019&\u0003\u0003\u0003V\u0005-!A\u0002#pk\ndW-\u0001\u0005nS:Dv\fJ3r)\u0011\t)Ca\u0017\t\u0013\u0005\u00053)!AA\u0002\tE\u0013!B7j]b\u0003\u0013\u0001B7j]f\u000b\u0001\"\\5o3~#S-\u001d\u000b\u0005\u0003K\u0011)\u0007C\u0005\u0002B\u0019\u000b\t\u00111\u0001\u0003R\u0005)Q.\u001b8ZA\u0005!Q.\u0019=Y\u0003!i\u0017\r\u001f-`I\u0015\fH\u0003BA\u0013\u0005_B\u0011\"!\u0011J\u0003\u0003\u0005\rA!\u0015\u0002\u000b5\f\u0007\u0010\u0017\u0011\u0002\t5\f\u00070W\u0001\t[\u0006D\u0018l\u0018\u0013fcR!\u0011Q\u0005B=\u0011%\t\t\u0005TA\u0001\u0002\u0004\u0011\t&A\u0003nCbL\u0006\u0005\u0006\u0006\u0003H\t}$\u0011\u0011BB\u0005\u000bC\u0011B!\u0014O!\u0003\u0005\rA!\u0015\t\u0013\t}c\n%AA\u0002\tE\u0003\"\u0003B5\u001dB\u0005\t\u0019\u0001B)\u0011%\u0011\u0019H\u0014I\u0001\u0002\u0004\u0011\t&\u0001\u0004va\u0012\fG/\u001a\u000b\u0005\u0003K\u0011Y\tC\u0004\u0003\u000e>\u0003\rAa$\u0002\t\u001d,w.\u001c\t\u0005\u0005#\u0013i*\u0004\u0002\u0003\u0014*!!Q\u0012BK\u0015\u0011\u00119J!'\u0002\u0007)$8OC\u0002\u0003\u001c\u0016\fA\u0002\\8dCRLwN\u001c;fG\"LAAa(\u0003\u0014\nAq)Z8nKR\u0014\u00180A\u0003cE>D\b%A\ttK\u0016tw)Z8nKR\u0014\u0018\u0010V=qKN,\"Aa*\u0011\r\u0005](\u0011\u0016BW\u0013\u0011\u0011Y+!?\u0003\u0007M+G\u000f\u0005\u0003\u00030\n]f\u0002\u0002BY\u0005g\u0003BAa\u0006\u0002\f%!!QWA\u0006\u0003\u0019\u0001&/\u001a3fM&!!\u0011\u0018B^\u0005\u0019\u0019FO]5oO*!!QWA\u0006\u0003I\u0019X-\u001a8HK>lW\r\u001e:z)f\u0004Xm\u001d\u0011\u0015\t\u0005\u0015\"\u0011\u0019\u0005\b\u0005\u001b\u0003\u0005\u0019\u0001BH\u0003e9Um\\7fiJL8i\u001c7v[:\u0014u.\u001e8eS:<'i\u001c=\u0011\u0007\t\u0005\u0013kE\u0002R\u0005c!\"A!2\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00132+\t\u0011yM\u000b\u0003\u0003R\tE7F\u0001Bj!\u0011\u0011)Na8\u000e\u0005\t]'\u0002\u0002Bm\u00057\f\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\t\tu\u00171B\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002\u0002Bq\u0005/\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%e\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"\u0014!H4fiN\u0003\u0018M]6Tc2\u0004\u0016M]9vKR\u0014vn^'fi\u0006$\u0017\r^1\u0015\t\t5&Q\u001e\u0005\b\u0003W9\u0006\u0019AA\u0018\u0003Y9Wm\\7fiJL8i\u001c7v[:LeNZ8NCB\u0004\u0013!E4f_B\u000b'/];fiZ+'o]5p]V\u0011!Q\u001f\t\u0007\u0003\u0013\u00119P!,\n\t\te\u00181\u0002\u0002\u0007\u001fB$\u0018n\u001c8\u0002+\u001d,w\u000eU1scV,GOV3sg&|gn\u0018\u0013fcR!\u0011Q\u0005B\u0000\u0011%\t\teIA\u0001\u0002\u0004\u0011)0\u0001\nhK>\u0004\u0016M]9vKR4VM]:j_:\u0004\u0013\u0001\u00063fM\u0006,H\u000e^$f_B\u000b'/];fi\u000e\u00138/\u0006\u0002\u0004\bA1\u0011\u0011\u0002B|\u0007\u0013\u0001Baa\u0003\u0004\u001a9!1QBB\n\u001d\u0011\u0011)ba\u0004\n\u0007\rEQ-\u0001\u0004kg>tGg]\u0005\u0005\u0007+\u00199\"A\u0004qC\u000e\\\u0017mZ3\u000b\u0007\rEQ-\u0003\u0003\u0004\u001c\ru!A\u0002&WC2,XM\u0003\u0003\u0004\u0016\r]\u0011\u0001\u00073fM\u0006,H\u000e^$f_B\u000b'/];fi\u000e\u00138o\u0018\u0013fcR!\u0011QEB\u0012\u0011%\t\tEJA\u0001\u0002\u0004\u00199!A\u000beK\u001a\fW\u000f\u001c;HK>\u0004\u0016M]9vKR\u001c%o\u001d\u0011\u0002-\u001d,w\u000eU1scV,GoQ8mk6t7I]:NCB,\"aa\u000b\u0011\u0011\u0005](\u0011\u0001BW\u0007\u000f\tqcZ3p!\u0006\u0014\u0018/^3u\u0007>dW/\u001c8DeNl\u0015\r\u001d\u0011\u0002\t%t\u0017\u000e\u001e\u000b\u0005\u0007g\u0019i\u0005\u0005\u0003\u00046\r\u001dc\u0002BB\u001c\u0007\u0007rAa!\u000f\u0004B9!11HB \u001d\u0011\u0011\u0019b!\u0010\n\u0005i\u001b\u0017B\u00018p\u0013\taW.C\u0002\u0004F-\fAb\u0016:ji\u0016\u001cV\u000f\u001d9peRLAa!\u0013\u0004L\taqK]5uK\u000e{g\u000e^3yi*\u00191QI6\t\u000f\r=#\u00061\u0001\u0004R\u0005i1m\u001c8gS\u001e,(/\u0019;j_:\u0004Baa\u0015\u0004\\5\u00111Q\u000b\u0006\u0005\u0007/\u001aI&\u0001\u0003d_:4'B\u00018d\u0013\u0011\u0019if!\u0016\u0003\u001b\r{gNZ5hkJ\fG/[8o\u0003=\u0001(/\u001a9be\u00164uN],sSR,G\u0003BA\u0013\u0007GBq!a\u0017,\u0001\u0004\ty&A\u0007gS:\fG.\u001b>f/JLG/\u001a\u000b\u0003\u0007S\u0002Baa\u001b\u0004n9\u0019!na\u0011\n\t\r=41\n\u0002\u0016\r&t\u0017\r\\5{K\u0012<&/\u001b;f\u0007>tG/\u001a=u\u0003\u00159(/\u001b;f)\u0011\t)c!\u001e\t\r\r]T\u00061\u0001s\u0003\r\u0011xn^\u0001\foJLG/\u001a$jK2$7\u000f\u0006\u0005\u0002&\ru4qPBA\u0011\u0019\u00199H\fa\u0001e\"9\u00111\u0006\u0018A\u0002\u0005=\u0002bBBB]\u0001\u0007\u0011\u0011J\u0001\rM&,G\u000eZ,sSR,'o]\u0001\u000b[\u0006\\Wm\u0016:ji\u0016\u0014HCBA(\u0007\u0013\u001b\u0019\nC\u0004\u0004\f>\u0002\ra!$\u0002\u0011\u0011\fG/\u0019+za\u0016\u0004B!!\r\u0004\u0010&!1\u0011SA\u001a\u0005!!\u0015\r^1UsB,\u0007\"CBK_A\u0005\t\u0019ABL\u0003-\u0011xn\u001c;Pe\u0012Lg.\u00197\u0011\r\u0005%!q_A\u0010\u0003Qi\u0017m[3Xe&$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%eU\u00111Q\u0014\u0016\u0005\u0007/\u0013\t.A\tnC.,G)Z2j[\u0006dwK]5uKJ$b!a\u0014\u0004$\u000e\u001d\u0006bBBSc\u0001\u0007\u0011qD\u0001\naJ,7-[:j_:Dqa!+2\u0001\u0004\ty\"A\u0003tG\u0006dW-A\bnC.,\u0017I\u001d:bs^\u0013\u0018\u000e^3s)\u0011\tyea,\t\u000f\rE&\u00071\u0001\u00044\u0006I\u0011M\u001d:bsRK\b/\u001a\t\u0005\u0003c\u0019),\u0003\u0003\u00048\u0006M\"!C!se\u0006LH+\u001f9f\u00035i\u0017m[3NCB<&/\u001b;feR!\u0011qJB_\u0011\u001d\u0019yl\ra\u0001\u0007\u0003\fq!\\1q)f\u0004X\r\u0005\u0003\u00022\r\r\u0017\u0002BBc\u0003g\u0011q!T1q)f\u0004X-\u0001\bd_:\u001cX/\\3NKN\u001c\u0018mZ3\u0015\t\u0005\u001521\u001a\u0005\t\u0007\u001b$D\u00111\u0001\u0004P\u0006\ta\r\u0005\u0004\u0002\n\rE\u0017QE\u0005\u0005\u0007'\fYA\u0001\u0005=Eft\u0017-\\3?\u00031\u0019wN\\:v[\u0016<%o\\;q)\u0011\t)c!7\t\u0011\r5W\u0007\"a\u0001\u0007\u001f\fAbY8ogVlWMR5fY\u0012$baa8\u0004d\u000e\u001dH\u0003BA\u0013\u0007CD\u0001b!47\t\u0003\u00071q\u001a\u0005\b\u0007K4\u0004\u0019\u0001BW\u0003\u00151\u0017.\u001a7e\u0011\u001d\u0019IO\u000ea\u0001\u0003?\tQ!\u001b8eKb\u0004")
public class GeoParquetWriteSupport
extends WriteSupport<InternalRow>
implements Logging {
    private StructType schema;
    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters;
    private RecordConsumer recordConsumer;
    private boolean writeLegacyParquetFormat;
    private Enumeration.Value outputTimestampType;
    private final byte[] timestampBuffer;
    private final byte[] decimalBuffer;
    private final Enumeration.Value datetimeRebaseMode;
    private final Function1<Object, Object> dateRebaseFunc;
    private final Function1<Object, Object> timestampRebaseFunc;
    private final Enumeration.Value int96RebaseMode;
    private final Function1<Object, Object> int96RebaseFunc;
    private final scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap;
    private Option<String> geoParquetVersion;
    private Option<JsonAST.JValue> defaultGeoParquetCrs;
    private final scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    private StructType schema() {
        return this.schema;
    }

    private void schema_$eq(StructType x$1) {
        this.schema = x$1;
    }

    private Function2<SpecializedGetters, Object, BoxedUnit>[] rootFieldWriters() {
        return this.rootFieldWriters;
    }

    private void rootFieldWriters_$eq(Function2<SpecializedGetters, Object, BoxedUnit>[] x$1) {
        this.rootFieldWriters = x$1;
    }

    private RecordConsumer recordConsumer() {
        return this.recordConsumer;
    }

    private void recordConsumer_$eq(RecordConsumer x$1) {
        this.recordConsumer = x$1;
    }

    private boolean writeLegacyParquetFormat() {
        return this.writeLegacyParquetFormat;
    }

    private void writeLegacyParquetFormat_$eq(boolean x$1) {
        this.writeLegacyParquetFormat = x$1;
    }

    private Enumeration.Value outputTimestampType() {
        return this.outputTimestampType;
    }

    private void outputTimestampType_$eq(Enumeration.Value x$1) {
        this.outputTimestampType = x$1;
    }

    private byte[] timestampBuffer() {
        return this.timestampBuffer;
    }

    private byte[] decimalBuffer() {
        return this.decimalBuffer;
    }

    private Enumeration.Value datetimeRebaseMode() {
        return this.datetimeRebaseMode;
    }

    private Function1<Object, Object> dateRebaseFunc() {
        return this.dateRebaseFunc;
    }

    private Function1<Object, Object> timestampRebaseFunc() {
        return this.timestampRebaseFunc;
    }

    private Enumeration.Value int96RebaseMode() {
        return this.int96RebaseMode;
    }

    private Function1<Object, Object> int96RebaseFunc() {
        return this.int96RebaseFunc;
    }

    private scala.collection.mutable.Map<Object, GeometryColumnInfo> geometryColumnInfoMap() {
        return this.geometryColumnInfoMap;
    }

    private Option<String> geoParquetVersion() {
        return this.geoParquetVersion;
    }

    private void geoParquetVersion_$eq(Option<String> x$1) {
        this.geoParquetVersion = x$1;
    }

    private Option<JsonAST.JValue> defaultGeoParquetCrs() {
        return this.defaultGeoParquetCrs;
    }

    private void defaultGeoParquetCrs_$eq(Option<JsonAST.JValue> x$1) {
        this.defaultGeoParquetCrs = x$1;
    }

    private scala.collection.mutable.Map<String, Option<JsonAST.JValue>> geoParquetColumnCrsMap() {
        return this.geoParquetColumnCrsMap;
    }

    public WriteSupport.WriteContext init(Configuration configuration) {
        Some some;
        Some some2;
        String schemaString = configuration.get(ParquetWriteSupport$.MODULE$.SPARK_ROW_SCHEMA());
        this.schema_$eq(StructType$.MODULE$.fromString(schemaString));
        Predef$.MODULE$.assert(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()) != null);
        this.writeLegacyParquetFormat_$eq(new StringOps(Predef$.MODULE$.augmentString(configuration.get(SQLConf$.MODULE$.PARQUET_WRITE_LEGACY_FORMAT().key()))).toBoolean());
        String key = SQLConf$.MODULE$.PARQUET_OUTPUT_TIMESTAMP_TYPE().key();
        Predef$.MODULE$.assert(configuration.get(key) != null);
        this.outputTimestampType_$eq(SQLConf.ParquetOutputTimestampType$.MODULE$.withName(configuration.get(key)));
        this.rootFieldWriters_$eq((Function2[])((TraversableOnce)((TraversableLike)this.schema().zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            StructField field = (StructField)tuple2._1();
            int ordinal = tuple2._2$mcI$sp();
            Function2<SpecializedGetters, Object, BoxedUnit> function2 = this.makeWriter(field.dataType(), (Option<Object>)new Some((Object)BoxesRunTime.boxToInteger((int)ordinal)));
            return function2;
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class)));
        if (this.geometryColumnInfoMap().isEmpty()) {
            throw new RuntimeException("No geometry column found in the schema");
        }
        String string = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_VERSION_KEY());
        if (string == null) {
            some2 = new Some((Object)GeoParquetMetaData$.MODULE$.VERSION());
        } else if (string != null) {
            String string2 = string;
            some2 = new Some((Object)string2);
        } else {
            throw new MatchError((Object)string);
        }
        this.geoParquetVersion_$eq((Option<String>)some2);
        String string3 = configuration.get(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY());
        if (string3 == null) {
            some = new Some((Object)org.json4s.package$.MODULE$.JNull());
        } else if ("".equals(string3)) {
            some = None$.MODULE$;
        } else if (string3 != null) {
            String string4 = string3;
            some = new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string4), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3()));
        } else {
            throw new MatchError((Object)string3);
        }
        this.defaultGeoParquetCrs_$eq((Option<JsonAST.JValue>)some);
        ((IterableLike)this.geometryColumnInfoMap().keys().map((Function1 & Serializable & scala.Serializable)x$1 -> GeoParquetWriteSupport.$anonfun$init$2(this, BoxesRunTime.unboxToInt((Object)x$1)), Iterable$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)name -> {
            GeoParquetWriteSupport.$anonfun$init$3(this, configuration, name);
            return BoxedUnit.UNIT;
        });
        MessageType messageType = new SparkToParquetSchemaConverter(configuration).convert(this.schema());
        String sparkSqlParquetRowMetadata = GeoParquetWriteSupport$.MODULE$.org$apache$spark$sql$execution$datasources$parquet$GeoParquetWriteSupport$$getSparkSqlParquetRowMetadata(this.schema());
        Enumeration.Value value = this.datetimeRebaseMode();
        Enumeration.Value value2 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        Enumeration.Value value3 = this.int96RebaseMode();
        Enumeration.Value value4 = LegacyBehaviorPolicy$.MODULE$.LEGACY();
        scala.collection.immutable.Map metadata = ((MapLike)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)package$.MODULE$.SPARK_VERSION_METADATA_KEY()), (Object)org.apache.spark.package$.MODULE$.SPARK_VERSION_SHORT()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ParquetReadSupport$.MODULE$.SPARK_METADATA_KEY()), (Object)sparkSqlParquetRowMetadata)}))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)(!(value != null ? !value.equals(value2) : value2 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyDateTime"), (Object)"")) : None$.MODULE$))).$plus$plus((GenTraversableOnce)Option$.MODULE$.option2Iterable((Option)(!(value3 != null ? !value3.equals(value4) : value4 != null) ? new Some((Object)Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"org.apache.spark.legacyINT96"), (Object)"")) : None$.MODULE$)));
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(134).append("Initialized Parquet WriteSupport with Catalyst schema:\n         |").append(this.schema().prettyJson()).append("\n         |and corresponding Parquet message type:\n         |").append(messageType).append("\n       ").toString())).stripMargin());
        return new WriteSupport.WriteContext(messageType, (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)metadata).asJava());
    }

    public void prepareForWrite(RecordConsumer recordConsumer) {
        this.recordConsumer_$eq(recordConsumer);
    }

    public WriteSupport.FinalizedWriteContext finalizeWrite() {
        Object object;
        HashMap<String, String> metadata = new HashMap<String, String>();
        if (this.geometryColumnInfoMap().nonEmpty()) {
            int primaryColumnIndex = BoxesRunTime.unboxToInt((Object)this.geometryColumnInfoMap().keys().head());
            String primaryColumn = this.schema().fields()[primaryColumnIndex].name();
            scala.collection.immutable.Map columns = ((TraversableOnce)this.geometryColumnInfoMap().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
                Tuple2 tuple2 = x0$1;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int ordinal = tuple2._1$mcI$sp();
                GeometryColumnInfo columnInfo = (GeometryColumnInfo)tuple2._2();
                String columnName = this.schema().fields()[ordinal].name();
                Seq geometryTypes = columnInfo.seenGeometryTypes().toSeq();
                Seq bbox = geometryTypes.nonEmpty() ? (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{columnInfo.bbox().minX(), columnInfo.bbox().minY(), columnInfo.bbox().maxX(), columnInfo.bbox().maxY()})) : (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapDoubleArray(new double[]{0.0, 0.0, 0.0, 0.0}));
                Option crs = (Option)this.geoParquetColumnCrsMap().getOrElse((Object)columnName, (Function0 & Serializable & scala.Serializable)() -> this.defaultGeoParquetCrs());
                Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)columnName), (Object)new GeometryFieldMetaData("WKB", (Seq<String>)geometryTypes, (Seq<Object>)bbox, (Option<JsonAST.JValue>)crs));
                return tuple22;
            }, Map$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
            GeoParquetMetaData geoParquetMetadata = new GeoParquetMetaData(this.geoParquetVersion(), primaryColumn, (scala.collection.immutable.Map<String, GeometryFieldMetaData>)columns);
            DefaultFormats$ formats = DefaultFormats$.MODULE$;
            String geoParquetMetadataJson = org.json4s.jackson.package$.MODULE$.compactJson(org.json4s.package$.MODULE$.jvalue2monadic(Extraction$.MODULE$.decompose((Object)geoParquetMetadata, (Formats)formats)).underscoreKeys());
            object = metadata.put("geo", geoParquetMetadataJson);
        } else {
            object = BoxedUnit.UNIT;
        }
        return new WriteSupport.FinalizedWriteContext(metadata);
    }

    public void write(InternalRow row) {
        this.consumeMessage((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row, this.schema(), this.rootFieldWriters()));
    }

    private void writeFields(InternalRow row, StructType schema, Function2<SpecializedGetters, Object, BoxedUnit>[] fieldWriters) {
        IntRef i = IntRef.create((int)0);
        while (i.elem < row.numFields()) {
            if (!row.isNullAt(i.elem)) {
                this.consumeField(schema.apply(i.elem).name(), i.elem, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> fieldWriters[i$1.elem].apply((Object)row, (Object)BoxesRunTime.boxToInteger((int)i$1.elem)));
            }
            ++i.elem;
        }
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeWriter(DataType dataType, Option<Object> rootOrdinal) {
        Function2 & Serializable & scala.Serializable intersect;
        block27: {
            while (true) {
                DecimalType decimalType;
                Option option;
                DataType dataType2;
                if (BooleanType$.MODULE$.equals(dataType2 = dataType)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$1(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (ByteType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$2(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (ShortType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$3(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (DateType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$4(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (IntegerType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$5(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (LongType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$6(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (FloatType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$7(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (DoubleType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$8(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (StringType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$9(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (TimestampType$.MODULE$.equals(dataType2)) {
                    Function2 & Serializable & scala.Serializable intersect2;
                    Enumeration.Value value = this.outputTimestampType();
                    Enumeration.Value value2 = SQLConf.ParquetOutputTimestampType$.MODULE$.INT96();
                    Enumeration.Value value3 = value;
                    if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
                        intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                            GeoParquetWriteSupport.$anonfun$makeWriter$10(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                            return BoxedUnit.UNIT;
                        };
                    } else {
                        Enumeration.Value value4 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MICROS();
                        Enumeration.Value value5 = value;
                        if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                            intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                GeoParquetWriteSupport.$anonfun$makeWriter$11(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                return BoxedUnit.UNIT;
                            };
                        } else {
                            Enumeration.Value value6 = SQLConf.ParquetOutputTimestampType$.MODULE$.TIMESTAMP_MILLIS();
                            Enumeration.Value value7 = value;
                            if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                                intersect2 = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                                    GeoParquetWriteSupport.$anonfun$makeWriter$12(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                                    return BoxedUnit.UNIT;
                                };
                            } else {
                                throw new MatchError((Object)value);
                            }
                        }
                    }
                    intersect = intersect2;
                    break block27;
                }
                if (BinaryType$.MODULE$.equals(dataType2)) {
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$13(this, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (dataType2 instanceof DecimalType && !(option = DecimalType.Fixed$.MODULE$.unapply(decimalType = (DecimalType)dataType2)).isEmpty()) {
                    int precision = ((Tuple2)option.get())._1$mcI$sp();
                    int scale = ((Tuple2)option.get())._2$mcI$sp();
                    intersect = this.makeDecimalWriter(precision, scale);
                    break block27;
                }
                if (dataType2 instanceof StructType) {
                    StructType structType = (StructType)dataType2;
                    Function2[] fieldWriters = (Function2[])((TraversableOnce)((TraversableLike)structType.map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.dataType(), Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x$4 -> this.makeWriter((DataType)x$4, (Option<Object>)None$.MODULE$), Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Function2.class));
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> this.writeFields(row.getStruct(BoxesRunTime.unboxToInt((Object)ordinal), structType.length()), structType, fieldWriters));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (dataType2 instanceof ArrayType) {
                    ArrayType arrayType = (ArrayType)dataType2;
                    intersect = this.makeArrayWriter(arrayType);
                    break block27;
                }
                if (dataType2 instanceof MapType) {
                    MapType mapType = (MapType)dataType2;
                    intersect = this.makeMapWriter(mapType);
                    break block27;
                }
                if (((Object)((Object)GeometryUDT$.MODULE$)).equals(dataType2)) {
                    GeometryColumnInfo geometryColumnInfo;
                    Option<Object> option2 = rootOrdinal;
                    if (option2 instanceof Some) {
                        Some some = (Some)option2;
                        int ordinal2 = BoxesRunTime.unboxToInt((Object)some.value());
                        geometryColumnInfo = (GeometryColumnInfo)this.geometryColumnInfoMap().getOrElseUpdate((Object)BoxesRunTime.boxToInteger((int)ordinal2), (Function0 & Serializable & scala.Serializable)() -> new GeometryColumnInfo());
                    } else if (None$.MODULE$.equals(option2)) {
                        geometryColumnInfo = null;
                    } else {
                        throw new MatchError(option2);
                    }
                    GeometryColumnInfo geometryColumnInfo2 = geometryColumnInfo;
                    intersect = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
                        GeoParquetWriteSupport.$anonfun$makeWriter$19(this, geometryColumnInfo2, row, BoxesRunTime.unboxToInt((Object)ordinal));
                        return BoxedUnit.UNIT;
                    };
                    break block27;
                }
                if (!(dataType2 instanceof UserDefinedType)) break;
                UserDefinedType userDefinedType = (UserDefinedType)dataType2;
                rootOrdinal = this.makeWriter$default$2();
                dataType = userDefinedType.sqlType();
            }
            throw scala.sys.package$.MODULE$.error(new StringBuilder(23).append("Unsupported data type ").append(dataType).append(".").toString());
        }
        return intersect;
    }

    private Option<Object> makeWriter$default$2() {
        return None$.MODULE$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Function2<SpecializedGetters, Object, BoxedUnit> makeDecimalWriter(int precision, int scale) {
        Predef$.MODULE$.assert(precision <= DecimalType$.MODULE$.MAX_PRECISION(), (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(41).append("Decimal precision ").append(precision).append(" exceeds max precision ").append(DecimalType$.MODULE$.MAX_PRECISION()).toString());
        int numBytes = Decimal$.MODULE$.minBytesForPrecision()[precision];
        Function2 & Serializable & scala.Serializable int32Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$2(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable int64Writer = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$3(this, precision, scale, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledLong = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$4(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        Function2 & Serializable & scala.Serializable binaryWriterUsingUnscaledBytes = (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeDecimalWriter$5(this, precision, scale, numBytes, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = this.writeLegacyParquetFormat();
        if (!bl3) {
            bl = true;
            bl2 = bl3;
            if (precision <= Decimal$.MODULE$.MAX_INT_DIGITS()) {
                return int32Writer;
            }
        }
        if (bl && precision <= Decimal$.MODULE$.MAX_LONG_DIGITS()) {
            return int64Writer;
        }
        if (true != bl3) return binaryWriterUsingUnscaledBytes;
        if (precision > Decimal$.MODULE$.MAX_LONG_DIGITS()) return binaryWriterUsingUnscaledBytes;
        return binaryWriterUsingUnscaledLong;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Function2<SpecializedGetters, Object, BoxedUnit> makeArrayWriter(ArrayType arrayType) {
        boolean bl;
        Function2<SpecializedGetters, Object, BoxedUnit> elementWriter = this.makeWriter(arrayType.elementType(), this.makeWriter$default$2());
        Tuple2.mcZZ.sp sp2 = new Tuple2.mcZZ.sp(this.writeLegacyParquetFormat(), arrayType.containsNull());
        if (sp2 != null && !(bl = sp2._1$mcZ$sp())) {
            return this.threeLevelArrayWriter$1("list", "element", elementWriter);
        }
        if (sp2 != null) {
            boolean bl2 = sp2._1$mcZ$sp();
            boolean bl3 = sp2._2$mcZ$sp();
            if (bl2 && bl3) {
                return this.threeLevelArrayWriter$1("bag", "array", elementWriter);
            }
        }
        if (sp2 == null) throw new MatchError((Object)sp2);
        boolean bl4 = sp2._1$mcZ$sp();
        boolean bl5 = sp2._2$mcZ$sp();
        if (true != bl4) throw new MatchError((Object)sp2);
        if (false != bl5) throw new MatchError((Object)sp2);
        return this.twoLevelArrayWriter$1("array", elementWriter);
    }

    private Function2<SpecializedGetters, Object, BoxedUnit> makeMapWriter(MapType mapType) {
        Function2<SpecializedGetters, Object, BoxedUnit> keyWriter = this.makeWriter(mapType.keyType(), this.makeWriter$default$2());
        Function2<SpecializedGetters, Object, BoxedUnit> valueWriter = this.makeWriter(mapType.valueType(), this.makeWriter$default$2());
        String repeatedGroupName = this.writeLegacyParquetFormat() ? "map" : "key_value";
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeMapWriter$1(this, repeatedGroupName, keyWriter, valueWriter, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    private void consumeMessage(Function0<BoxedUnit> f) {
        this.recordConsumer().startMessage();
        f.apply$mcV$sp();
        this.recordConsumer().endMessage();
    }

    private void consumeGroup(Function0<BoxedUnit> f) {
        this.recordConsumer().startGroup();
        f.apply$mcV$sp();
        this.recordConsumer().endGroup();
    }

    private void consumeField(String field, int index, Function0<BoxedUnit> f) {
        this.recordConsumer().startField(field, index);
        f.apply$mcV$sp();
        this.recordConsumer().endField(field, index);
    }

    public static final /* synthetic */ String $anonfun$init$2(GeoParquetWriteSupport $this, int x$1) {
        return $this.schema().apply(x$1).name();
    }

    public static final /* synthetic */ void $anonfun$init$3(GeoParquetWriteSupport $this, Configuration configuration$1, String name) {
        Option$.MODULE$.apply((Object)configuration$1.get(new StringBuilder(1).append(GeoParquetMetaData$.MODULE$.GEOPARQUET_CRS_KEY()).append(".").append(name).toString())).foreach((Function1 & Serializable & scala.Serializable)x0$2 -> {
            Option option;
            String string = x0$2;
            if ("".equals(string)) {
                option = $this.geoParquetColumnCrsMap().put((Object)name, (Object)None$.MODULE$);
            } else if (string != null) {
                String string2 = string;
                option = $this.geoParquetColumnCrsMap().put((Object)name, (Object)new Some((Object)JsonMethods$.MODULE$.parse(org.json4s.package$.MODULE$.string2JsonInput(string2), JsonMethods$.MODULE$.parse$default$2(), JsonMethods$.MODULE$.parse$default$3())));
            } else {
                throw new MatchError((Object)string);
            }
            return option;
        });
    }

    public static final /* synthetic */ void $anonfun$makeWriter$1(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBoolean(row.getBoolean(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$2(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getByte(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$3(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger((int)row.getShort(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$4(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger($this.dateRebaseFunc().apply$mcII$sp(row.getInt(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$5(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addInteger(row.getInt(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$6(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addLong(row.getLong(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$7(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addFloat(row.getFloat(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$8(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addDouble(row.getDouble(ordinal));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$9(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getUTF8String(ordinal).getBytes()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$10(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = $this.int96RebaseFunc().apply$mcJJ$sp(row.getLong(ordinal));
        Tuple2 tuple2 = DateTimeUtils$.MODULE$.toJulianDay(micros);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int julianDay = tuple2._1$mcI$sp();
        long timeOfDayNanos = tuple2._2$mcJ$sp();
        Tuple2.mcIJ.sp sp2 = new Tuple2.mcIJ.sp(julianDay, timeOfDayNanos);
        Tuple2.mcIJ.sp sp3 = sp2;
        int julianDay2 = sp3._1$mcI$sp();
        long timeOfDayNanos2 = sp3._2$mcJ$sp();
        ByteBuffer buf = ByteBuffer.wrap($this.timestampBuffer());
        buf.order(ByteOrder.LITTLE_ENDIAN).putLong(timeOfDayNanos2).putInt(julianDay2);
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.timestampBuffer()));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$11(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        $this.recordConsumer().addLong($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$12(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        long micros = row.getLong(ordinal);
        long millis = DateTimeUtils$.MODULE$.microsToMillis($this.timestampRebaseFunc().apply$mcJJ$sp(micros));
        $this.recordConsumer().addLong(millis);
    }

    public static final /* synthetic */ void $anonfun$makeWriter$13(GeoParquetWriteSupport $this, SpecializedGetters row, int ordinal) {
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])row.getBinary(ordinal)));
    }

    public static final /* synthetic */ void $anonfun$makeWriter$19(GeoParquetWriteSupport $this, GeometryColumnInfo geometryColumnInfo$1, SpecializedGetters row, int ordinal) {
        block0: {
            byte[] serializedGeometry = row.getBinary(ordinal);
            Geometry geom = GeometryUDT$.MODULE$.deserialize(serializedGeometry);
            WKBWriter wkbWriter = new WKBWriter(GeomUtils.getDimension(geom));
            $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])wkbWriter.write(geom)));
            if (geometryColumnInfo$1 == null) break block0;
            geometryColumnInfo$1.update(geom);
        }
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$2(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addInteger((int)unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$3(GeoParquetWriteSupport $this, int precision$1, int scale$1, SpecializedGetters row, int ordinal) {
        long unscaledLong = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        $this.recordConsumer().addLong(unscaledLong);
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$4(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        long unscaled = row.getDecimal(ordinal, precision$1, scale$1).toUnscaledLong();
        int i = 0;
        int shift = 8 * (numBytes$1 - 1);
        while (i < numBytes$1) {
            $this.decimalBuffer()[i] = (byte)(unscaled >> shift);
            ++i;
            shift -= 8;
        }
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])$this.decimalBuffer(), (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeDecimalWriter$5(GeoParquetWriteSupport $this, int precision$1, int scale$1, int numBytes$1, SpecializedGetters row, int ordinal) {
        byte[] byArray;
        Decimal decimal = row.getDecimal(ordinal, precision$1, scale$1);
        byte[] bytes = decimal.toJavaBigDecimal().unscaledValue().toByteArray();
        if (bytes.length == numBytes$1) {
            byArray = bytes;
        } else {
            byte signByte = BoxesRunTime.unboxToByte((Object)new ArrayOps.ofByte(Predef$.MODULE$.byteArrayOps(bytes)).head()) < 0 ? (byte)-1 : 0;
            Arrays.fill($this.decimalBuffer(), 0, numBytes$1 - bytes.length, signByte);
            System.arraycopy(bytes, 0, $this.decimalBuffer(), numBytes$1 - bytes.length, bytes.length);
            byArray = $this.decimalBuffer();
        }
        byte[] fixedLengthBytes = byArray;
        $this.recordConsumer().addBinary(Binary.fromReusedByteArray((byte[])fixedLengthBytes, (int)0, (int)numBytes$1));
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$1, String elementFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < array.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                if (array.isNullAt(i$2.elem)) break block0;
                                $this.consumeField(elementFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i$2.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    private final Function2 threeLevelArrayWriter$1(String repeatedGroupName, String elementFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$1(this, repeatedGroupName, elementFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeArrayWriter$6(GeoParquetWriteSupport $this, String repeatedFieldName$1, Function2 elementWriter$1, SpecializedGetters row, int ordinal) {
        ArrayData array = row.getArray(ordinal);
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (array.numElements() <= 0) break block0;
                $this.consumeField(repeatedFieldName$1, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    for (int i = 0; i < array.numElements(); ++i) {
                        elementWriter$1.apply((Object)array, (Object)BoxesRunTime.boxToInteger((int)i));
                    }
                });
            }
        });
    }

    private final Function2 twoLevelArrayWriter$1(String repeatedFieldName, Function2 elementWriter$1) {
        return (Function2 & Serializable & scala.Serializable)(row, ordinal) -> {
            GeoParquetWriteSupport.$anonfun$makeArrayWriter$6(this, repeatedFieldName, elementWriter$1, row, BoxesRunTime.unboxToInt((Object)ordinal));
            return BoxedUnit.UNIT;
        };
    }

    public static final /* synthetic */ void $anonfun$makeMapWriter$1(GeoParquetWriteSupport $this, String repeatedGroupName$2, Function2 keyWriter$1, Function2 valueWriter$1, SpecializedGetters row, int ordinal) {
        MapData map = row.getMap(ordinal);
        ArrayData keyArray = map.keyArray();
        ArrayData valueArray = map.valueArray();
        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            block0: {
                if (map.numElements() <= 0) break block0;
                $this.consumeField(repeatedGroupName$2, 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                    IntRef i = IntRef.create((int)0);
                    while (i.elem < map.numElements()) {
                        $this.consumeGroup((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                            block0: {
                                $this.consumeField("key", 0, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> keyWriter$1.apply((Object)keyArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                                if (map.valueArray().isNullAt(i$3.elem)) break block0;
                                $this.consumeField("value", 1, (Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> valueWriter$1.apply((Object)valueArray, (Object)BoxesRunTime.boxToInteger((int)i$3.elem)));
                            }
                        });
                        ++i.elem;
                    }
                });
            }
        });
    }

    public GeoParquetWriteSupport() {
        Logging.$init$((Logging)this);
        this.timestampBuffer = new byte[12];
        this.decimalBuffer = new byte[Decimal$.MODULE$.minBytesForPrecision()[DecimalType$.MODULE$.MAX_PRECISION()]];
        this.datetimeRebaseMode = LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_REBASE_MODE_IN_WRITE()));
        this.dateRebaseFunc = DataSourceUtils$.MODULE$.createDateRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.timestampRebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.datetimeRebaseMode(), "Parquet");
        this.int96RebaseMode = LegacyBehaviorPolicy$.MODULE$.withName((String)SQLConf$.MODULE$.get().getConf(SQLConf$.MODULE$.PARQUET_INT96_REBASE_MODE_IN_WRITE()));
        this.int96RebaseFunc = DataSourceUtils$.MODULE$.createTimestampRebaseFuncInWrite(this.int96RebaseMode(), "Parquet INT96");
        this.geometryColumnInfoMap = Map$.MODULE$.empty();
        this.geoParquetVersion = None$.MODULE$;
        this.defaultGeoParquetCrs = None$.MODULE$;
        this.geoParquetColumnCrsMap = Map$.MODULE$.empty();
    }

    public static class GeometryColumnBoundingBox {
        private double minX;
        private double minY;
        private double maxX;
        private double maxY;

        public double minX() {
            return this.minX;
        }

        public void minX_$eq(double x$1) {
            this.minX = x$1;
        }

        public double minY() {
            return this.minY;
        }

        public void minY_$eq(double x$1) {
            this.minY = x$1;
        }

        public double maxX() {
            return this.maxX;
        }

        public void maxX_$eq(double x$1) {
            this.maxX = x$1;
        }

        public double maxY() {
            return this.maxY;
        }

        public void maxY_$eq(double x$1) {
            this.maxY = x$1;
        }

        public void update(Geometry geom) {
            Envelope env = geom.getEnvelopeInternal();
            this.minX_$eq(scala.math.package$.MODULE$.min(this.minX(), env.getMinX()));
            this.minY_$eq(scala.math.package$.MODULE$.min(this.minY(), env.getMinY()));
            this.maxX_$eq(scala.math.package$.MODULE$.max(this.maxX(), env.getMaxX()));
            this.maxY_$eq(scala.math.package$.MODULE$.max(this.maxY(), env.getMaxY()));
        }

        public GeometryColumnBoundingBox(double minX, double minY, double maxX, double maxY) {
            this.minX = minX;
            this.minY = minY;
            this.maxX = maxX;
            this.maxY = maxY;
        }
    }

    public static class GeometryColumnInfo {
        private final GeometryColumnBoundingBox bbox = new GeometryColumnBoundingBox(GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$1(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$2(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$3(), GeoParquetWriteSupport$GeometryColumnBoundingBox$.MODULE$.$lessinit$greater$default$4());
        private final Set<String> seenGeometryTypes = Set$.MODULE$.empty();

        public GeometryColumnBoundingBox bbox() {
            return this.bbox;
        }

        public Set<String> seenGeometryTypes() {
            return this.seenGeometryTypes;
        }

        public void update(Geometry geom) {
            this.bbox().update(geom);
            Coordinate coordinate = geom.getCoordinate();
            boolean hasZ = coordinate != null ? !Double.isNaN(coordinate.getZ()) : false;
            String geometryType = !hasZ ? geom.getGeometryType() : new StringBuilder(2).append(geom.getGeometryType()).append(" Z").toString();
            this.seenGeometryTypes().add((Object)geometryType);
        }
    }
}

