/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.core.Serde;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;
import org.apache.sedona.viz.core.ImageSerializableWrapper;

public class ImageWrapperSerializer
extends Serializer<ImageSerializableWrapper> {
    static final Logger log = Logger.getLogger(ImageWrapperSerializer.class);

    public void write(Kryo kryo, Output output, ImageSerializableWrapper object) {
        try {
            log.debug((Object)"Serializing ImageSerializableWrapper...");
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)object.getImage(), "png", byteArrayOutputStream);
            output.writeInt(byteArrayOutputStream.size());
            output.write(byteArrayOutputStream.toByteArray());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public byte[] writeImage(ImageSerializableWrapper object) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            ImageIO.write((RenderedImage)object.getImage(), "png", byteArrayOutputStream);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        int arraySize = byteArrayOutputStream.size();
        Output output = new Output(arraySize + 4);
        output.writeInt(arraySize);
        output.write(byteArrayOutputStream.toByteArray());
        return output.toBytes();
    }

    public ImageSerializableWrapper read(Kryo kryo, Input input, Class<ImageSerializableWrapper> type) {
        try {
            log.debug((Object)"De-serializing ImageSerializableWrapper...");
            int length = input.readInt();
            byte[] inputData = new byte[length];
            input.read(inputData);
            return new ImageSerializableWrapper(ImageIO.read(new ByteArrayInputStream(inputData)));
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ImageSerializableWrapper readImage(byte[] inputArray) {
        Kryo kryo = new Kryo();
        Input input = new Input(inputArray);
        return this.read(kryo, input, (Class)ImageSerializableWrapper.class);
    }
}

