/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.sphere;

import net.sf.geographiclib.Geodesic;
import net.sf.geographiclib.GeodesicData;
import net.sf.geographiclib.PolygonArea;
import net.sf.geographiclib.PolygonResult;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;

public class Spheroid {
    public static double distance(Geometry geom1, Geometry geom2) {
        Coordinate coordinate1 = geom1.getGeometryType().equals("Point") ? geom1.getCoordinate() : geom1.getCentroid().getCoordinate();
        Coordinate coordinate2 = geom2.getGeometryType().equals("Point") ? geom2.getCoordinate() : geom2.getCentroid().getCoordinate();
        double lat1 = coordinate1.getX();
        double lon1 = coordinate1.getY();
        double lat2 = coordinate2.getX();
        double lon2 = coordinate2.getY();
        GeodesicData g2 = Geodesic.WGS84.Inverse(lat1, lon1, lat2, lon2);
        return g2.s12;
    }

    public static double length(Geometry geom) {
        if (geom.getGeometryType().equals("Polygon") || geom.getGeometryType().equals("LineString")) {
            PolygonArea p = new PolygonArea(Geodesic.WGS84, true);
            Coordinate[] coordinates = geom.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                p.AddPoint(coordinates[i].getX(), coordinates[i].getY());
            }
            PolygonResult compute = p.Compute();
            return compute.perimeter;
        }
        if (geom.getGeometryType().equals("MultiPolygon") || geom.getGeometryType().equals("MultiLineString") || geom.getGeometryType().equals("GeometryCollection")) {
            double length = 0.0;
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                length += Spheroid.length(geom.getGeometryN(i));
            }
            return length;
        }
        return 0.0;
    }

    public static double area(Geometry geom) {
        if (geom.getGeometryType().equals("Polygon")) {
            PolygonArea p = new PolygonArea(Geodesic.WGS84, false);
            Coordinate[] coordinates = geom.getCoordinates();
            for (int i = 0; i < coordinates.length; ++i) {
                p.AddPoint(coordinates[i].getX(), coordinates[i].getY());
            }
            PolygonResult compute = p.Compute();
            return Math.abs(compute.area);
        }
        if (geom.getGeometryType().equals("MultiPolygon") || geom.getGeometryType().equals("GeometryCollection")) {
            double area = 0.0;
            for (int i = 0; i < geom.getNumGeometries(); ++i) {
                area += Spheroid.area(geom.getGeometryN(i));
            }
            return area;
        }
        return 0.0;
    }
}

