/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.common.raster;

import java.awt.Point;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import javax.media.jai.RasterFactory;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;

public class MapAlgebra {
    public static double[] bandAsArray(GridCoverage2D rasterGeom, int bandIndex) {
        int numBands = rasterGeom.getNumSampleDimensions();
        if (bandIndex < 1 || bandIndex > numBands) {
            return null;
        }
        Raster raster = rasterGeom.getRenderedImage().getData();
        int width = raster.getWidth();
        int height = raster.getHeight();
        double[] bandValues = new double[width * height];
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                bandValues[y * width + x] = raster.getSample(x, y, bandIndex - 1);
            }
        }
        return bandValues;
    }

    public static GridCoverage2D addBandFromArray(GridCoverage2D rasterGeom, double[] bandValues, int bandIndex) {
        int numBands = rasterGeom.getNumSampleDimensions();
        if (bandIndex < 1 || bandIndex > numBands + 1) {
            throw new IllegalArgumentException("Band index is out of bounds. Must be between 1 and " + (numBands + 1) + ")");
        }
        if (bandIndex == numBands + 1) {
            return MapAlgebra.copyRasterAndAppendBand(rasterGeom, bandValues);
        }
        return MapAlgebra.copyRasterAndReplaceBand(rasterGeom, bandIndex, bandValues);
    }

    public static GridCoverage2D addBandFromArray(GridCoverage2D rasterGeom, double[] bandValues) {
        return MapAlgebra.addBandFromArray(rasterGeom, bandValues, rasterGeom.getNumSampleDimensions() + 1);
    }

    private static GridCoverage2D copyRasterAndAppendBand(GridCoverage2D gridCoverage2D, double[] bandValues) {
        RenderedImage originalImage = gridCoverage2D.getRenderedImage();
        Raster raster = originalImage.getData();
        Point location = gridCoverage2D.getRenderedImage().getData().getBounds().getLocation();
        WritableRaster wr = RasterFactory.createBandedRaster((int)raster.getDataBuffer().getDataType(), (int)originalImage.getWidth(), (int)originalImage.getHeight(), (int)(gridCoverage2D.getNumSampleDimensions() + 1), (Point)location);
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                double[] pixels = raster.getPixel(i, j, (double[])null);
                double[] copiedPixels = new double[pixels.length + 1];
                System.arraycopy(pixels, 0, copiedPixels, 0, pixels.length);
                copiedPixels[pixels.length] = bandValues[j * raster.getWidth() + i];
                wr.setPixel(i, j, copiedPixels);
            }
        }
        GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        return gridCoverageFactory.create((CharSequence)gridCoverage2D.getName(), wr, gridCoverage2D.getEnvelope());
    }

    private static GridCoverage2D copyRasterAndReplaceBand(GridCoverage2D gridCoverage2D, int bandIndex, double[] bandValues) {
        if (bandIndex < 1 || bandIndex > gridCoverage2D.getNumSampleDimensions()) {
            throw new IllegalArgumentException("Band index is out of bounds. Must be between 1 and " + gridCoverage2D.getNumSampleDimensions() + ")");
        }
        RenderedImage originalImage = gridCoverage2D.getRenderedImage();
        Raster raster = originalImage.getData();
        WritableRaster wr = raster.createCompatibleWritableRaster();
        for (int i = 0; i < raster.getWidth(); ++i) {
            for (int j = 0; j < raster.getHeight(); ++j) {
                double[] bands = raster.getPixel(i, j, (double[])null);
                bands[bandIndex - 1] = bandValues[j * raster.getWidth() + i];
                wr.setPixel(i, j, bands);
            }
        }
        GridCoverageFactory gridCoverageFactory = CoverageFactoryFinder.getGridCoverageFactory(null);
        return gridCoverageFactory.create((CharSequence)gridCoverage2D.getName(), wr, gridCoverage2D.getEnvelope());
    }
}

