/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.flink.expressions;

import org.apache.flink.table.annotation.DataTypeHint;
import org.apache.flink.table.functions.ScalarFunction;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.GeometryType;
import org.apache.sedona.core.formatMapper.FormatUtils;
import org.apache.spark.sql.sedona_sql.expressions.geohash.GeoHashDecoder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.io.ParseException;
import org.locationtech.jts.io.WKBReader;
import org.locationtech.jts.io.gml2.GMLReader;
import org.locationtech.jts.io.kml.KMLReader;
import scala.Option;

public class Constructors {
    private static Geometry getGeometryByType(String geom, String inputDelimiter, GeometryType geometryType) throws ParseException {
        FileDataSplitter delimiter = inputDelimiter == null ? FileDataSplitter.CSV : FileDataSplitter.getFileDataSplitter((String)inputDelimiter);
        FormatUtils formatUtils = new FormatUtils(delimiter, false, geometryType);
        return formatUtils.readGeometry(geom);
    }

    private static Geometry getGeometryByFileData(String wktString, FileDataSplitter dataSplitter) throws ParseException {
        FormatUtils formatUtils = new FormatUtils(dataSplitter, false);
        return formatUtils.readGeometry(wktString);
    }

    public static class ST_MLineFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.mLineFromText((String)wkt, (int)srid);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt) throws ParseException {
            return org.apache.sedona.common.Constructors.mLineFromText((String)wkt, (int)0);
        }
    }

    public static class ST_MPolyFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt, @DataTypeHint(value="Int") Integer srid) throws ParseException {
            return org.apache.sedona.common.Constructors.mPolyFromText((String)wkt, (int)srid);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkt) throws ParseException {
            return org.apache.sedona.common.Constructors.mPolyFromText((String)wkt, (int)0);
        }
    }

    public static class ST_GeomFromKML
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String kml) throws ParseException {
            return new KMLReader().read(kml);
        }
    }

    public static class ST_GeomFromGML
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String gml) throws ParseException {
            GMLReader reader = new GMLReader();
            try {
                return reader.read(gml, new GeometryFactory());
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
    }

    public static class ST_GeomFromGeoHash
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String value, @DataTypeHint(value="Int") Integer precision) throws ParseException {
            Option optionPrecision = Option.apply((Object)precision);
            return GeoHashDecoder.decode((String)value, (Option)optionPrecision);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String value) throws ParseException {
            return this.eval(value, null);
        }
    }

    public static class ST_GeomFromGeoJSON
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String geoJson) throws ParseException {
            return Constructors.getGeometryByFileData(geoJson, FileDataSplitter.GEOJSON);
        }
    }

    public static class ST_GeomFromWKB
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wkbString) throws ParseException {
            return Constructors.getGeometryByFileData(wkbString, FileDataSplitter.WKB);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Bytes") byte[] wkb) throws ParseException {
            WKBReader wkbReader = new WKBReader();
            return wkbReader.read(wkb);
        }
    }

    public static class ST_GeomFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT((String)wktString, (int)0);
        }
    }

    public static class ST_GeomFromWKT
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String wktString) throws ParseException {
            return org.apache.sedona.common.Constructors.geomFromWKT((String)wktString, (int)0);
        }
    }

    public static class ST_PolygonFromEnvelope
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double minX, @DataTypeHint(value="Double") Double minY, @DataTypeHint(value="Double") Double maxX, @DataTypeHint(value="Double") Double maxY) {
            Coordinate[] coordinates;
            coordinates = new Coordinate[]{new Coordinate(minX.doubleValue(), minY.doubleValue()), new Coordinate(minX.doubleValue(), maxY.doubleValue()), new Coordinate(maxX.doubleValue(), maxY.doubleValue()), new Coordinate(maxX.doubleValue(), minY.doubleValue()), coordinates[0]};
            GeometryFactory geometryFactory = new GeometryFactory();
            return geometryFactory.createPolygon(coordinates);
        }
    }

    public static class ST_PolygonFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String polygonString, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return Constructors.getGeometryByType(polygonString, inputDelimiter, GeometryType.POLYGON);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String polygonString) throws ParseException {
            return this.eval(polygonString, null);
        }
    }

    public static class ST_LineStringFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return new ST_LineFromText().eval(lineString, inputDelimiter);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString) throws ParseException {
            return this.eval(lineString, null);
        }
    }

    public static class ST_LineFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return Constructors.getGeometryByType(lineString, inputDelimiter, GeometryType.LINESTRING);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String lineString) throws ParseException {
            return this.eval(lineString, null);
        }
    }

    public static class ST_PointFromText
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s, @DataTypeHint(value="String") String inputDelimiter) throws ParseException {
            return Constructors.getGeometryByType(s, inputDelimiter, GeometryType.POINT);
        }

        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="String") String s) throws ParseException {
            return this.eval(s, null);
        }
    }

    public static class ST_Point
    extends ScalarFunction {
        @DataTypeHint(value="RAW", bridgedTo=Geometry.class)
        public Geometry eval(@DataTypeHint(value="Double") Double x, @DataTypeHint(value="Double") Double y) throws ParseException {
            Coordinate coordinates = new Coordinate(x.doubleValue(), y.doubleValue());
            GeometryFactory geometryFactory = new GeometryFactory();
            return geometryFactory.createPoint(coordinates);
        }
    }
}

