/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.util.Iterator;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.CollectionInfo;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointIteratorAbstract
implements PointFeatureIterator,
Iterator<PointFeature> {
    protected boolean calcBounds;
    protected CollectionInfo info;
    private LatLonRect bb;
    private double minTime = Double.MAX_VALUE;
    private double maxTime = -1.7976931348623157E308;
    private int count;

    protected PointIteratorAbstract() {
    }

    public void setCalculateBounds(CollectionInfo info) {
        this.calcBounds = info != null;
        this.info = info;
    }

    protected void calcBounds(PointFeature pf) {
        ++this.count;
        if (!this.calcBounds) {
            return;
        }
        if (pf == null) {
            return;
        }
        if (this.bb == null) {
            this.bb = new LatLonRect(pf.getLocation().getLatLon(), 0.001, 0.001);
        } else {
            this.bb.extend(pf.getLocation().getLatLon());
        }
        double obsTime = pf.getObservationTime();
        this.minTime = Math.min(this.minTime, obsTime);
        this.maxTime = Math.max(this.maxTime, obsTime);
    }

    protected void finishCalcBounds() {
        if (!this.calcBounds) {
            return;
        }
        if (this.bb != null && this.bb.crossDateline() && this.bb.getWidth() > 350.0) {
            double lat_min = this.bb.getLowerLeftPoint().getLatitude();
            double deltaLat = this.bb.getUpperLeftPoint().getLatitude() - lat_min;
            this.bb = new LatLonRect(LatLonPoint.create(lat_min, -180.0), deltaLat, 360.0);
        }
        this.info.bbox = this.bb;
        this.info.minTime = this.minTime;
        this.info.maxTime = this.maxTime;
        this.info.nobs = this.count;
        this.info.nfeatures = this.count;
        this.info.setComplete();
    }
}

