/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.viz.utils;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.Bucket;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.s3.model.PutObjectRequest;
import com.amazonaws.services.s3.model.S3Object;
import com.amazonaws.services.s3.model.S3ObjectInputStream;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.apache.log4j.Logger;

public class S3Operator {
    public static final Logger logger = Logger.getLogger(S3Operator.class);
    private final AmazonS3 s3client;

    public S3Operator(String regionName, String accessKey, String secretKey) {
        Regions region = Regions.fromName((String)regionName);
        BasicAWSCredentials awsCreds = new BasicAWSCredentials(accessKey, secretKey);
        this.s3client = (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(region)).withCredentials((AWSCredentialsProvider)new AWSStaticCredentialsProvider((AWSCredentials)awsCreds))).build();
        logger.info((Object)"[Sedona-Viz][Constructor] Initialized a S3 client");
    }

    public boolean createBucket(String bucketName) {
        Bucket bucket = this.s3client.createBucket(bucketName);
        logger.info((Object)("[Sedona-Viz][createBucket] Created a bucket: " + bucket.toString()));
        return true;
    }

    public boolean deleteImage(String bucketName, String path) {
        this.s3client.deleteObject(bucketName, path);
        logger.info((Object)"[Sedona-Viz][deleteImage] Deleted an image if exist");
        return true;
    }

    public boolean putImage(String bucketName, String path, BufferedImage rasterImage) throws IOException {
        this.deleteImage(bucketName, path);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ImageIO.write((RenderedImage)rasterImage, "png", outputStream);
        byte[] buffer = outputStream.toByteArray();
        ByteArrayInputStream inputStream = new ByteArrayInputStream(buffer);
        ObjectMetadata metadata = new ObjectMetadata();
        metadata.setContentLength((long)buffer.length);
        this.s3client.putObject(new PutObjectRequest(bucketName, path, (InputStream)inputStream, metadata));
        ((InputStream)inputStream).close();
        outputStream.close();
        logger.info((Object)"[Sedona-Viz][putImage] Put an image");
        return true;
    }

    public BufferedImage getImage(String bucketName, String path) throws Exception {
        logger.debug((Object)"[Sedona-Viz][getImage] Start");
        S3Object s3Object = this.s3client.getObject(bucketName, path);
        S3ObjectInputStream inputStream = s3Object.getObjectContent();
        BufferedImage rasterImage = ImageIO.read((InputStream)inputStream);
        inputStream.close();
        s3Object.close();
        logger.info((Object)"[Sedona-Viz][getImage] Got an image");
        return rasterImage;
    }
}

