/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.showcase;

import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.sedona.core.enums.FileDataSplitter;
import org.apache.sedona.core.enums.IndexType;
import org.apache.sedona.core.formatMapper.EarthdataHDFPointMapper;
import org.apache.sedona.core.showcase.ScalaEarthdataMapperRunnableExample$delayedInit$body;
import org.apache.sedona.core.spatialOperator.RangeQuery;
import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.spatialRDD.PointRDD;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.api.java.JavaSparkContext$;
import org.apache.spark.storage.StorageLevel$;
import org.locationtech.jts.geom.Envelope;
import scala.App;
import scala.Function0;
import scala.Predef$;
import scala.collection.mutable.ListBuffer;
import scala.runtime.BoxedUnit;

public final class ScalaEarthdataMapperRunnableExample$
implements App {
    public static ScalaEarthdataMapperRunnableExample$ MODULE$;
    private SparkConf conf;
    private SparkContext sc;
    private String InputLocation;
    private FileDataSplitter splitter;
    private IndexType indexType;
    private Envelope queryEnvelope;
    private int numPartitions;
    private int loopTimes;
    private int HDFIncrement;
    private int HDFOffset;
    private String HDFRootGroupName;
    private String HDFDataVariableName;
    private String urlPrefix;
    private String[] HDFDataVariableList;
    private final long executionStart;
    private String[] scala$App$$_args;
    private final ListBuffer<Function0<BoxedUnit>> scala$App$$initCode;

    static {
        new ScalaEarthdataMapperRunnableExample$();
    }

    public String[] args() {
        return App.args$((App)this);
    }

    public void delayedInit(Function0<BoxedUnit> body2) {
        App.delayedInit$((App)this, body2);
    }

    public void main(String[] args) {
        App.main$((App)this, (String[])args);
    }

    public long executionStart() {
        return this.executionStart;
    }

    public String[] scala$App$$_args() {
        return this.scala$App$$_args;
    }

    public void scala$App$$_args_$eq(String[] x$1) {
        this.scala$App$$_args = x$1;
    }

    public ListBuffer<Function0<BoxedUnit>> scala$App$$initCode() {
        return this.scala$App$$initCode;
    }

    public void scala$App$_setter_$executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public final void scala$App$_setter_$scala$App$$initCode_$eq(ListBuffer<Function0<BoxedUnit>> x$1) {
        this.scala$App$$initCode = x$1;
    }

    public SparkConf conf() {
        return this.conf;
    }

    public SparkContext sc() {
        return this.sc;
    }

    public String InputLocation() {
        return this.InputLocation;
    }

    public FileDataSplitter splitter() {
        return this.splitter;
    }

    public IndexType indexType() {
        return this.indexType;
    }

    public Envelope queryEnvelope() {
        return this.queryEnvelope;
    }

    public int numPartitions() {
        return this.numPartitions;
    }

    public int loopTimes() {
        return this.loopTimes;
    }

    public int HDFIncrement() {
        return this.HDFIncrement;
    }

    public int HDFOffset() {
        return this.HDFOffset;
    }

    public String HDFRootGroupName() {
        return this.HDFRootGroupName;
    }

    public String HDFDataVariableName() {
        return this.HDFDataVariableName;
    }

    public String urlPrefix() {
        return this.urlPrefix;
    }

    public String[] HDFDataVariableList() {
        return this.HDFDataVariableList;
    }

    public void testSpatialRangeQuery() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.InputLocation(), Predef$.MODULE$.int2Integer(this.numPartitions()), earthdataHDFPoint, StorageLevel$.MODULE$.MEMORY_ONLY());
        for (int i = 0; i < this.loopTimes(); ++i) {
            long resultSize = 0L;
            resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, this.queryEnvelope(), SpatialPredicate.COVERED_BY, false).count();
        }
    }

    public void testSpatialRangeQueryUsingIndex() {
        EarthdataHDFPointMapper earthdataHDFPoint = new EarthdataHDFPointMapper(this.HDFIncrement(), this.HDFOffset(), this.HDFRootGroupName(), this.HDFDataVariableList(), this.HDFDataVariableName(), this.urlPrefix());
        PointRDD spatialRDD = new PointRDD(JavaSparkContext$.MODULE$.fromSparkContext(this.sc()), this.InputLocation(), Predef$.MODULE$.int2Integer(this.numPartitions()), earthdataHDFPoint, StorageLevel$.MODULE$.MEMORY_ONLY());
        spatialRDD.buildIndex(IndexType.RTREE, false);
        for (int i = 0; i < this.loopTimes(); ++i) {
            long resultSize = 0L;
            resultSize = RangeQuery.SpatialRangeQuery(spatialRDD, this.queryEnvelope(), SpatialPredicate.COVERED_BY, true).count();
        }
    }

    public final void delayedEndpoint$org$apache$sedona$core$showcase$ScalaEarthdataMapperRunnableExample$1() {
        this.conf = new SparkConf().setAppName("EarthdataMapperRunnableExample").setMaster("local[2]");
        this.sc = new SparkContext(this.conf());
        Logger.getLogger((String)"org").setLevel(Level.WARN);
        Logger.getLogger((String)"akka").setLevel(Level.WARN);
        this.InputLocation = new StringBuilder(35).append(System.getProperty("user.dir")).append("/src/test/resources/modis/modis.csv").toString();
        this.splitter = FileDataSplitter.CSV;
        this.indexType = IndexType.RTREE;
        this.queryEnvelope = new Envelope(-90.01, -80.01, 30.01, 40.01);
        this.numPartitions = 5;
        this.loopTimes = 1;
        this.HDFIncrement = 5;
        this.HDFOffset = 2;
        this.HDFRootGroupName = "MOD_Swath_LST";
        this.HDFDataVariableName = "LST";
        this.urlPrefix = new StringBuilder(26).append(System.getProperty("user.dir")).append("/src/test/resources/modis/").toString();
        this.HDFDataVariableList = (String[])((Object[])new String[]{"LST", "QC", "Error_LST", "Emis_31", "Emis_32"});
        this.testSpatialRangeQuery();
        this.testSpatialRangeQueryUsingIndex();
        this.sc().stop();
        System.out.println("All Earthdata DEMOs passed!");
    }

    private ScalaEarthdataMapperRunnableExample$() {
        MODULE$ = this;
        App.$init$((App)this);
        this.delayedInit((Function0<BoxedUnit>)new ScalaEarthdataMapperRunnableExample$delayedInit$body(this));
    }
}

