/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import org.apache.sedona.core.spatialOperator.SpatialPredicate;
import org.apache.sedona.core.spatialOperator.SpatialPredicateEvaluators;
import org.apache.sedona.core.utils.HalfOpenRectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public abstract class JoinConditionMatcher
implements SpatialPredicateEvaluators.SpatialPredicateEvaluator {
    public boolean match(Geometry left, Geometry right, HalfOpenRectangle extent) {
        if (extent != null) {
            Point referencePoint;
            if (left instanceof Point || right instanceof Point) {
                return this.eval(left, right);
            }
            Envelope intersection = left.getEnvelopeInternal().intersection(right.getEnvelopeInternal());
            if (!intersection.isNull() && !extent.contains(referencePoint = JoinConditionMatcher.makePoint(intersection.getMinX(), intersection.getMinY(), left.getFactory()))) {
                return false;
            }
        }
        return this.eval(left, right);
    }

    private static Point makePoint(double x, double y, GeometryFactory factory) {
        return factory.createPoint(new Coordinate(x, y));
    }

    public static JoinConditionMatcher create(SpatialPredicate predicate) {
        switch (predicate) {
            case CONTAINS: {
                return new ContainsMatcher();
            }
            case INTERSECTS: {
                return new IntersectsMatcher();
            }
            case WITHIN: {
                return new WithinMatcher();
            }
            case COVERS: {
                return new CoversMatcher();
            }
            case COVERED_BY: {
                return new CoveredByMatcher();
            }
            case TOUCHES: {
                return new TouchesMatcher();
            }
            case OVERLAPS: {
                return new OverlapsMatcher();
            }
            case CROSSES: {
                return new CrossesMatcher();
            }
            case EQUALS: {
                return new EqualsMatcher();
            }
        }
        throw new IllegalArgumentException("Invalid spatial predicate: " + (Object)((Object)predicate));
    }

    private static class EqualsMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.EqualsEvaluator {
        private EqualsMatcher() {
        }
    }

    private static class CrossesMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.CrossesEvaluator {
        private CrossesMatcher() {
        }
    }

    private static class OverlapsMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.OverlapsEvaluator {
        private OverlapsMatcher() {
        }
    }

    private static class TouchesMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.TouchesEvaluator {
        private TouchesMatcher() {
        }
    }

    private static class CoveredByMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.CoveredByEvaluator {
        private CoveredByMatcher() {
        }
    }

    private static class CoversMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.CoversEvaluator {
        private CoversMatcher() {
        }
    }

    private static class WithinMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.WithinEvaluator {
        private WithinMatcher() {
        }
    }

    private static class IntersectsMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.IntersectsEvaluator {
        private IntersectsMatcher() {
        }
    }

    private static class ContainsMatcher
    extends JoinConditionMatcher
    implements SpatialPredicateEvaluators.ContainsEvaluator {
        private ContainsMatcher() {
        }
    }
}

