/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.sql.utils;

import java.io.Serializable;
import java.sql.Date;
import java.sql.Timestamp;
import org.apache.sedona.core.spatialRDD.SpatialRDD;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.expressions.GenericRowWithSchema;
import org.apache.spark.sql.sedona_sql.UDT.GeometryUDT$;
import org.apache.spark.sql.types.BooleanType;
import org.apache.spark.sql.types.ByteType;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.DateType;
import org.apache.spark.sql.types.DoubleType;
import org.apache.spark.sql.types.FloatType;
import org.apache.spark.sql.types.IntegerType;
import org.apache.spark.sql.types.LongType;
import org.apache.spark.sql.types.ShortType;
import org.apache.spark.sql.types.StringType;
import org.apache.spark.sql.types.StringType$;
import org.apache.spark.sql.types.StructField;
import org.apache.spark.sql.types.StructField$;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.sql.types.StructType$;
import org.apache.spark.sql.types.TimestampType;
import org.locationtech.jts.geom.Geometry;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction1;

public final class Adapter$ {
    public static final Adapter$ MODULE$ = new Adapter$();

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        SpatialRDD<Geometry> spatialRDD;
        if (dataFrame.schema().size() == 1) {
            spatialRDD = this.toSpatialRdd(dataFrame, 0, (Seq<String>)((Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        } else {
            List fieldList = dataFrame.schema().toList().map((Function1 & Serializable)f -> f.name());
            spatialRDD = this.toSpatialRdd(dataFrame, geometryFieldName, (Seq<String>)fieldList.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Adapter$.$anonfun$toSpatialRdd$2(geometryFieldName, p))));
        }
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, String geometryFieldName, Seq<String> fieldNames) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = this.toRdd(dataFrame, geometryFieldName).toJavaRDD();
        spatialRDD.fieldNames = fieldNames != null && fieldNames.nonEmpty() ? CollectionConverters$.MODULE$.SeqHasAsJava(fieldNames).asJava() : null;
        return spatialRDD;
    }

    private RDD<Geometry> toRdd(Dataset<Row> dataFrame, String geometryFieldName) {
        List fieldList = dataFrame.schema().toList().map((Function1 & Serializable)f -> f.name());
        int geomColId = fieldList.indexOf((Object)geometryFieldName);
        Predef$.MODULE$.assert(geomColId >= 0);
        return this.toRdd(dataFrame, geomColId);
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, int geometryColId, Seq<String> fieldNames) {
        SpatialRDD<Geometry> spatialRDD = new SpatialRDD<Geometry>();
        spatialRDD.rawSpatialRDD = this.toRdd(dataFrame, geometryColId).toJavaRDD();
        spatialRDD.fieldNames = fieldNames.nonEmpty() ? CollectionConverters$.MODULE$.SeqHasAsJava(fieldNames).asJava() : null;
        return spatialRDD;
    }

    public SpatialRDD<Geometry> toSpatialRdd(Dataset<Row> dataFrame, int geometryColId) {
        SpatialRDD<Geometry> spatialRDD;
        if (dataFrame.schema().size() == 1) {
            spatialRDD = this.toSpatialRdd(dataFrame, 0, (Seq<String>)((Seq)package$.MODULE$.List().apply((Seq)Nil$.MODULE$)));
        } else {
            List fieldList = dataFrame.schema().toList().map((Function1 & Serializable)f -> f.name());
            String geometryFieldName = (String)fieldList.apply(geometryColId);
            spatialRDD = this.toSpatialRdd(dataFrame, geometryColId, (Seq<String>)fieldList.filter((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)Adapter$.$anonfun$toSpatialRdd$4(geometryFieldName, p))));
        }
        return spatialRDD;
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, SparkSession sparkSession) {
        if (spatialRDD.fieldNames != null) {
            return this.toDf(spatialRDD, (Seq<String>)CollectionConverters$.MODULE$.ListHasAsScala(spatialRDD.fieldNames).asScala().toList(), sparkSession);
        }
        return this.toDf(spatialRDD, (Seq<String>)null, sparkSession);
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, Seq<String> fieldNames, SparkSession sparkSession) {
        RDD rowRdd = spatialRDD.rawSpatialRDD.rdd().map((Function1 & Serializable)geom -> {
            Seq<Object> stringRow = MODULE$.extractUserData((Geometry)geom);
            return Row$.MODULE$.fromSeq(stringRow);
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("geometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        if (fieldNames != null && fieldNames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((IterableOnce)fieldNames.map((Function1 & Serializable)f -> new StructField(f, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())));
        }
        StructType schema = StructType$.MODULE$.apply(cols);
        return sparkSession.createDataFrame(rowRdd, schema);
    }

    public <T extends Geometry> Dataset<Row> toDf(SpatialRDD<T> spatialRDD, StructType schema, SparkSession sparkSession) {
        RDD rdd = spatialRDD.rawSpatialRDD.rdd().map((Function1 & Serializable)geom -> {
            Seq<Object> stringRow = MODULE$.extractUserData((Geometry)geom);
            return MODULE$.castRowToSchema(stringRow, schema);
        }, ClassTag$.MODULE$.apply(Row.class));
        return sparkSession.sqlContext().createDataFrame(rdd, schema);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, SparkSession sparkSession) {
        return this.toDf(spatialPairRDD, null, null, sparkSession);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, Seq<String> leftFieldnames, Seq<String> rightFieldNames, SparkSession sparkSession) {
        RDD rowRdd = spatialPairRDD.rdd().map((Function1 & Serializable)f -> {
            Seq<Object> stringRow = MODULE$.extractUserData((Tuple2<Geometry, Geometry>)f, leftFieldnames, rightFieldNames);
            return Row$.MODULE$.fromSeq(stringRow);
        }, ClassTag$.MODULE$.apply(Row.class));
        Seq cols = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("leftgeometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())}));
        if (leftFieldnames != null && leftFieldnames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((IterableOnce)leftFieldnames.map((Function1 & Serializable)fName -> new StructField(fName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())));
        }
        cols = (Seq)cols.$plus$plus((IterableOnce)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new StructField[]{new StructField("rightgeometry", (DataType)GeometryUDT$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())})));
        if (rightFieldNames != null && rightFieldNames.nonEmpty()) {
            cols = (Seq)cols.$plus$plus((IterableOnce)rightFieldNames.map((Function1 & Serializable)fName -> new StructField(fName, (DataType)StringType$.MODULE$, StructField$.MODULE$.apply$default$3(), StructField$.MODULE$.apply$default$4())));
        }
        StructType schema = StructType$.MODULE$.apply(cols);
        return sparkSession.createDataFrame(rowRdd, schema);
    }

    public Dataset<Row> toDf(JavaPairRDD<Geometry, Geometry> spatialPairRDD, StructType schema, SparkSession sparkSession) {
        RDD rdd = spatialPairRDD.rdd().map((Function1 & Serializable)f -> {
            Seq<Object> stringRow = MODULE$.extractUserData((Tuple2<Geometry, Geometry>)f, (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))), (Seq<String>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{""}))));
            return MODULE$.castRowToSchema(stringRow, schema);
        }, ClassTag$.MODULE$.apply(Row.class));
        return sparkSession.sqlContext().createDataFrame(rdd, schema);
    }

    private Seq<Object> extractUserData(Geometry geom) {
        Seq seq;
        Object userData = geom.getUserData();
        Geometry geomWithoutUserData = geom.copy();
        geomWithoutUserData.setUserData(null);
        if (userData != null) {
            Geometry geometry = geomWithoutUserData;
            seq = Predef$.MODULE$.copyArrayToImmutableIndexedSeq(ArrayOps$.MODULE$.$plus$colon$extension(Predef$.MODULE$.refArrayOps((Object[])((String)userData).split("\t", -1)), (Object)geometry, ClassTag$.MODULE$.apply(Object.class)));
        } else {
            seq = (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom}));
        }
        return seq;
    }

    private Seq<Object> extractUserData(Tuple2<Geometry, Geometry> row, Seq<String> leftFieldnames, Seq<String> rightFieldnames) {
        Tuple2<Seq<Geometry>, Seq<String>> left = this.getGeomAndFields((Geometry)row._1(), leftFieldnames);
        Tuple2<Seq<Geometry>, Seq<String>> right = this.getGeomAndFields((Geometry)row._2(), rightFieldnames);
        Seq leftGeom = (Seq)left._1();
        Seq leftUserData = (Seq)left._2();
        Seq rightGeom = (Seq)right._1();
        Seq rightUserData = (Seq)right._2();
        return (Seq)((IterableOps)((IterableOps)leftGeom.$plus$plus((IterableOnce)leftUserData)).$plus$plus((IterableOnce)rightGeom)).$plus$plus((IterableOnce)rightUserData);
    }

    private RDD<Geometry> toRdd(Dataset<Row> dataFrame, int geometryColId) {
        return dataFrame.rdd().map((Function1 & Serializable)f -> {
            void var2_2;
            Geometry geometry = (Geometry)f.get(geometryColId);
            int fieldSize = f.size();
            ObjectRef userData = ObjectRef.create(null);
            if (fieldSize > 1) {
                userData.elem = "";
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(0), geometryColId).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    userData$1.elem = new StringBuilder(0).append((String)userData$1.elem).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(f.get(i)), "\t")).toString();
                });
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(geometryColId + 1), f.size()).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    userData$1.elem = new StringBuilder(0).append((String)userData$1.elem).append(Predef.any2stringadd$.MODULE$.$plus$extension(Predef$.MODULE$.any2stringadd(f.get(i)), "\t")).toString();
                });
                userData.elem = StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString((String)userData.elem), 1);
            }
            geometry.setUserData((String)userData.elem);
            return var2_2;
        }, ClassTag$.MODULE$.apply(Geometry.class));
    }

    private Tuple2<Seq<Geometry>, Seq<String>> getGeomAndFields(Geometry geom, Seq<String> fieldNames) {
        Tuple2 tuple2;
        if (fieldNames != null && fieldNames.nonEmpty()) {
            String userData = String.valueOf((String)geom.getUserData());
            String[] fields = userData.split("\t");
            Geometry geomWithoutUserData = geom.copy();
            geomWithoutUserData.setUserData(null);
            tuple2 = new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Geometry[]{geomWithoutUserData})), (Object)Predef$.MODULE$.copyArrayToImmutableIndexedSeq((Object)fields));
        } else {
            tuple2 = new Tuple2((Object)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Geometry[]{geom})), (Object)package$.MODULE$.Seq().apply((Seq)Nil$.MODULE$));
        }
        return tuple2;
    }

    private Row castRowToSchema(Seq<Object> stringRow, StructType schema) {
        Seq parsedRow = (Seq)((IterableOps)stringRow.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            DataType desiredDataType;
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            Object value = tuple2._1();
            int idx = tuple2._2$mcI$sp();
            DataType dataType = desiredDataType = schema.apply(idx).dataType();
            GeometryUDT$ geometryUDT$ = GeometryUDT$.MODULE$;
            Object object = !(dataType != null ? !dataType.equals((Object)geometryUDT$) : geometryUDT$ != null) ? value : MODULE$.parseString(value.toString(), desiredDataType);
            return object;
        });
        return Row$.MODULE$.fromSeq(parsedRow);
    }

    private Object parseString(String data, DataType desiredType) {
        Object object;
        String string = data;
        String string2 = "null";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Comparable<Byte> comparable;
            DataType dataType = desiredType;
            if (dataType instanceof ByteType) {
                comparable = BoxesRunTime.boxToByte((byte)BoxesRunTime.unboxToByte(null));
            } else if (dataType instanceof ShortType) {
                comparable = BoxesRunTime.boxToShort((short)BoxesRunTime.unboxToShort(null));
            } else if (dataType instanceof IntegerType) {
                comparable = null;
            } else if (dataType instanceof LongType) {
                comparable = BoxesRunTime.boxToLong((long)BoxesRunTime.unboxToLong(null));
            } else if (dataType instanceof FloatType) {
                comparable = BoxesRunTime.boxToFloat((float)BoxesRunTime.unboxToFloat(null));
            } else if (dataType instanceof DoubleType) {
                comparable = BoxesRunTime.boxToDouble((double)BoxesRunTime.unboxToDouble(null));
            } else if (dataType instanceof DateType) {
                comparable = null;
            } else if (dataType instanceof TimestampType) {
                comparable = null;
            } else if (dataType instanceof BooleanType) {
                comparable = BoxesRunTime.boxToBoolean((boolean)BoxesRunTime.unboxToBoolean(null));
            } else if (dataType instanceof StringType) {
                comparable = null;
            } else {
                throw new MatchError((Object)dataType);
            }
            return comparable;
        }
        DataType dataType = desiredType;
        if (dataType instanceof ByteType) {
            object = BoxesRunTime.boxToByte((byte)StringOps$.MODULE$.toByte$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof ShortType) {
            object = BoxesRunTime.boxToShort((short)StringOps$.MODULE$.toShort$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof IntegerType) {
            object = BoxesRunTime.boxToInteger((int)StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof LongType) {
            object = BoxesRunTime.boxToLong((long)StringOps$.MODULE$.toLong$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof FloatType) {
            object = BoxesRunTime.boxToFloat((float)StringOps$.MODULE$.toFloat$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof DoubleType) {
            object = BoxesRunTime.boxToDouble((double)StringOps$.MODULE$.toDouble$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof DateType) {
            object = Date.valueOf(data);
        } else if (dataType instanceof TimestampType) {
            object = Timestamp.valueOf(data);
        } else if (dataType instanceof BooleanType) {
            object = BoxesRunTime.boxToBoolean((boolean)StringOps$.MODULE$.toBoolean$extension(Predef$.MODULE$.augmentString(data)));
        } else if (dataType instanceof StringType) {
            object = data;
        } else if (dataType instanceof StructType) {
            StructType desiredStructSchema = (StructType)desiredType;
            object = new GenericRowWithSchema(this.parseStruct(data, desiredStructSchema), desiredStructSchema);
        } else {
            throw new MatchError((Object)dataType);
        }
        return object;
    }

    private Object[] parseStruct(String data, StructType desiredType) {
        String csv = StringOps$.MODULE$.slice$extension(Predef$.MODULE$.augmentString(data), 1, data.length() - 1);
        return (Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.zipWithIndex$extension(Predef$.MODULE$.refArrayOps((Object[])csv.split(",")))), (Function1 & Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String element = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            StructField nestedField = (StructField)((IterableOps)desiredType.slice(idx, idx + 1)).head();
            DataType nestedDataType = nestedField.dataType();
            Object object = MODULE$.parseString(element, nestedDataType);
            return object;
        }, ClassTag$.MODULE$.Any());
    }

    public static final /* synthetic */ boolean $anonfun$toSpatialRdd$2(String geometryFieldName$1, String p) {
        return !p.equalsIgnoreCase(geometryFieldName$1);
    }

    public static final /* synthetic */ boolean $anonfun$toSpatialRdd$4(String geometryFieldName$2, String p) {
        return !p.equalsIgnoreCase(geometryFieldName$2);
    }

    private Adapter$() {
    }
}

