/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.spatialPartitioning;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import scala.Tuple2;

public class EqualPartitioning
implements Serializable {
    List<Envelope> grids = new ArrayList<Envelope>();

    public EqualPartitioning(List<Envelope> grids) {
        this.grids = grids;
    }

    public EqualPartitioning(Envelope boundary, int partitions) {
        Double root = Math.sqrt(partitions);
        int partitionsAxis = root.intValue();
        double intervalX = (boundary.getMaxX() - boundary.getMinX()) / (double)partitionsAxis;
        double intervalY = (boundary.getMaxY() - boundary.getMinY()) / (double)partitionsAxis;
        for (int i = 0; i < partitionsAxis; ++i) {
            for (int j = 0; j < partitionsAxis; ++j) {
                Envelope grid = new Envelope(boundary.getMinX() + intervalX * (double)i, boundary.getMinX() + intervalX * (double)(i + 1), boundary.getMinY() + intervalY * (double)j, boundary.getMinY() + intervalY * (double)(j + 1));
                this.grids.add(grid);
            }
        }
    }

    public List<Envelope> getGrids() {
        return this.grids;
    }

    public Iterator<Tuple2<Integer, Geometry>> placeObject(Geometry geometry) {
        Objects.requireNonNull(geometry, "spatialObject");
        int overflowContainerID = this.grids.size();
        Envelope envelope = geometry.getEnvelopeInternal();
        HashSet<Tuple2> result2 = new HashSet<Tuple2>();
        boolean containFlag = false;
        for (int i = 0; i < this.grids.size(); ++i) {
            Envelope grid = this.grids.get(i);
            if (grid.covers(envelope)) {
                result2.add(new Tuple2((Object)i, (Object)geometry));
                containFlag = true;
                continue;
            }
            if (!grid.intersects(envelope) && !envelope.covers(grid)) continue;
            result2.add(new Tuple2((Object)i, (Object)geometry));
        }
        if (!containFlag) {
            result2.add(new Tuple2((Object)overflowContainerID, (Object)geometry));
        }
        return result2.iterator();
    }

    public Set<Integer> getKeys(Geometry geometry) {
        Objects.requireNonNull(geometry, "spatialObject");
        int overflowContainerID = this.grids.size();
        Envelope envelope = geometry.getEnvelopeInternal();
        HashSet<Integer> result2 = new HashSet<Integer>();
        boolean containFlag = false;
        for (int i = 0; i < this.grids.size(); ++i) {
            Envelope grid = this.grids.get(i);
            if (grid.covers(envelope)) {
                result2.add(i);
                containFlag = true;
                continue;
            }
            if (!grid.intersects(envelope) && !envelope.covers(grid)) continue;
            result2.add(i);
        }
        if (!containFlag) {
            result2.add(overflowContainerID);
        }
        return result2;
    }
}

