/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.rangeJudgement;

import java.io.Serializable;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.locationtech.jts.geom.Geometry;

public class JudgementBase<U extends Geometry>
implements Serializable {
    private static final Logger log = LogManager.getLogger(JudgementBase.class);
    private final boolean considerBoundaryIntersection;
    protected boolean leftCoveredByRight = true;
    U queryGeometry;

    public JudgementBase(U queryWindow, boolean considerBoundaryIntersection, boolean leftCoveredByRight) {
        this.considerBoundaryIntersection = considerBoundaryIntersection;
        this.queryGeometry = queryWindow;
        this.leftCoveredByRight = leftCoveredByRight;
    }

    public boolean match(Geometry spatialObject, Geometry queryWindow) {
        if (this.considerBoundaryIntersection) {
            return queryWindow.intersects(spatialObject);
        }
        return queryWindow.covers(spatialObject);
    }
}

