/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.jts.operation.buffer.validate;

import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.algorithm.distance.DiscreteHausdorffDistance;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryCollection;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.util.LinearComponentExtracter;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.io.WKTWriter;
import org.locationtech.jts.operation.distance.DistanceOp;

public class BufferDistanceValidator {
    private static boolean VERBOSE = false;
    private static final double MAX_DISTANCE_DIFF_FRAC = 0.012;
    private Geometry input;
    private double bufDistance;
    private Geometry result;
    private double minValidDistance;
    private double maxValidDistance;
    private double minDistanceFound;
    private double maxDistanceFound;
    private boolean isValid = true;
    private String errMsg = null;
    private Coordinate errorLocation = null;
    private Geometry errorIndicator = null;

    public BufferDistanceValidator(Geometry input, double bufDistance, Geometry result2) {
        this.input = input;
        this.bufDistance = bufDistance;
        this.result = result2;
    }

    public boolean isValid() {
        double posDistance = Math.abs(this.bufDistance);
        double distDelta = 0.012 * posDistance;
        this.minValidDistance = posDistance - distDelta;
        this.maxValidDistance = posDistance + distDelta;
        if (this.input.isEmpty() || this.result.isEmpty()) {
            return true;
        }
        if (this.bufDistance > 0.0) {
            this.checkPositiveValid();
        } else {
            this.checkNegativeValid();
        }
        if (VERBOSE) {
            System.out.println("Min Dist= " + this.minDistanceFound + "  err= " + (1.0 - this.minDistanceFound / this.bufDistance) + "  Max Dist= " + this.maxDistanceFound + "  err= " + (this.maxDistanceFound / this.bufDistance - 1.0));
        }
        return this.isValid;
    }

    public String getErrorMessage() {
        return this.errMsg;
    }

    public Coordinate getErrorLocation() {
        return this.errorLocation;
    }

    public Geometry getErrorIndicator() {
        return this.errorIndicator;
    }

    private void checkPositiveValid() {
        Geometry bufCurve = this.result.getBoundary();
        this.checkMinimumDistance(this.input, bufCurve, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(this.input, bufCurve, this.maxValidDistance);
    }

    private void checkNegativeValid() {
        if (!(this.input instanceof Polygon || this.input instanceof MultiPolygon || this.input instanceof GeometryCollection)) {
            return;
        }
        Geometry inputCurve = this.getPolygonLines(this.input);
        this.checkMinimumDistance(inputCurve, this.result, this.minValidDistance);
        if (!this.isValid) {
            return;
        }
        this.checkMaximumDistance(inputCurve, this.result, this.maxValidDistance);
    }

    private Geometry getPolygonLines(Geometry g) {
        ArrayList lines = new ArrayList();
        LinearComponentExtracter lineExtracter = new LinearComponentExtracter(lines);
        List polys = PolygonExtracter.getPolygons(g);
        for (Polygon poly : polys) {
            poly.apply(lineExtracter);
        }
        return g.getFactory().buildGeometry(lines);
    }

    private void checkMinimumDistance(Geometry g1, Geometry g2, double minDist) {
        DistanceOp distOp = new DistanceOp(g1, g2, minDist);
        this.minDistanceFound = distOp.distance();
        if (this.minDistanceFound < minDist) {
            this.isValid = false;
            Coordinate[] pts = distOp.nearestPoints();
            this.errorLocation = distOp.nearestPoints()[1];
            this.errorIndicator = g1.getFactory().createLineString(pts);
            this.errMsg = "Distance between buffer curve and input is too small (" + this.minDistanceFound + " at " + WKTWriter.toLineString(pts[0], pts[1]) + " )";
        }
    }

    private void checkMaximumDistance(Geometry input, Geometry bufCurve, double maxDist) {
        DiscreteHausdorffDistance haus = new DiscreteHausdorffDistance(bufCurve, input);
        haus.setDensifyFraction(0.25);
        this.maxDistanceFound = haus.orientedDistance();
        if (this.maxDistanceFound > maxDist) {
            this.isValid = false;
            Coordinate[] pts = haus.getCoordinates();
            this.errorLocation = pts[1];
            this.errorIndicator = input.getFactory().createLineString(pts);
            this.errMsg = "Distance between buffer curve and input is too large (" + this.maxDistanceFound + " at " + WKTWriter.toLineString(pts[0], pts[1]) + ")";
        }
    }
}

