/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.sedona_sql.io;

import java.awt.RenderingHints;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.nio.file.Paths;
import javax.media.jai.RasterFactory;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.sedona.sql.utils.GeometrySerializer$;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.util.ArrayData;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.sedona_sql.io.GeotiffFileWriter$;
import org.apache.spark.sql.sedona_sql.io.GeotiffFileWriter$$anonfun$write$1$;
import org.apache.spark.sql.sedona_sql.io.ImageWriteOptions;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.unsafe.types.UTF8String;
import org.geotools.coverage.CoverageFactoryFinder;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.gce.geotiff.GeoTiffFormat;
import org.geotools.gce.geotiff.GeoTiffWriteParams;
import org.geotools.gce.geotiff.GeoTiffWriter;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.factory.Hints;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.io.WKTReader;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.GeneralParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0005\u001f\t\tr)Z8uS\u001a4g)\u001b7f/JLG/\u001a:\u000b\u0005\r!\u0011AA5p\u0015\t)a!\u0001\u0006tK\u0012|g.Y0tc2T!a\u0002\u0005\u0002\u0007M\fHN\u0003\u0002\n\u0015\u0005)1\u000f]1sW*\u00111\u0002D\u0001\u0007CB\f7\r[3\u000b\u00035\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\t\u0011\u0005E1R\"\u0001\n\u000b\u0005M!\u0012a\u00033bi\u0006\u001cx.\u001e:dKNT!!\u0006\u0004\u0002\u0013\u0015DXmY;uS>t\u0017BA\f\u0013\u00051yU\u000f\u001e9vi^\u0013\u0018\u000e^3s\u0011!I\u0002A!A!\u0002\u0013Q\u0012\u0001C:bm\u0016\u0004\u0016\r\u001e5\u0011\u0005m\tcB\u0001\u000f \u001b\u0005i\"\"\u0001\u0010\u0002\u000bM\u001c\u0017\r\\1\n\u0005\u0001j\u0012A\u0002)sK\u0012,g-\u0003\u0002#G\t11\u000b\u001e:j]\u001eT!\u0001I\u000f\t\u0011\u0015\u0002!\u0011!Q\u0001\n\u0019\n\u0011#[7bO\u0016<&/\u001b;f\u001fB$\u0018n\u001c8t!\t9\u0003&D\u0001\u0003\u0013\tI#AA\tJ[\u0006<Wm\u0016:ji\u0016|\u0005\u000f^5p]ND\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001L\u0001\u000bI\u0006$\u0018mU2iK6\f\u0007CA\u00171\u001b\u0005q#BA\u0018\u0007\u0003\u0015!\u0018\u0010]3t\u0013\t\tdF\u0001\u0006TiJ,8\r\u001e+za\u0016D\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001N\u0001\bG>tG/\u001a=u!\t)$(D\u00017\u0015\t9\u0004(A\u0005nCB\u0014X\rZ;dK*\u0011\u0011HC\u0001\u0007Q\u0006$wn\u001c9\n\u0005m2$A\u0005+bg.\fE\u000f^3naR\u001cuN\u001c;fqRDQ!\u0010\u0001\u0005\u0002y\na\u0001P5oSRtD#B A\u0003\n\u001b\u0005CA\u0014\u0001\u0011\u0015IB\b1\u0001\u001b\u0011\u0015)C\b1\u0001'\u0011\u0015YC\b1\u0001-\u0011\u0015\u0019D\b1\u00015\u0011\u001d)\u0005A1A\u0005\n\u0019\u000bA\u0003R#G\u0003VcEkX,S\u0013R+u\fU!S\u00036\u001bV#A$\u0011\u0005!{U\"A%\u000b\u0005)[\u0015aB4f_RLgM\u001a\u0006\u0003\u00196\u000b1aZ2f\u0015\tqE\"\u0001\u0005hK>$xn\u001c7t\u0013\t\u0001\u0016J\u0001\nHK>$\u0016N\u001a4Xe&$X\rU1sC6\u001c\bB\u0002*\u0001A\u0003%q)A\u000bE\u000b\u001a\u000bU\u000b\u0014+`/JKE+R0Q\u0003J\u000bUj\u0015\u0011\t\u000fQ\u0003!\u0019!C\u0005+\u0006\u0019\u0001NZ:\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u001d\u0002\u0005\u0019\u001c\u0018BA.Y\u0005)1\u0015\u000e\\3TsN$X-\u001c\u0005\u0007;\u0002\u0001\u000b\u0011\u0002,\u0002\t!47\u000f\t\u0005\u0006?\u0002!\t\u0005Y\u0001\u0006oJLG/\u001a\u000b\u0003C\u0012\u0004\"\u0001\b2\n\u0005\rl\"\u0001B+oSRDQ!\u001a0A\u0002\u0019\f1A]8x!\t9'.D\u0001i\u0015\tIg!\u0001\u0005dCR\fG._:u\u0013\tY\u0007NA\u0006J]R,'O\\1m%><\b\"B7\u0001\t\u0003r\u0017!B2m_N,G#A1\t\u000bA\u0004A\u0011A9\u0002\tA\fG\u000f\u001b\u000b\u00025\u0001")
public class GeotiffFileWriter
extends OutputWriter {
    private final String savePath;
    private final ImageWriteOptions imageWriteOptions;
    private final StructType dataSchema;
    private final GeoTiffWriteParams DEFAULT_WRITE_PARAMS;
    private final FileSystem hfs;

    private GeoTiffWriteParams DEFAULT_WRITE_PARAMS() {
        return this.DEFAULT_WRITE_PARAMS;
    }

    private FileSystem hfs() {
        return this.hfs;
    }

    public void write(InternalRow row) {
        Throwable throwable2;
        block7: {
            InternalRow rowFields = row;
            StructType schemaFields = this.dataSchema;
            String[] fields = this.dataSchema.fieldNames();
            if (Predef$.MODULE$.refArrayOps((Object[])fields).contains((Object)this.imageWriteOptions.colImage())) {
                schemaFields = (StructType)this.dataSchema.fields()[this.dataSchema.fieldIndex(this.imageWriteOptions.colImage())].dataType();
                rowFields = row.getStruct(this.dataSchema.fieldIndex(this.imageWriteOptions.colImage()), 6);
            }
            String tiffOrigin = rowFields.getString(schemaFields.fieldIndex(this.imageWriteOptions.colOrigin()));
            int tiffBands = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colBands()));
            int tiffWidth = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colWidth()));
            int tiffHeight = rowFields.getInt(schemaFields.fieldIndex(this.imageWriteOptions.colHeight()));
            Object tiffGeometry = Row$.MODULE$.fromSeq(rowFields.toSeq(schemaFields)).get(schemaFields.fieldIndex(this.imageWriteOptions.colGeometry()));
            double[] tiffData = rowFields.getArray(schemaFields.fieldIndex(this.imageWriteOptions.colData())).toDoubleArray();
            if (tiffBands == -1) {
                return;
            }
            WritableRaster raster = RasterFactory.createBandedRaster((int)5, (int)tiffWidth, (int)tiffHeight, (int)tiffBands, null);
            double[] pixelVal = (double[])Array$.MODULE$.ofDim(tiffBands, ClassTag$.MODULE$.Double());
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tiffHeight).foreach$mVc$sp((Function1)new Serializable(this, tiffBands, tiffWidth, tiffHeight, tiffData, raster, pixelVal){
                public static final long serialVersionUID = 0L;
                public final int tiffBands$1;
                public final int tiffWidth$1;
                public final int tiffHeight$1;
                public final double[] tiffData$1;
                public final WritableRaster raster$1;
                public final double[] pixelVal$1;

                public final void apply(int i) {
                    this.apply$mcVI$sp(i);
                }

                public void apply$mcVI$sp(int i) {
                    RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.tiffWidth$1).foreach$mVc$sp((Function1)new Serializable(this, i){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$write$1 $outer;
                        public final int i$1;

                        public final void apply(int j) {
                            this.apply$mcVI$sp(j);
                        }

                        public void apply$mcVI$sp(int j) {
                            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.$outer.tiffBands$1).foreach$mVc$sp((Function1)new Serializable(this, j){
                                public static final long serialVersionUID = 0L;
                                private final /* synthetic */ $anonfun$write$1$$anonfun$apply$mcVI$sp$1 $outer;
                                private final int j$1;

                                public final void apply(int k) {
                                    this.apply$mcVI$sp(k);
                                }

                                public void apply$mcVI$sp(int k) {
                                    this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffFileWriter$$anonfun$$anonfun$$$outer().pixelVal$1[k] = this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffFileWriter$$anonfun$$anonfun$$$outer().tiffData$1[this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffFileWriter$$anonfun$$anonfun$$$outer().tiffHeight$1 * this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffFileWriter$$anonfun$$anonfun$$$outer().tiffWidth$1 * k + this.$outer.i$1 * this.$outer.org$apache$spark$sql$sedona_sql$io$GeotiffFileWriter$$anonfun$$anonfun$$$outer().tiffWidth$1 + this.j$1];
                                }
                                {
                                    if ($outer == null) {
                                        throw null;
                                    }
                                    this.$outer = $outer;
                                    this.j$1 = j$1;
                                }
                            });
                            this.$outer.raster$1.setPixel(j, this.i$1, this.$outer.pixelVal$1);
                        }

                        public /* synthetic */ $anonfun$write$1 org$apache$spark$sql$sedona_sql$io$GeotiffFileWriter$$anonfun$$anonfun$$$outer() {
                            return this.$outer;
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.i$1 = i$1;
                        }
                    });
                }
                {
                    this.tiffBands$1 = tiffBands$1;
                    this.tiffWidth$1 = tiffWidth$1;
                    this.tiffHeight$1 = tiffHeight$1;
                    this.tiffData$1 = tiffData$1;
                    this.raster$1 = raster$1;
                    this.pixelVal$1 = pixelVal$1;
                }
            });
            CoordinateReferenceSystem crs = CRS.decode((String)this.imageWriteOptions.writeToCRS(), (boolean)true);
            Coordinate[] coordinateList = null;
            if (tiffGeometry instanceof UTF8String) {
                WKTReader wktReader = new WKTReader();
                Polygon envGeom = (Polygon)wktReader.read(tiffGeometry.toString());
                coordinateList = envGeom.getCoordinates();
            } else {
                Geometry envGeom = GeometrySerializer$.MODULE$.deserialize((ArrayData)tiffGeometry);
                coordinateList = envGeom.getCoordinates();
            }
            ReferencedEnvelope referencedEnvelope = new ReferencedEnvelope(coordinateList[0].x, coordinateList[2].x, coordinateList[0].y, coordinateList[2].y, crs);
            String writePath = ((Object)Paths.get(this.savePath, new Path(tiffOrigin).getName())).toString();
            FSDataOutputStream out = this.hfs().create(new Path(writePath));
            AbstractGridFormat format = GridFormatFinder.findFormat((Object)out);
            Hints hints = null;
            if (format instanceof GeoTiffFormat) {
                hints = new Hints((RenderingHints.Key)Hints.FORCE_LONGITUDE_FIRST_AXIS_ORDER, (Object)BoxesRunTime.boxToBoolean((boolean)true));
            }
            GridCoverageFactory factory = CoverageFactoryFinder.getGridCoverageFactory(hints);
            GridCoverage2D gc = factory.create((CharSequence)"GRID", raster, (Envelope)referencedEnvelope);
            GeoTiffWriter writer = new GeoTiffWriter((Object)out, hints);
            ParameterValueGroup gtiffParams = new GeoTiffFormat().getWriteParameters();
            gtiffParams.parameter(AbstractGridFormat.GEOTOOLS_WRITE_PARAMS.getName().toString()).setValue((Object)this.DEFAULT_WRITE_PARAMS());
            GeneralParameterValue[] wps = (GeneralParameterValue[])gtiffParams.values().toArray((Object[])new GeneralParameterValue[1]);
            try {
                writer.write((GridCoverage)gc, wps);
                writer.dispose();
                out.close();
            }
            catch (Throwable throwable2) {
                Throwable throwable3 = throwable2;
                boolean bl = throwable3 instanceof IllegalArgumentException ? true : throwable3 instanceof IOException;
                if (!bl) break block7;
                throwable3.printStackTrace();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            return;
        }
        throw throwable2;
    }

    public void close() {
        this.hfs().close();
    }

    public String path() {
        return this.savePath;
    }

    public GeotiffFileWriter(String savePath, ImageWriteOptions imageWriteOptions, StructType dataSchema, TaskAttemptContext context) {
        this.savePath = savePath;
        this.imageWriteOptions = imageWriteOptions;
        this.dataSchema = dataSchema;
        this.DEFAULT_WRITE_PARAMS = new GeoTiffWriteParams();
        this.DEFAULT_WRITE_PARAMS().setCompressionMode(2);
        this.DEFAULT_WRITE_PARAMS().setCompressionType("LZW");
        this.DEFAULT_WRITE_PARAMS().setCompressionQuality(0.75f);
        this.DEFAULT_WRITE_PARAMS().setTilingMode(2);
        this.DEFAULT_WRITE_PARAMS().setTiling(512, 512);
        this.hfs = new Path(savePath).getFileSystem(context.getConfiguration());
    }
}

