/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sedona.core.joinJudgement;

import org.apache.sedona.core.utils.HalfOpenRectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.Point;

public class JudgementHelper {
    public static boolean match(Geometry left, Geometry right, HalfOpenRectangle extent, boolean considerBoundaryIntersection) {
        if (extent != null) {
            Point referencePoint;
            if (left instanceof Point || right instanceof Point) {
                return JudgementHelper.geoMatch(left, right, considerBoundaryIntersection);
            }
            Envelope intersection = left.getEnvelopeInternal().intersection(right.getEnvelopeInternal());
            if (!intersection.isNull() && !extent.contains(referencePoint = JudgementHelper.makePoint(intersection.getMinX(), intersection.getMinY(), left.getFactory()))) {
                return false;
            }
        }
        return JudgementHelper.geoMatch(left, right, considerBoundaryIntersection);
    }

    private static Point makePoint(double x, double y, GeometryFactory factory) {
        return factory.createPoint(new Coordinate(x, y));
    }

    private static boolean geoMatch(Geometry left, Geometry right, boolean considerBoundaryIntersection) {
        return considerBoundaryIntersection ? left.intersects(right) : left.covers(right);
    }
}

