/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.dynamicforms;

import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.seatunnel.app.dynamicforms.AbstractFormSelectOption;
import org.apache.seatunnel.app.dynamicforms.DynamicSelectOption;
import org.apache.seatunnel.app.dynamicforms.FormInputOption;
import org.apache.seatunnel.app.dynamicforms.StaticSelectOption;

public class FormOptionBuilder {
    private String label;
    private String field;

    public static FormOptionBuilder builder() {
        return new FormOptionBuilder();
    }

    public FormOptionBuilder withLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = label;
        return this;
    }

    public FormOptionBuilder withI18nLabel(@NonNull String label) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        this.label = "i18n." + label;
        return this;
    }

    public FormOptionBuilder withField(@NonNull String field) {
        if (field == null) {
            throw new NullPointerException("field is marked non-null but is null");
        }
        this.field = field;
        return this;
    }

    public InputOptionBuilder inputOptionBuilder() {
        return new InputOptionBuilder(this.label, this.field);
    }

    public DynamicSelectOptionBuilder dynamicSelectOptionBuilder() {
        return new DynamicSelectOptionBuilder(this.label, this.field);
    }

    public StaticSelectOptionBuilder staticSelectOptionBuilder() {
        return new StaticSelectOptionBuilder(this.label, this.field);
    }

    public static class StaticSelectOptionBuilder {
        private String label;
        private String field;
        private List<AbstractFormSelectOption.SelectOption> options = new ArrayList<AbstractFormSelectOption.SelectOption>();

        public StaticSelectOptionBuilder(@NonNull String label, @NonNull String field) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.label = label;
            this.field = field;
        }

        public StaticSelectOptionBuilder addSelectOptions(@NonNull List<ImmutablePair> selectOptions) {
            if (selectOptions == null) {
                throw new NullPointerException("selectOptions is marked non-null but is null");
            }
            for (ImmutablePair option : selectOptions) {
                this.options.add(new AbstractFormSelectOption.SelectOption(option.left.toString(), option.right.toString()));
            }
            return this;
        }

        public StaticSelectOptionBuilder addI18nSelectOptions(@NonNull List<ImmutablePair> selectOptions) {
            if (selectOptions == null) {
                throw new NullPointerException("selectOptions is marked non-null but is null");
            }
            for (ImmutablePair option : selectOptions) {
                this.options.add(new AbstractFormSelectOption.SelectOption("i18n." + option.left.toString(), option.right.toString()));
            }
            return this;
        }

        public StaticSelectOptionBuilder addSelectOptions(ImmutablePair ... selectOptions) {
            if (selectOptions == null) {
                throw new NullPointerException("selectOptions is marked non-null but is null");
            }
            for (ImmutablePair option : selectOptions) {
                this.options.add(new AbstractFormSelectOption.SelectOption(option.left.toString(), option.right.toString()));
            }
            return this;
        }

        public StaticSelectOptionBuilder addI18nSelectOptions(ImmutablePair ... selectOptions) {
            if (selectOptions == null) {
                throw new NullPointerException("selectOptions is marked non-null but is null");
            }
            for (ImmutablePair option : selectOptions) {
                this.options.add(new AbstractFormSelectOption.SelectOption("i18n." + option.left.toString(), option.right.toString()));
            }
            return this;
        }

        public StaticSelectOption formStaticSelectOption() {
            return new StaticSelectOption(this.options, this.label, this.field);
        }
    }

    public static class DynamicSelectOptionBuilder {
        private String label;
        private String field;
        private String selectApi;

        public DynamicSelectOptionBuilder(@NonNull String label, @NonNull String field) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.label = label;
            this.field = field;
        }

        public DynamicSelectOptionBuilder withSelectApi(@NonNull String selectApi) {
            if (selectApi == null) {
                throw new NullPointerException("selectApi is marked non-null but is null");
            }
            this.selectApi = selectApi;
            return this;
        }

        public DynamicSelectOption formDynamicSelectOption() {
            return new DynamicSelectOption(this.selectApi, this.label, this.field);
        }
    }

    public static class InputOptionBuilder {
        private String label;
        private String field;

        public InputOptionBuilder(@NonNull String label, @NonNull String field) {
            if (label == null) {
                throw new NullPointerException("label is marked non-null but is null");
            }
            if (field == null) {
                throw new NullPointerException("field is marked non-null but is null");
            }
            this.label = label;
            this.field = field;
        }

        public FormInputOption formTextInputOption() {
            return new FormInputOption(FormInputOption.InputType.TEXT, this.label, this.field);
        }

        public FormInputOption formPasswordInputOption() {
            return new FormInputOption(FormInputOption.InputType.PASSWORD, this.label, this.field);
        }

        public FormInputOption formTextareaInputOption() {
            return new FormInputOption(FormInputOption.InputType.TEXTAREA, this.label, this.field);
        }
    }
}

