/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.service.impl;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.common.Status;
import org.apache.seatunnel.app.dal.dao.IJobDefinitionDao;
import org.apache.seatunnel.app.dal.dao.IJobInstanceDao;
import org.apache.seatunnel.app.dal.entity.JobDefinition;
import org.apache.seatunnel.app.dal.entity.JobInstance;
import org.apache.seatunnel.app.domain.dto.job.SeaTunnelJobInstanceDto;
import org.apache.seatunnel.app.domain.response.executor.JobExecutionStatus;
import org.apache.seatunnel.app.domain.response.metrics.JobSummaryMetricsRes;
import org.apache.seatunnel.app.service.BaseService;
import org.apache.seatunnel.app.service.IJobDefinitionService;
import org.apache.seatunnel.app.service.IJobMetricsService;
import org.apache.seatunnel.app.service.ITaskInstanceService;
import org.apache.seatunnel.app.utils.PageInfo;
import org.apache.seatunnel.common.constants.JobMode;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TaskInstanceServiceImpl
implements ITaskInstanceService<SeaTunnelJobInstanceDto> {
    private static final Logger log = LoggerFactory.getLogger(TaskInstanceServiceImpl.class);
    @Autowired
    IJobInstanceDao jobInstanceDao;
    @Autowired
    IJobMetricsService jobMetricsService;
    @Autowired
    IJobDefinitionService jobDefinitionService;
    @Autowired
    BaseService baseService;
    @Autowired
    IJobDefinitionDao jobDefinitionDao;

    @Override
    public Result<PageInfo<SeaTunnelJobInstanceDto>> getSyncTaskInstancePaging(Integer userId, String jobDefineName, String executorName, String stateType, String startTime, String endTime, JobMode jobMode, Integer pageNo, Integer pageSize) {
        Result<PageInfo<SeaTunnelJobInstanceDto>> result = new Result<PageInfo<SeaTunnelJobInstanceDto>>();
        PageInfo pageInfo = new PageInfo(pageNo, pageSize);
        result.setData(pageInfo);
        this.baseService.putMsg(result, Status.SUCCESS, new Object[0]);
        Date startDate = this.dateConverter(startTime);
        Date endDate = this.dateConverter(endTime);
        IPage<SeaTunnelJobInstanceDto> jobInstanceIPage = this.jobInstanceDao.queryJobInstanceListPaging((IPage<JobInstance>)new Page((long)pageNo.intValue(), (long)pageSize.intValue()), startDate, endDate, jobDefineName, jobMode);
        List records = jobInstanceIPage.getRecords();
        if (CollectionUtils.isEmpty((Collection)records)) {
            return result;
        }
        this.populateExecutionMetricsData(userId, jobMode, records);
        pageInfo.setTotal((int)jobInstanceIPage.getTotal());
        pageInfo.setTotalList(records);
        result.setData(pageInfo);
        return result;
    }

    private void populateExecutionMetricsData(Integer userId, JobMode jobMode, List<SeaTunnelJobInstanceDto> records) {
        this.addJobDefineNameToResult(records);
        this.addRunningTimeToResult(records);
        this.jobPipelineSummaryMetrics(records, jobMode, userId);
    }

    private void addRunningTimeToResult(List<SeaTunnelJobInstanceDto> records) {
        for (SeaTunnelJobInstanceDto jobInstanceDto : records) {
            long runningTime = 0L;
            Date createTime = jobInstanceDto.getCreateTime();
            long createTimeSecond = createTime.toInstant().getEpochSecond();
            Date endTime = jobInstanceDto.getEndTime();
            if (endTime == null) {
                Date currentData = new Date();
                long currentDateSecond = currentData.toInstant().getEpochSecond();
                runningTime = Math.abs(currentDateSecond - createTimeSecond);
                jobInstanceDto.setRunningTime(runningTime);
                continue;
            }
            long endTimeSecond = jobInstanceDto.getEndTime().toInstant().getEpochSecond();
            runningTime = Math.abs(endTimeSecond - createTimeSecond);
            jobInstanceDto.setRunningTime(runningTime);
        }
    }

    private void addJobDefineNameToResult(List<SeaTunnelJobInstanceDto> records) {
        for (SeaTunnelJobInstanceDto jobInstanceDto : records) {
            JobDefinition jobDefinition = this.jobDefinitionService.getJobDefinitionByJobId(jobInstanceDto.getJobDefineId());
            if (jobDefinition == null) continue;
            jobInstanceDto.setJobDefineName(jobDefinition.getName());
        }
    }

    public Date dateConverter(String time) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            return dateFormat.parse(time);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void jobPipelineSummaryMetrics(List<SeaTunnelJobInstanceDto> records, JobMode jobMode, Integer userId) {
        try {
            ArrayList<Long> jobInstanceIdList = new ArrayList<Long>();
            HashMap<Long, Long> jobInstanceIdAndJobEngineIdMap = new HashMap<Long, Long>();
            for (SeaTunnelJobInstanceDto jobInstance : records) {
                if (jobInstance.getId() == null || jobInstance.getJobEngineId() == null) continue;
                jobInstanceIdList.add(jobInstance.getId());
                jobInstanceIdAndJobEngineIdMap.put(jobInstance.getId(), Long.valueOf(jobInstance.getJobEngineId()));
            }
            Map<Long, JobSummaryMetricsRes> jobSummaryMetrics = this.jobMetricsService.getALLJobSummaryMetrics(userId, jobInstanceIdAndJobEngineIdMap, jobInstanceIdList, jobMode);
            for (SeaTunnelJobInstanceDto taskInstance : records) {
                if (jobSummaryMetrics.get(taskInstance.getId()) == null) continue;
                taskInstance.setWriteRowCount(jobSummaryMetrics.get(taskInstance.getId()).getWriteRowCount());
                taskInstance.setReadRowCount(jobSummaryMetrics.get(taskInstance.getId()).getReadRowCount());
            }
        }
        catch (Exception e) {
            for (SeaTunnelJobInstanceDto taskInstance : records) {
                log.error("instance {} {} set instance and engine id error", (Object)taskInstance.getId(), (Object)e);
            }
        }
    }

    @Override
    public Result<JobExecutionStatus> getJobExecutionStatus(Integer userId, long jobInstanceId) {
        JobInstance jobInstance = this.jobInstanceDao.getJobExecutionStatus(jobInstanceId);
        if (jobInstance == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.RESOURCE_NOT_FOUND, new Object[]{"Job instance not found"});
        }
        return Result.success(new JobExecutionStatus(jobInstance.getJobStatus(), jobInstance.getErrorMessage()));
    }

    @Override
    public Result<SeaTunnelJobInstanceDto> getJobExecutionDetail(Integer userId, long jobInstanceId) {
        JobInstance jobInstance = this.jobInstanceDao.getJobInstance(jobInstanceId);
        if (jobInstance == null) {
            throw new SeatunnelException(SeatunnelErrorEnum.RESOURCE_NOT_FOUND, new Object[]{"Job instance not found"});
        }
        SeaTunnelJobInstanceDto executionDetails = this.convertToDto(jobInstance);
        this.populateExecutionMetricsData(userId, jobInstance.getJobType(), Collections.singletonList(executionDetails));
        return Result.success(executionDetails);
    }

    private SeaTunnelJobInstanceDto convertToDto(JobInstance jobInstance) {
        SeaTunnelJobInstanceDto dto = new SeaTunnelJobInstanceDto();
        dto.setId(jobInstance.getId());
        dto.setJobDefineId(jobInstance.getJobDefineId());
        dto.setJobStatus(jobInstance.getJobStatus());
        dto.setJobConfig(jobInstance.getJobConfig());
        dto.setEngineName(jobInstance.getEngineName());
        dto.setEngineVersion(jobInstance.getEngineVersion());
        dto.setJobEngineId(jobInstance.getJobEngineId());
        dto.setCreateUserId(jobInstance.getCreateUserId());
        dto.setUpdateUserId(jobInstance.getUpdateUserId());
        dto.setCreateTime(jobInstance.getCreateTime());
        dto.setUpdateTime(jobInstance.getUpdateTime());
        dto.setEndTime(jobInstance.getEndTime());
        dto.setJobType(jobInstance.getJobType());
        dto.setErrorMessage(jobInstance.getErrorMessage());
        return dto;
    }

    @Override
    public Result<Void> deleteJobInstanceById(Integer userId, long jobInstanceId) {
        this.jobInstanceDao.deleteById(jobInstanceId);
        return Result.success();
    }
}

