/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.io.IOException;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.dto.job.SeaTunnelJobInstanceDto;
import org.apache.seatunnel.app.domain.request.job.JobExecParam;
import org.apache.seatunnel.app.domain.response.executor.JobExecutionStatus;
import org.apache.seatunnel.app.domain.response.executor.JobExecutorRes;
import org.apache.seatunnel.app.service.IJobExecutorService;
import org.apache.seatunnel.app.service.IJobInstanceService;
import org.apache.seatunnel.app.service.ITaskInstanceService;
import org.apache.seatunnel.server.common.SeatunnelErrorEnum;
import org.apache.seatunnel.server.common.SeatunnelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/seatunnel/api/v1/job/executor"})
@RestController
public class JobExecutorController {
    private static final Logger log = LoggerFactory.getLogger(JobExecutorController.class);
    @Resource
    IJobExecutorService jobExecutorService;
    @Resource
    private IJobInstanceService jobInstanceService;
    @Resource
    private ITaskInstanceService<SeaTunnelJobInstanceDto> taskInstanceService;

    @PostMapping(value={"/execute"})
    @ApiOperation(value="Execute synchronization tasks", httpMethod="POST")
    public Result<Long> jobExecutor(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobDefineId", required=true) @RequestParam(value="jobDefineId") Long jobDefineId, @RequestBody(required=false) JobExecParam executeParam) {
        return this.jobExecutorService.jobExecute(userId, jobDefineId, executeParam);
    }

    @GetMapping(value={"/resource"})
    @ApiOperation(value="get the resource for job executor", httpMethod="GET")
    public Result<JobExecutorRes> resource(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="Job define id", required=true) @RequestParam Long jobDefineId) throws IOException {
        try {
            JobExecutorRes executeResource = this.jobInstanceService.createExecuteResource(userId, jobDefineId, null);
            return Result.success(executeResource);
        }
        catch (Exception e) {
            log.error("Get the resource for job executor error", (Throwable)e);
            throw new SeatunnelException(SeatunnelErrorEnum.ILLEGAL_STATE, new Object[]{e.getMessage()});
        }
    }

    @GetMapping(value={"/pause"})
    public Result<Void> jobPause(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) {
        return this.jobExecutorService.jobPause(userId, jobInstanceId);
    }

    @GetMapping(value={"/restore"})
    public Result<Void> jobRestore(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) {
        return this.jobExecutorService.jobStore(userId, jobInstanceId);
    }

    @GetMapping(value={"/status"})
    @ApiOperation(value="get job execution status", httpMethod="GET")
    Result<JobExecutionStatus> getJobExecutionStatus(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) {
        return this.taskInstanceService.getJobExecutionStatus(userId, jobInstanceId);
    }

    @GetMapping(value={"/detail"})
    @ApiOperation(value="get job execution status and some more details", httpMethod="GET")
    Result<SeaTunnelJobInstanceDto> getJobExecutionDetail(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) {
        return this.taskInstanceService.getJobExecutionDetail(userId, jobInstanceId);
    }

    @DeleteMapping(value={"/delete"})
    @ApiOperation(value="Deletes given job instance id", httpMethod="DELETE")
    Result<Void> deleteJobInstance(@ApiParam(value="userId", required=true) @RequestAttribute(value="userId") Integer userId, @ApiParam(value="jobInstanceId", required=true) @RequestParam Long jobInstanceId) {
        return this.taskInstanceService.deleteJobInstanceById(userId, jobInstanceId);
    }
}

