/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.Objects;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SqlType;

public class ArrayType<T, E>
implements SeaTunnelDataType<T> {
    private static final long serialVersionUID = 2L;
    public static final ArrayType<String[], String> STRING_ARRAY_TYPE = new ArrayType<String[], String>(String[].class, BasicType.STRING_TYPE);
    public static final ArrayType<Boolean[], Boolean> BOOLEAN_ARRAY_TYPE = new ArrayType<Boolean[], Boolean>(Boolean[].class, BasicType.BOOLEAN_TYPE);
    public static final ArrayType<Byte[], Byte> BYTE_ARRAY_TYPE = new ArrayType<Byte[], Byte>(Byte[].class, BasicType.BYTE_TYPE);
    public static final ArrayType<Short[], Short> SHORT_ARRAY_TYPE = new ArrayType<Short[], Short>(Short[].class, BasicType.SHORT_TYPE);
    public static final ArrayType<Integer[], Integer> INT_ARRAY_TYPE = new ArrayType<Integer[], Integer>(Integer[].class, BasicType.INT_TYPE);
    public static final ArrayType<Long[], Long> LONG_ARRAY_TYPE = new ArrayType<Long[], Long>(Long[].class, BasicType.LONG_TYPE);
    public static final ArrayType<Float[], Float> FLOAT_ARRAY_TYPE = new ArrayType<Float[], Float>(Float[].class, BasicType.FLOAT_TYPE);
    public static final ArrayType<Double[], Double> DOUBLE_ARRAY_TYPE = new ArrayType<Double[], Double>(Double[].class, BasicType.DOUBLE_TYPE);
    public static final ArrayType<LocalTimeType[], LocalTimeType> LOCAL_DATE_ARRAY_TYPE = new ArrayType<LocalTimeType[], LocalDate>(LocalTimeType[].class, LocalTimeType.LOCAL_DATE_TYPE);
    public static final ArrayType<LocalTimeType[], LocalTimeType> LOCAL_TIME_ARRAY_TYPE = new ArrayType<LocalTimeType[], LocalTime>(LocalTimeType[].class, LocalTimeType.LOCAL_TIME_TYPE);
    public static final ArrayType<LocalTimeType[], LocalTimeType> LOCAL_DATE_TIME_ARRAY_TYPE = new ArrayType<LocalTimeType[], LocalDateTime>(LocalTimeType[].class, LocalTimeType.LOCAL_DATE_TIME_TYPE);
    private final Class<T> arrayClass;
    private final SeaTunnelDataType<E> elementType;

    protected ArrayType(Class<T> arrayClass, SeaTunnelDataType<E> elementType) {
        this.arrayClass = arrayClass;
        this.elementType = elementType;
    }

    public SeaTunnelDataType<E> getElementType() {
        return this.elementType;
    }

    @Override
    public Class<T> getTypeClass() {
        return this.arrayClass;
    }

    @Override
    public SqlType getSqlType() {
        return SqlType.ARRAY;
    }

    public int hashCode() {
        return Objects.hash(this.arrayClass, this.elementType);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ArrayType)) {
            return false;
        }
        ArrayType that = (ArrayType)obj;
        return Objects.equals(this.arrayClass, that.arrayClass) && Objects.equals(this.elementType, that.elementType);
    }

    public String toString() {
        return String.format("ARRAY<%s>", this.elementType);
    }
}

