/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.converter;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import org.apache.seatunnel.api.table.converter.DataConverter;
import org.apache.seatunnel.api.table.converter.DataTypeConverter;
import org.apache.seatunnel.api.table.converter.TypeConverter;

public class ConverterLoader {
    public static DataTypeConverter<?> loadDataTypeConverter(String identifier) {
        return ConverterLoader.loadDataTypeConverter(identifier, Thread.currentThread().getContextClassLoader());
    }

    public static DataTypeConverter<?> loadDataTypeConverter(String identifier, ClassLoader classLoader) {
        List<DataTypeConverter> converters = ConverterLoader.discoverConverters(DataTypeConverter.class, classLoader);
        for (DataTypeConverter dataTypeConverter : converters) {
            if (!dataTypeConverter.identifier().equals(identifier)) continue;
            return dataTypeConverter;
        }
        throw new IllegalArgumentException("No data type converter found for identifier: " + identifier);
    }

    public static DataConverter<?> loadDataConverter(String identifier) {
        return ConverterLoader.loadDataConverter(identifier, Thread.currentThread().getContextClassLoader());
    }

    public static DataConverter<?> loadDataConverter(String identifier, ClassLoader classLoader) {
        List<DataConverter> converters = ConverterLoader.discoverConverters(DataConverter.class, classLoader);
        for (DataConverter dataConverter : converters) {
            if (!dataConverter.identifier().equals(identifier)) continue;
            return dataConverter;
        }
        throw new IllegalArgumentException("No data converter found for identifier: " + identifier);
    }

    public static TypeConverter<?> loadTypeConverter(String identifier) {
        return ConverterLoader.loadTypeConverter(identifier, Thread.currentThread().getContextClassLoader());
    }

    public static TypeConverter<?> loadTypeConverter(String identifier, ClassLoader classLoader) {
        List<TypeConverter> converters = ConverterLoader.discoverConverters(TypeConverter.class, classLoader);
        for (TypeConverter typeConverter : converters) {
            if (!typeConverter.identifier().equals(identifier)) continue;
            return typeConverter;
        }
        throw new IllegalArgumentException("No type converter found for identifier: " + identifier);
    }

    private static <T> List<T> discoverConverters(Class<T> clazz, ClassLoader classLoader) {
        ArrayList converters = new ArrayList();
        ServiceLoader.load(clazz, classLoader).forEach(t -> converters.add(t));
        return converters;
    }
}

