/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.split;

import java.util.Arrays;
import lombok.NonNull;
import org.apache.seatunnel.api.table.catalog.CatalogTable;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.catalog.PhysicalColumn;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.transform.common.MultipleFieldOutputTransform;
import org.apache.seatunnel.transform.common.SeaTunnelRowAccessor;
import org.apache.seatunnel.transform.exception.TransformCommonError;
import org.apache.seatunnel.transform.split.SplitTransformConfig;

public class SplitTransform
extends MultipleFieldOutputTransform {
    private final SplitTransformConfig splitTransformConfig;
    private final int splitFieldIndex;

    public SplitTransform(@NonNull SplitTransformConfig splitTransformConfig, @NonNull CatalogTable catalogTable) {
        super(catalogTable);
        if (splitTransformConfig == null) {
            throw new NullPointerException("splitTransformConfig is marked non-null but is null");
        }
        if (catalogTable == null) {
            throw new NullPointerException("catalogTable is marked non-null but is null");
        }
        this.splitTransformConfig = splitTransformConfig;
        SeaTunnelRowType seaTunnelRowType = catalogTable.getTableSchema().toPhysicalRowDataType();
        try {
            this.splitFieldIndex = seaTunnelRowType.indexOf(splitTransformConfig.getSplitField());
        }
        catch (IllegalArgumentException e) {
            throw TransformCommonError.cannotFindInputFieldError(this.getPluginName(), splitTransformConfig.getSplitField());
        }
        this.outputCatalogTable = this.getProducedCatalogTable();
    }

    public String getPluginName() {
        return "Split";
    }

    @Override
    protected Object[] getOutputFieldValues(SeaTunnelRowAccessor inputRow) {
        Object splitFieldValue = inputRow.getField(this.splitFieldIndex);
        if (splitFieldValue == null) {
            return this.splitTransformConfig.getEmptySplits();
        }
        Object[] splitFieldValues = splitFieldValue.toString().split(this.splitTransformConfig.getSeparator(), this.splitTransformConfig.getOutputFields().length);
        if (splitFieldValues.length < this.splitTransformConfig.getOutputFields().length) {
            Object[] tmp = splitFieldValues;
            splitFieldValues = new String[this.splitTransformConfig.getOutputFields().length];
            System.arraycopy(tmp, 0, splitFieldValues, 0, tmp.length);
        }
        return splitFieldValues;
    }

    @Override
    protected Column[] getOutputColumns() {
        return (Column[])Arrays.stream(this.splitTransformConfig.getOutputFields()).map((? super T fieldName) -> PhysicalColumn.of((String)fieldName, (SeaTunnelDataType)BasicType.STRING_TYPE, (Integer)200, (boolean)true, (Object)"", (String)"")).toArray(Column[]::new);
    }
}

