/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.checkpoint;

public enum CheckpointType {
    CHECKPOINT_TYPE(true, "checkpoint"),
    SCHEMA_CHANGE_BEFORE_POINT_TYPE(true, "schema-change-before-point"),
    SCHEMA_CHANGE_AFTER_POINT_TYPE(true, "schema-change-after-point"),
    SAVEPOINT_TYPE(false, "savepoint"),
    COMPLETED_POINT_TYPE(true, "completed-point");

    private final boolean auto;
    private final String name;

    public static CheckpointType fromName(String name) {
        for (CheckpointType type : CheckpointType.values()) {
            if (!type.name.equals(name)) continue;
            return type;
        }
        throw new IllegalArgumentException("Unknown checkpoint type: " + name);
    }

    private CheckpointType(boolean auto, String name) {
        this.auto = auto;
        this.name = name;
    }

    public boolean isAuto() {
        return this.auto;
    }

    public String getName() {
        return this.name;
    }

    public boolean isFinalCheckpoint() {
        return this == COMPLETED_POINT_TYPE || this == SAVEPOINT_TYPE;
    }

    public boolean isSchemaChangeCheckpoint() {
        return this.isSchemaChangeBeforeCheckpoint() || this.isSchemaChangeAfterCheckpoint();
    }

    public boolean isSchemaChangeBeforeCheckpoint() {
        return this == SCHEMA_CHANGE_BEFORE_POINT_TYPE;
    }

    public boolean isSchemaChangeAfterCheckpoint() {
        return this == SCHEMA_CHANGE_AFTER_POINT_TYPE;
    }

    public boolean isSavepoint() {
        return this == SAVEPOINT_TYPE;
    }

    public boolean isGeneralCheckpoint() {
        return this == CHECKPOINT_TYPE;
    }

    public boolean notFinalCheckpoint() {
        return this.isGeneralCheckpoint() || this.isSchemaChangeCheckpoint();
    }

    public boolean notSchemaChangeCheckpoint() {
        return !this.isSchemaChangeCheckpoint();
    }

    public boolean notCompletedCheckpoint() {
        return this != COMPLETED_POINT_TYPE;
    }
}

