/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.monitor.impl;

import com.hazelcast.internal.monitor.LocalRecordStoreStats;
import com.hazelcast.map.impl.MapDataSerializerHook;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;

public class LocalRecordStoreStatsImpl
implements LocalRecordStoreStats,
IdentifiedDataSerializable {
    private long hits;
    private long lastAccess;
    private long lastUpdate;

    public void copyFrom(LocalRecordStoreStats stats) {
        this.hits = stats.getHits();
        this.lastAccess = stats.getLastAccessTime();
        this.lastUpdate = stats.getLastUpdateTime();
    }

    @Override
    public long getHits() {
        return this.hits;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccess;
    }

    @Override
    public long getLastUpdateTime() {
        return this.lastUpdate;
    }

    @Override
    public void increaseHits() {
        ++this.hits;
    }

    @Override
    public void increaseHits(long hits) {
        this.hits += hits;
    }

    @Override
    public void decreaseHits(long hits) {
        this.hits -= hits;
    }

    @Override
    public void setLastAccessTime(long time) {
        this.lastAccess = Math.max(this.lastAccess, time);
    }

    @Override
    public void setLastUpdateTime(long time) {
        this.lastUpdate = Math.max(this.lastUpdate, time);
    }

    public void reset() {
        this.hits = 0L;
        this.lastAccess = 0L;
        this.lastUpdate = 0L;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.hits);
        out.writeLong(this.lastAccess);
        out.writeLong(this.lastUpdate);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.hits = in.readLong();
        this.lastAccess = in.readLong();
        this.lastUpdate = in.readLong();
    }

    @Override
    public int getFactoryId() {
        return MapDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 154;
    }
}

