/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.collection.impl.queue;

import com.hazelcast.collection.impl.queue.QueueContainer;
import com.hazelcast.collection.impl.queue.QueueDataSerializerHook;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.util.Clock;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;

public class QueueItem
implements IdentifiedDataSerializable,
Comparable<QueueItem> {
    protected long itemId;
    protected Data serializedObject;
    protected Object deserializedObject;
    protected final long creationTime = Clock.currentTimeMillis();
    protected QueueContainer container;

    public QueueItem() {
    }

    public QueueItem(QueueContainer container, long itemId, @Nullable Data data) {
        this();
        this.container = container;
        this.itemId = itemId;
        this.serializedObject = data;
    }

    public Data getSerializedObject() {
        if (this.serializedObject == null && this.container != null) {
            this.serializedObject = this.container.getDataFromMap(this.itemId);
        }
        return this.serializedObject;
    }

    public void setSerializedObject(Data serializedObject) {
        this.serializedObject = serializedObject;
    }

    public void setContainer(QueueContainer container) {
        this.container = container;
    }

    public <T> T getDeserializedObject() {
        if (this.deserializedObject == null) {
            this.deserializedObject = this.container.getSerializationService().toObject(this.serializedObject);
        }
        return (T)this.deserializedObject;
    }

    public long getItemId() {
        return this.itemId;
    }

    public void setItemId(long itemId) {
        this.itemId = itemId;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public QueueContainer getContainer() {
        return this.container;
    }

    @Override
    public int getFactoryId() {
        return QueueDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 17;
    }

    @Override
    public void writeData(ObjectDataOutput out) throws IOException {
        out.writeLong(this.itemId);
        IOUtil.writeData(out, this.serializedObject);
    }

    @Override
    public void readData(ObjectDataInput in) throws IOException {
        this.itemId = in.readLong();
        this.serializedObject = IOUtil.readData(in);
    }

    @Override
    public int compareTo(QueueItem o) {
        if (this.itemId < o.getItemId()) {
            return -1;
        }
        if (this.itemId > o.getItemId()) {
            return 1;
        }
        return 0;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        QueueItem queueItem = (QueueItem)o;
        return this.itemId == queueItem.itemId && Objects.equals(this.serializedObject, queueItem.serializedObject);
    }

    public int hashCode() {
        return Objects.hash(this.itemId, this.serializedObject);
    }
}

