/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource.impl;

import com.google.auto.service.AutoService;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableFieldRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.AbstractDataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigFactory;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValueFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AutoService(value={DataSourceConfigSwitcher.class})
public class KafkaKingbaseDataSourceConfigSwitcher
extends AbstractDataSourceConfigSwitcher {
    private static final String SCHEMA = "schema";
    private static final String TOPIC = "topic";
    private static final String FORMAT = "format";
    private static final String PATTERN = "pattern";
    private static final String FACTORY = "factory";
    private static final String CATALOG = "catalog";
    private static final String TABLE_NAMES = "table-names";
    private static final String URL = "url";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String DATABASE_NAMES = "database-names";

    @Override
    public String getDataSourceName() {
        return "KAFKA-KINGBASE";
    }

    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        if (pluginType != PluginType.SOURCE) {
            throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
        }
        excludedKeys.add(SCHEMA);
        excludedKeys.add(TOPIC);
        excludedKeys.add(PATTERN);
        excludedKeys.add(FORMAT);
        return super.filterOptionRule(connectorName, dataSourceOptionRule, virtualTableOptionRule, businessMode, pluginType, connectorOptionRule, addRequiredOptions, addOptionalOptions, excludedKeys);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        if (pluginType != PluginType.SOURCE) {
            throw new UnsupportedOperationException("Unsupported plugin type: " + pluginType);
        }
        String topics = String.join((CharSequence)",", dataSourceOption.getDatabases());
        connectorConfig = connectorConfig.withValue(TOPIC, ConfigValueFactory.fromAnyRef((Object)topics));
        connectorConfig = connectorConfig.withValue(FORMAT, ConfigValueFactory.fromAnyRef((Object)"KINGBASE_JSON"));
        connectorConfig = connectorConfig.withValue(DATABASE_NAMES, (ConfigValue)ConfigValueFactory.fromIterable(dataSourceOption.getDatabases()));
        connectorConfig = connectorConfig.withValue(TABLE_NAMES, (ConfigValue)ConfigValueFactory.fromIterable(KafkaKingbaseDataSourceConfigSwitcher.mergeDatabaseAndTables(dataSourceOption)));
        Config config = ConfigFactory.empty();
        config = config.withValue(FACTORY, ConfigValueFactory.fromAnyRef((Object)"kingbase"));
        config = config.withValue(URL, dataSourceInstanceConfig.getValue(URL));
        config = config.withValue(USER, dataSourceInstanceConfig.getValue(USER));
        config = config.withValue(PASSWORD, dataSourceInstanceConfig.getValue(PASSWORD));
        connectorConfig = connectorConfig.withValue(CATALOG, (ConfigValue)config.root());
        return super.mergeDatasourceConfig(dataSourceInstanceConfig, virtualTableDetail, dataSourceOption, selectTableFields, businessMode, pluginType, connectorConfig);
    }

    private static List<String> mergeDatabaseAndTables(DataSourceOption dataSourceOption) {
        ArrayList<String> tables = new ArrayList<String>();
        dataSourceOption.getDatabases().forEach(database -> dataSourceOption.getTables().forEach(table -> {
            if (StringUtils.countMatches((CharSequence)table, (CharSequence)".") > 1) {
                tables.add((String)table);
            } else {
                tables.add(KafkaKingbaseDataSourceConfigSwitcher.getDatabaseAndTable(database, table));
            }
        }));
        return tables;
    }

    private static String getDatabaseAndTable(String database, String table) {
        return String.format("%s.%s", database, table);
    }

    public static class SchemaGenerator {
        private static final Logger log = LoggerFactory.getLogger(SchemaGenerator.class);

        private SchemaGenerator() {
        }

        public static Config generateSchemaBySelectTableFields(VirtualTableDetailRes virtualTableDetailRes, SelectTableFields selectTableFields) {
            Preconditions.checkNotNull((Object)selectTableFields, (Object)"selectTableFields cannot be null");
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(selectTableFields.getTableFields()), (Object)"selectTableFields.tableFields cannot be empty");
            Preconditions.checkNotNull((Object)virtualTableDetailRes, (Object)"virtualTableDetailRes cannot be null");
            Preconditions.checkArgument((boolean)CollectionUtils.isNotEmpty(virtualTableDetailRes.getFields()), (Object)"virtualTableDetailRes.fields cannot be empty");
            Map fieldTypeMap = virtualTableDetailRes.getFields().stream().collect(Collectors.toMap(VirtualTableFieldRes::getFieldName, Function.identity()));
            Config schema = ConfigFactory.empty();
            for (String fieldName : selectTableFields.getTableFields()) {
                VirtualTableFieldRes virtualTableFieldRes = (VirtualTableFieldRes)Preconditions.checkNotNull((Object)((VirtualTableFieldRes)fieldTypeMap.get(fieldName)), (Object)String.format("Cannot find the field: %s from virtual table", fieldName));
                schema = schema.withValue(fieldName, ConfigValueFactory.fromAnyRef((Object)virtualTableFieldRes.getFieldType()));
            }
            return schema.atKey("fields");
        }
    }
}

