/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.thirdparty.datasource;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seatunnel.api.configuration.Option;
import org.apache.seatunnel.api.configuration.util.Condition;
import org.apache.seatunnel.api.configuration.util.Expression;
import org.apache.seatunnel.api.configuration.util.OptionRule;
import org.apache.seatunnel.api.configuration.util.RequiredOption;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.job.DataSourceOption;
import org.apache.seatunnel.app.domain.request.job.SelectTableFields;
import org.apache.seatunnel.app.domain.response.datasource.VirtualTableDetailRes;
import org.apache.seatunnel.app.dynamicforms.FormStructure;
import org.apache.seatunnel.app.thirdparty.datasource.DataSourceConfigSwitcher;
import org.apache.seatunnel.app.thirdparty.framework.SeaTunnelOptionRuleWrapper;
import org.apache.seatunnel.app.thirdparty.framework.UnSupportWrapperException;
import org.apache.seatunnel.common.constants.PluginType;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public abstract class AbstractDataSourceConfigSwitcher
implements DataSourceConfigSwitcher {
    @Override
    public FormStructure filterOptionRule(String connectorName, OptionRule dataSourceOptionRule, OptionRule virtualTableOptionRule, BusinessMode businessMode, PluginType pluginType, OptionRule connectorOptionRule, List<RequiredOption> addRequiredOptions, List<Option<?>> addOptionalOptions, List<String> excludedKeys) {
        List dataSourceRequiredAllKey = Stream.concat(dataSourceOptionRule.getRequiredOptions().stream(), virtualTableOptionRule.getRequiredOptions().stream()).flatMap(ro -> ro.getOptions().stream().map(Option::key)).collect(Collectors.toList());
        dataSourceRequiredAllKey.addAll(excludedKeys);
        List dataSourceOptionAllKey = Stream.concat(dataSourceOptionRule.getOptionalOptions().stream(), virtualTableOptionRule.getOptionalOptions().stream()).map(Option::key).collect(Collectors.toList());
        dataSourceOptionAllKey.addAll(excludedKeys);
        List<RequiredOption> requiredOptions = connectorOptionRule.getRequiredOptions().stream().map(requiredOption -> {
            if (requiredOption instanceof RequiredOption.AbsolutelyRequiredOptions) {
                RequiredOption.AbsolutelyRequiredOptions absolutelyRequiredOptions = (RequiredOption.AbsolutelyRequiredOptions)requiredOption;
                List<Option> requiredOpList = absolutelyRequiredOptions.getOptions().stream().filter(op -> !dataSourceRequiredAllKey.contains(op.key()) & !dataSourceOptionAllKey.contains(op.key())).collect(Collectors.toList());
                return requiredOpList.isEmpty() ? null : (RequiredOption)OptionRule.builder().required(requiredOpList.toArray(new Option[0])).build().getRequiredOptions().get(0);
            }
            if (requiredOption instanceof RequiredOption.BundledRequiredOptions) {
                List bundledRequiredOptions = requiredOption.getOptions();
                return bundledRequiredOptions.stream().anyMatch(op -> dataSourceRequiredAllKey.contains(op.key())) ? null : requiredOption;
            }
            if (requiredOption instanceof RequiredOption.ExclusiveRequiredOptions) {
                List exclusiveOptions = requiredOption.getOptions();
                return exclusiveOptions.stream().anyMatch(op -> dataSourceRequiredAllKey.contains(op.key())) ? null : requiredOption;
            }
            if (requiredOption instanceof RequiredOption.ConditionalRequiredOptions) {
                List conditionalRequiredOptions = requiredOption.getOptions();
                RequiredOption.ConditionalRequiredOptions conditionalRequired = (RequiredOption.ConditionalRequiredOptions)requiredOption;
                Expression expression = conditionalRequired.getExpression();
                Condition condition = expression.getCondition();
                List requiredOptionList = conditionalRequired.getRequiredOption();
                List requiredOpList = requiredOptionList.stream().filter(op -> !dataSourceRequiredAllKey.contains(op.key()) & !dataSourceOptionAllKey.contains(op.key())).collect(Collectors.toList());
                Expression expressionNew = Expression.of((Condition)condition);
                return RequiredOption.ConditionalRequiredOptions.of((Expression)expressionNew, requiredOpList);
            }
            throw new UnSupportWrapperException(connectorName, "Unknown", requiredOption.toString());
        }).filter(Objects::nonNull).collect(Collectors.toList());
        List<Option<?>> optionList = connectorOptionRule.getOptionalOptions().stream().filter(option -> !dataSourceOptionAllKey.contains(option.key())).collect(Collectors.toList());
        requiredOptions.addAll(addRequiredOptions);
        optionList.addAll(addOptionalOptions);
        return SeaTunnelOptionRuleWrapper.wrapper(optionList, requiredOptions, connectorName, pluginType);
    }

    @Override
    public Config mergeDatasourceConfig(Config dataSourceInstanceConfig, VirtualTableDetailRes virtualTableDetail, DataSourceOption dataSourceOption, SelectTableFields selectTableFields, BusinessMode businessMode, PluginType pluginType, Config connectorConfig) {
        Config mergedConfig = connectorConfig;
        for (Map.Entry en : dataSourceInstanceConfig.entrySet()) {
            mergedConfig = mergedConfig.withValue((String)en.getKey(), (ConfigValue)en.getValue());
        }
        return mergedConfig;
    }
}

