/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.dag.actions;

import com.hazelcast.collection.IQueue;
import com.hazelcast.core.HazelcastInstance;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.core.dag.actions.ShuffleStrategy;
import org.apache.seatunnel.shade.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShufflePartitionStrategy
extends ShuffleStrategy {
    private static final Logger log = LoggerFactory.getLogger(ShufflePartitionStrategy.class);
    private final Map<Integer, String[]> inputQueueMapping = new HashMap<Integer, String[]>();
    private int targetPartitions;

    public ShufflePartitionStrategy() {
    }

    @Override
    public Map<String, IQueue<Record<?>>> createShuffles(HazelcastInstance hazelcast, int pipelineId, int inputIndex) {
        Preconditions.checkArgument((inputIndex >= 0 && inputIndex < this.getInputPartitions() ? 1 : 0) != 0);
        LinkedHashMap shuffleMap = new LinkedHashMap();
        for (int targetIndex = 0; targetIndex < this.targetPartitions; ++targetIndex) {
            String queueName = this.generateQueueName(pipelineId, inputIndex, targetIndex);
            IQueue<Record<?>> queue = this.getIQueue(hazelcast, queueName);
            queue.clear();
            shuffleMap.put(queueName, queue);
        }
        log.info("pipeline[{}] / reader[{}] assigned shuffle queue list: {}", new Object[]{pipelineId, inputIndex, shuffleMap.keySet()});
        return shuffleMap;
    }

    @Override
    public String createShuffleKey(Record<?> record, int pipelineId, int inputIndex) {
        String[] inputQueueNames = this.inputQueueMapping.computeIfAbsent(inputIndex, key -> {
            String[] queueNames = new String[this.targetPartitions];
            for (int targetIndex = 0; targetIndex < this.targetPartitions; ++targetIndex) {
                queueNames[targetIndex] = this.generateQueueName(pipelineId, (int)key, targetIndex);
            }
            return queueNames;
        });
        return inputQueueNames[ThreadLocalRandom.current().nextInt(this.targetPartitions)];
    }

    @Override
    public IQueue<Record<?>>[] getShuffles(HazelcastInstance hazelcast, int pipelineId, int targetIndex) {
        Preconditions.checkArgument((targetIndex >= 0 && targetIndex < this.targetPartitions ? 1 : 0) != 0);
        IQueue[] shuffles = new IQueue[this.getInputPartitions()];
        for (int inputIndex = 0; inputIndex < this.getInputPartitions(); ++inputIndex) {
            String queueName = this.generateQueueName(pipelineId, inputIndex, targetIndex);
            shuffles[inputIndex] = this.getIQueue(hazelcast, queueName);
        }
        log.info("pipeline[{}] / writer[{}] assigned shuffle queue list: {}", new Object[]{pipelineId, targetIndex, Stream.of(shuffles).map(e -> e.getName()).collect(Collectors.toList())});
        return shuffles;
    }

    private String generateQueueName(int pipelineId, int inputIndex, int targetIndex) {
        return String.format("ShufflePartition-Queue_%s_%s_%s_%s", this.getJobId(), pipelineId, inputIndex, targetIndex);
    }

    protected ShufflePartitionStrategy(ShufflePartitionStrategyBuilder<?, ?> b) {
        super(b);
        this.targetPartitions = ((ShufflePartitionStrategyBuilder)b).targetPartitions;
    }

    public static ShufflePartitionStrategyBuilder<?, ?> builder() {
        return new ShufflePartitionStrategyBuilderImpl();
    }

    public Map<Integer, String[]> getInputQueueMapping() {
        return this.inputQueueMapping;
    }

    public int getTargetPartitions() {
        return this.targetPartitions;
    }

    public void setTargetPartitions(int targetPartitions) {
        this.targetPartitions = targetPartitions;
    }

    @Override
    public String toString() {
        return "ShufflePartitionStrategy(inputQueueMapping=" + this.getInputQueueMapping() + ", targetPartitions=" + this.getTargetPartitions() + ")";
    }

    private static final class ShufflePartitionStrategyBuilderImpl
    extends ShufflePartitionStrategyBuilder<ShufflePartitionStrategy, ShufflePartitionStrategyBuilderImpl> {
        private ShufflePartitionStrategyBuilderImpl() {
        }

        @Override
        protected ShufflePartitionStrategyBuilderImpl self() {
            return this;
        }

        @Override
        public ShufflePartitionStrategy build() {
            return new ShufflePartitionStrategy(this);
        }
    }

    public static abstract class ShufflePartitionStrategyBuilder<C extends ShufflePartitionStrategy, B extends ShufflePartitionStrategyBuilder<C, B>>
    extends ShuffleStrategy.ShuffleStrategyBuilder<C, B> {
        private int targetPartitions;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B targetPartitions(int targetPartitions) {
            this.targetPartitions = targetPartitions;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "ShufflePartitionStrategy.ShufflePartitionStrategyBuilder(super=" + super.toString() + ", targetPartitions=" + this.targetPartitions + ")";
        }
    }
}

