/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.catalog;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.seatunnel.api.table.catalog.TableIdentifier;
import org.apache.seatunnel.api.table.catalog.TableSchema;

public final class CatalogTable
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final TableIdentifier tableId;
    private final TableSchema tableSchema;
    private final Map<String, String> options;
    private final List<String> partitionKeys;
    private final String comment;
    private final String catalogName;

    public static CatalogTable of(TableIdentifier tableId, TableSchema tableSchema, Map<String, String> options, List<String> partitionKeys, String comment) {
        return new CatalogTable(tableId, tableSchema, options, partitionKeys, comment);
    }

    public static CatalogTable of(TableIdentifier tableId, TableSchema tableSchema, Map<String, String> options, List<String> partitionKeys, String comment, String catalogName) {
        return new CatalogTable(tableId, tableSchema, options, partitionKeys, comment, catalogName);
    }

    private CatalogTable(TableIdentifier tableId, TableSchema tableSchema, Map<String, String> options, List<String> partitionKeys, String comment) {
        this(tableId, tableSchema, options, partitionKeys, comment, "");
    }

    private CatalogTable(TableIdentifier tableId, TableSchema tableSchema, Map<String, String> options, List<String> partitionKeys, String comment, String catalogName) {
        this.tableId = tableId;
        this.tableSchema = tableSchema;
        this.options = options;
        this.partitionKeys = partitionKeys;
        this.comment = comment;
        this.catalogName = catalogName;
    }

    public TableIdentifier getTableId() {
        return this.tableId;
    }

    public TableSchema getTableSchema() {
        return this.tableSchema;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public String getComment() {
        return this.comment;
    }

    public String getCatalogName() {
        return this.catalogName;
    }

    public String toString() {
        return "CatalogTable{tableId=" + this.tableId + ", tableSchema=" + this.tableSchema + ", options=" + this.options + ", partitionKeys=" + this.partitionKeys + ", comment='" + this.comment + '\'' + '}';
    }
}

