/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.controller;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import javax.annotation.Resource;
import org.apache.seatunnel.app.common.Result;
import org.apache.seatunnel.app.domain.request.job.JobDAG;
import org.apache.seatunnel.app.domain.request.job.JobTaskInfo;
import org.apache.seatunnel.app.domain.request.job.PluginConfig;
import org.apache.seatunnel.app.domain.response.job.JobTaskCheckRes;
import org.apache.seatunnel.app.service.IJobTaskService;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/seatunnel/api/v1/job/"})
public class JobTaskController {
    @Resource
    private IJobTaskService jobTaskService;

    @PostMapping(value={"/dag/{jobVersionId}"})
    @ApiOperation(value="save job dag", httpMethod="POST")
    Result<JobTaskCheckRes> saveJobDAG(@ApiParam(value="job version id", required=true) @PathVariable long jobVersionId, @ApiParam(value="task info", required=true) @RequestBody JobDAG jobDAG) {
        return Result.success(this.jobTaskService.saveJobDAG(jobVersionId, jobDAG));
    }

    @GetMapping(value={"/{jobVersionId}"})
    @ApiOperation(value="get job task and dag info", httpMethod="GET")
    Result<JobTaskInfo> getJob(@ApiParam(value="job version id", required=true) @PathVariable long jobVersionId) {
        return Result.success(this.jobTaskService.getTaskConfig(jobVersionId));
    }

    @PostMapping(value={"/task/{jobVersionId}"})
    @ApiOperation(value="save or update single task", httpMethod="POST")
    Result<Void> saveSingleTask(@ApiParam(value="job version id", required=true) @PathVariable long jobVersionId, @ApiParam(value="task info", required=true) @RequestBody PluginConfig pluginConfig) {
        this.jobTaskService.saveSingleTask(jobVersionId, pluginConfig);
        return Result.success();
    }

    @GetMapping(value={"/task/{jobVersionId}"})
    @ApiOperation(value="get single task", httpMethod="GET")
    Result<PluginConfig> getSingleTask(@ApiParam(value="job version id", required=true) @PathVariable long jobVersionId, @ApiParam(value="task plugin id", required=true) @RequestParam String pluginId) {
        return Result.success(this.jobTaskService.getSingleTask(jobVersionId, pluginId));
    }

    @DeleteMapping(value={"/task/{jobVersionId}"})
    @ApiOperation(value="delete single task", httpMethod="DELETE")
    Result<Void> deleteSingleTask(@ApiParam(value="job version id", required=true) @PathVariable long jobVersionId, @ApiParam(value="task plugin id", required=true) @RequestParam String pluginId) {
        this.jobTaskService.deleteSingleTask(jobVersionId, pluginId);
        return Result.success();
    }
}

