/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.config;

import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.seatunnel.app.config.YamlSourceFactory;
import org.apache.seatunnel.app.domain.request.connector.BusinessMode;
import org.apache.seatunnel.app.domain.request.connector.SceneMode;
import org.apache.seatunnel.app.domain.response.connector.ConnectorInfo;
import org.apache.seatunnel.app.domain.response.connector.DataSourceInfo;
import org.apache.seatunnel.common.constants.PluginType;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.PropertySource;

@Configuration
@PropertySource(value={"classpath:connector-datasource-mapper.yaml"}, factory=YamlSourceFactory.class)
@ConfigurationProperties(prefix="connector-datasource-mapper")
public class ConnectorDataSourceMapperConfig {
    private Map<String, ConnectorMapper> connectorDatasourceMappers;
    private Map<String, DatasourceFeatures> sourceDatasourceFeatures;
    private Map<String, DatasourceFeatures> sinkDatasourceFeatures;

    public Optional<List<BusinessMode>> supportedBusinessMode(String datasourceName, PluginType pluginType) {
        if (pluginType.equals((Object)PluginType.SOURCE)) {
            return Optional.ofNullable(this.sourceDatasourceFeatures.get(datasourceName)).map(cm -> cm.getBusinessMode().stream().map(BusinessMode::valueOf).collect(Collectors.toList()));
        }
        if (pluginType.equals((Object)PluginType.SINK)) {
            return Optional.ofNullable(this.sinkDatasourceFeatures.get(datasourceName)).map(cm -> cm.getBusinessMode().stream().map(BusinessMode::valueOf).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("pluginType : " + pluginType + " not support BusinessMode");
    }

    public Optional<List<SceneMode>> supportedSceneMode(String datasourceName, PluginType pluginType) {
        if (pluginType.equals((Object)PluginType.SOURCE)) {
            return Optional.ofNullable(this.sourceDatasourceFeatures.get(datasourceName)).map(cm -> cm.getSceneMode().stream().map(SceneMode::valueOf).collect(Collectors.toList()));
        }
        if (pluginType.equals((Object)PluginType.SINK)) {
            return Optional.ofNullable(this.sinkDatasourceFeatures.get(datasourceName)).map(cm -> cm.getSceneMode().stream().map(SceneMode::valueOf).collect(Collectors.toList()));
        }
        throw new UnsupportedOperationException("pluginType : " + pluginType + " not support SceneMode");
    }

    public Optional<String> findConnectorForDatasourceName(String datasourceName) {
        return this.connectorDatasourceMappers.entrySet().stream().map(en -> ((ConnectorMapper)en.getValue()).getDataSources().stream().anyMatch(n -> n.equalsIgnoreCase(datasourceName)) ? (String)en.getKey() : null).filter(Objects::nonNull).findFirst();
    }

    public List<DataSourceInfo> findDatasourceNameForConnectors(List<ConnectorInfo> connectors) {
        Map<String, ConnectorInfo> connectorMap = connectors.stream().collect(Collectors.toMap(connectorInfo -> connectorInfo.getPluginIdentifier().getPluginName(), connectorInfo -> connectorInfo));
        return this.connectorDatasourceMappers.entrySet().stream().filter(en -> connectorMap.containsKey(en.getKey())).flatMap(en -> ((ConnectorMapper)en.getValue()).getDataSources().stream().map(name -> new DataSourceInfo((ConnectorInfo)connectorMap.get(en.getKey()), (String)name))).collect(Collectors.toList());
    }

    public Map<String, ConnectorMapper> getConnectorDatasourceMappers() {
        return this.connectorDatasourceMappers;
    }

    public Map<String, DatasourceFeatures> getSourceDatasourceFeatures() {
        return this.sourceDatasourceFeatures;
    }

    public Map<String, DatasourceFeatures> getSinkDatasourceFeatures() {
        return this.sinkDatasourceFeatures;
    }

    public void setConnectorDatasourceMappers(Map<String, ConnectorMapper> connectorDatasourceMappers) {
        this.connectorDatasourceMappers = connectorDatasourceMappers;
    }

    public void setSourceDatasourceFeatures(Map<String, DatasourceFeatures> sourceDatasourceFeatures) {
        this.sourceDatasourceFeatures = sourceDatasourceFeatures;
    }

    public void setSinkDatasourceFeatures(Map<String, DatasourceFeatures> sinkDatasourceFeatures) {
        this.sinkDatasourceFeatures = sinkDatasourceFeatures;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorDataSourceMapperConfig)) {
            return false;
        }
        ConnectorDataSourceMapperConfig other = (ConnectorDataSourceMapperConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Map<String, ConnectorMapper> this$connectorDatasourceMappers = this.getConnectorDatasourceMappers();
        Map<String, ConnectorMapper> other$connectorDatasourceMappers = other.getConnectorDatasourceMappers();
        if (this$connectorDatasourceMappers == null ? other$connectorDatasourceMappers != null : !((Object)this$connectorDatasourceMappers).equals(other$connectorDatasourceMappers)) {
            return false;
        }
        Map<String, DatasourceFeatures> this$sourceDatasourceFeatures = this.getSourceDatasourceFeatures();
        Map<String, DatasourceFeatures> other$sourceDatasourceFeatures = other.getSourceDatasourceFeatures();
        if (this$sourceDatasourceFeatures == null ? other$sourceDatasourceFeatures != null : !((Object)this$sourceDatasourceFeatures).equals(other$sourceDatasourceFeatures)) {
            return false;
        }
        Map<String, DatasourceFeatures> this$sinkDatasourceFeatures = this.getSinkDatasourceFeatures();
        Map<String, DatasourceFeatures> other$sinkDatasourceFeatures = other.getSinkDatasourceFeatures();
        return !(this$sinkDatasourceFeatures == null ? other$sinkDatasourceFeatures != null : !((Object)this$sinkDatasourceFeatures).equals(other$sinkDatasourceFeatures));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectorDataSourceMapperConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, ConnectorMapper> $connectorDatasourceMappers = this.getConnectorDatasourceMappers();
        result = result * 59 + ($connectorDatasourceMappers == null ? 43 : ((Object)$connectorDatasourceMappers).hashCode());
        Map<String, DatasourceFeatures> $sourceDatasourceFeatures = this.getSourceDatasourceFeatures();
        result = result * 59 + ($sourceDatasourceFeatures == null ? 43 : ((Object)$sourceDatasourceFeatures).hashCode());
        Map<String, DatasourceFeatures> $sinkDatasourceFeatures = this.getSinkDatasourceFeatures();
        result = result * 59 + ($sinkDatasourceFeatures == null ? 43 : ((Object)$sinkDatasourceFeatures).hashCode());
        return result;
    }

    public String toString() {
        return "ConnectorDataSourceMapperConfig(connectorDatasourceMappers=" + this.getConnectorDatasourceMappers() + ", sourceDatasourceFeatures=" + this.getSourceDatasourceFeatures() + ", sinkDatasourceFeatures=" + this.getSinkDatasourceFeatures() + ")";
    }

    public static class DatasourceFeatures {
        private List<String> businessMode;
        private List<String> sceneMode;

        public List<String> getBusinessMode() {
            return this.businessMode;
        }

        public List<String> getSceneMode() {
            return this.sceneMode;
        }

        public void setBusinessMode(List<String> businessMode) {
            this.businessMode = businessMode;
        }

        public void setSceneMode(List<String> sceneMode) {
            this.sceneMode = sceneMode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DatasourceFeatures)) {
                return false;
            }
            DatasourceFeatures other = (DatasourceFeatures)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$businessMode = this.getBusinessMode();
            List<String> other$businessMode = other.getBusinessMode();
            if (this$businessMode == null ? other$businessMode != null : !((Object)this$businessMode).equals(other$businessMode)) {
                return false;
            }
            List<String> this$sceneMode = this.getSceneMode();
            List<String> other$sceneMode = other.getSceneMode();
            return !(this$sceneMode == null ? other$sceneMode != null : !((Object)this$sceneMode).equals(other$sceneMode));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DatasourceFeatures;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $businessMode = this.getBusinessMode();
            result = result * 59 + ($businessMode == null ? 43 : ((Object)$businessMode).hashCode());
            List<String> $sceneMode = this.getSceneMode();
            result = result * 59 + ($sceneMode == null ? 43 : ((Object)$sceneMode).hashCode());
            return result;
        }

        public String toString() {
            return "ConnectorDataSourceMapperConfig.DatasourceFeatures(businessMode=" + this.getBusinessMode() + ", sceneMode=" + this.getSceneMode() + ")";
        }
    }

    public static class ConnectorMapper {
        private List<String> dataSources;

        public List<String> getDataSources() {
            return this.dataSources;
        }

        public void setDataSources(List<String> dataSources) {
            this.dataSources = dataSources;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ConnectorMapper)) {
                return false;
            }
            ConnectorMapper other = (ConnectorMapper)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<String> this$dataSources = this.getDataSources();
            List<String> other$dataSources = other.getDataSources();
            return !(this$dataSources == null ? other$dataSources != null : !((Object)this$dataSources).equals(other$dataSources));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ConnectorMapper;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<String> $dataSources = this.getDataSources();
            result = result * 59 + ($dataSources == null ? 43 : ((Object)$dataSources).hashCode());
            return result;
        }

        public String toString() {
            return "ConnectorDataSourceMapperConfig.ConnectorMapper(dataSources=" + this.getDataSources() + ")";
        }
    }
}

