/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.common;

public enum ScriptStatusEnum {
    UNPUBLISHED(0, "unpublished"),
    PUBLISHED(1, "published"),
    DELETED(2, "deleted");

    private final int code;
    private final String description;

    private ScriptStatusEnum(int code, String description) {
        this.code = code;
        this.description = description;
    }

    public static String parse(Byte status) {
        if (status == null) {
            throw new IllegalArgumentException("status is null");
        }
        for (ScriptStatusEnum scriptStatusEnum : ScriptStatusEnum.values()) {
            if (scriptStatusEnum.getCode() != status.byteValue()) continue;
            return scriptStatusEnum.getDescription();
        }
        throw new IllegalArgumentException("status is illegal");
    }

    public int getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

