/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.app.bean.engine;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertException;
import org.apache.seatunnel.api.table.catalog.DataTypeConvertor;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.DecimalType;
import org.apache.seatunnel.api.table.type.LocalTimeType;
import org.apache.seatunnel.api.table.type.PrimitiveByteArrayType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;

public class EngineDataType {
    private static final Map<String, DataType> DATA_TYPE_MAP = Arrays.stream(DataType.values()).collect(Collectors.toMap(DataType::getName, Function.identity()));

    public static List<DataType> getAllDataType() {
        return Arrays.asList(DataType.values());
    }

    public static class SeaTunnelDataTypeConvertor
    implements DataTypeConvertor<SeaTunnelDataType<?>> {
        public SeaTunnelDataType<?> toSeaTunnelType(String engineDataType) {
            return ((DataType)((Object)DATA_TYPE_MAP.get(engineDataType.toLowerCase(Locale.ROOT)))).getRawType();
        }

        public SeaTunnelDataType<?> toSeaTunnelType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> map) throws DataTypeConvertException {
            return seaTunnelDataType;
        }

        public SeaTunnelDataType<?> toConnectorType(SeaTunnelDataType<?> seaTunnelDataType, Map<String, Object> map) throws DataTypeConvertException {
            return seaTunnelDataType;
        }

        public String getIdentity() {
            return "EngineDataTypeConvertor";
        }
    }

    public static enum DataType {
        T_STRING("string", (SeaTunnelDataType<?>)BasicType.STRING_TYPE),
        T_BOOLEAN("boolean", (SeaTunnelDataType<?>)BasicType.BOOLEAN_TYPE),
        T_BYTE("tinyint", (SeaTunnelDataType<?>)BasicType.BYTE_TYPE),
        T_SHORT("smallint", (SeaTunnelDataType<?>)BasicType.SHORT_TYPE),
        T_INT("int", (SeaTunnelDataType<?>)BasicType.INT_TYPE),
        T_LONG("bigint", (SeaTunnelDataType<?>)BasicType.LONG_TYPE),
        T_FLOAT("float", (SeaTunnelDataType<?>)BasicType.FLOAT_TYPE),
        T_DOUBLE("double", (SeaTunnelDataType<?>)BasicType.DOUBLE_TYPE),
        T_VOID("null", (SeaTunnelDataType<?>)BasicType.VOID_TYPE),
        T_DECIMAL("decimal(38, 18)", (SeaTunnelDataType<?>)new DecimalType(38, 18)),
        T_LOCAL_DATE("date", (SeaTunnelDataType<?>)LocalTimeType.LOCAL_DATE_TYPE),
        T_LOCAL_TIME("time", (SeaTunnelDataType<?>)LocalTimeType.LOCAL_TIME_TYPE),
        T_LOCAL_DATE_TIME("timestamp", (SeaTunnelDataType<?>)LocalTimeType.LOCAL_DATE_TIME_TYPE),
        T_PRIMITIVE_BYTE_ARRAY("bytes", (SeaTunnelDataType<?>)PrimitiveByteArrayType.INSTANCE),
        T_STRING_ARRAY("array<string>", (SeaTunnelDataType<?>)ArrayType.STRING_ARRAY_TYPE),
        T_BOOLEAN_ARRAY("array<boolean>", (SeaTunnelDataType<?>)ArrayType.BOOLEAN_ARRAY_TYPE),
        T_BYTE_ARRAY("array<tinyint>", (SeaTunnelDataType<?>)ArrayType.BYTE_ARRAY_TYPE),
        T_SHORT_ARRAY("array<smallint>", (SeaTunnelDataType<?>)ArrayType.SHORT_ARRAY_TYPE),
        T_INT_ARRAY("array<int>", (SeaTunnelDataType<?>)ArrayType.INT_ARRAY_TYPE),
        T_LONG_ARRAY("array<bigint>", (SeaTunnelDataType<?>)ArrayType.LONG_ARRAY_TYPE),
        T_FLOAT_ARRAY("array<float>", (SeaTunnelDataType<?>)ArrayType.FLOAT_ARRAY_TYPE),
        T_DOUBLE_ARRAY("array<double>", (SeaTunnelDataType<?>)ArrayType.DOUBLE_ARRAY_TYPE);

        private final String name;
        private final SeaTunnelDataType<?> RawType;

        private DataType(String name, SeaTunnelDataType<?> rawType) {
            this.name = name;
            this.RawType = rawType;
        }

        public String getName() {
            return this.name;
        }

        public SeaTunnelDataType<?> getRawType() {
            return this.RawType;
        }
    }
}

