/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.parse;

import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.api.common.CommonOptions;
import org.apache.seatunnel.api.configuration.ReadonlyConfig;
import org.apache.seatunnel.api.configuration.util.OptionValidationException;
import org.apache.seatunnel.api.table.factory.Factory;
import org.apache.seatunnel.api.table.factory.FactoryUtil;
import org.apache.seatunnel.engine.common.exception.JobDefineCheckException;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Tuple2;

public final class ConfigParserUtil {
    private static final Logger log = LoggerFactory.getLogger(ConfigParserUtil.class);

    private ConfigParserUtil() {
    }

    public static <T extends Factory> Set<URL> getFactoryUrls(ReadonlyConfig readonlyConfig, ClassLoader classLoader, Class<T> factoryClass, String factoryId) {
        HashSet<URL> factoryUrls = new HashSet<URL>();
        URL factoryUrl = FactoryUtil.getFactoryUrl(FactoryUtil.discoverFactory(classLoader, factoryClass, factoryId));
        factoryUrls.add(factoryUrl);
        return factoryUrls;
    }

    public static void checkGraph(List<? extends Config> sources, List<? extends Config> transforms, List<? extends Config> sinks) {
        log.debug("Check whether this config file can generate DAG:");
        if (CollectionUtils.isEmpty(sources) || CollectionUtils.isEmpty(sinks)) {
            throw new JobDefineCheckException("Source And Sink can not be null");
        }
        if (ConfigParserUtil.isSimpleGraph(sources, transforms, sinks)) {
            ConfigParserUtil.checkSimpleGraph(sources, transforms, sinks);
            return;
        }
        ConfigParserUtil.checkComplexGraph(sources, transforms, sinks);
    }

    private static boolean isSimpleGraph(List<? extends Config> sources, List<? extends Config> transforms, List<? extends Config> sinks) {
        return sources.size() == 1 && sinks.size() == 1 && (CollectionUtils.isEmpty(transforms) || transforms.size() == 1);
    }

    private static void checkSimpleGraph(List<? extends Config> sources, List<? extends Config> transforms, List<? extends Config> sinks) {
        log.debug("This is a simple DAG.");
        ReadonlyConfig source = ReadonlyConfig.fromConfig(sources.get(0));
        ReadonlyConfig sink = ReadonlyConfig.fromConfig(sinks.get(0));
        if (transforms.size() == 0) {
            ConfigParserUtil.checkEdge(source, sink);
        } else {
            ReadonlyConfig transform = ReadonlyConfig.fromConfig(transforms.get(0));
            ConfigParserUtil.checkEdge(source, transform);
            ConfigParserUtil.checkEdge(transform, sink);
        }
    }

    @Deprecated
    private static void checkEdge(ReadonlyConfig leftConfig, ReadonlyConfig rightConfig) {
        String inputTableId;
        String tableId = ConfigParserUtil.getTableId(leftConfig);
        if (tableId.equals(inputTableId = ConfigParserUtil.getInputIds(rightConfig).get(0))) {
            return;
        }
        log.info(String.format("Currently, incorrect configuration of %s and %s options don't affect job running. In the future we will ban incorrect configurations.", CommonOptions.SOURCE_TABLE_NAME.key(), CommonOptions.RESULT_TABLE_NAME.key()));
        if ("default-identifier".equals(tableId)) {
            log.warn(String.format("This configuration is not recommended.A source/transform(%s) is not configured with '%s' option, but subsequent transform/sink(%s) is configured with '%s' option value of '%s'.", ConfigParserUtil.getFactoryId(leftConfig), CommonOptions.RESULT_TABLE_NAME.key(), ConfigParserUtil.getFactoryId(rightConfig), CommonOptions.SOURCE_TABLE_NAME.key(), inputTableId));
            return;
        }
        if ("default-identifier".equals(inputTableId)) {
            log.warn(String.format("This configuration is not recommended. A source/transform(%s) is configured with '%s' option value of '%s', but subsequent transform/sink(%s) is not configured with '%s' option.", ConfigParserUtil.getFactoryId(leftConfig), CommonOptions.RESULT_TABLE_NAME.key(), tableId, ConfigParserUtil.getFactoryId(rightConfig), CommonOptions.SOURCE_TABLE_NAME.key()));
            return;
        }
        log.error(String.format("The '%s' option configured in [%s] is incorrect, and the source/transform[%s] is not found.", CommonOptions.SOURCE_TABLE_NAME.key(), ConfigParserUtil.getFactoryId(rightConfig), inputTableId));
    }

    private static void checkComplexGraph(List<? extends Config> sources, List<? extends Config> transforms, List<? extends Config> sinks) {
        log.debug("Start checking the correctness of the complex DAG: ");
        log.debug(String.format("Phase 1: Check whether '%s' option is configured.", CommonOptions.RESULT_TABLE_NAME.key()));
        ConfigParserUtil.checkExistTableId(sources);
        ConfigParserUtil.checkExistTableId(transforms);
        log.debug(String.format("Phase 2: Check whether '%s' option is configured.", CommonOptions.SOURCE_TABLE_NAME.key()));
        ConfigParserUtil.checkExistInputTableId(transforms);
        ConfigParserUtil.checkExistInputTableId(sinks);
        log.debug("Phase 3: Generate virtual vertices.");
        HashMap<String, Tuple2<Config, VertexStatus>> vertexStatusMap = new HashMap<String, Tuple2<Config, VertexStatus>>();
        ConfigParserUtil.fillVirtualVertices(sources, vertexStatusMap);
        ConfigParserUtil.fillVirtualVertices(transforms, vertexStatusMap);
        log.debug("Phase 4: Check if a non-existent vertex is used.");
        ConfigParserUtil.checkInputId(transforms, vertexStatusMap);
        ConfigParserUtil.checkInputId(sinks, vertexStatusMap);
        log.debug("Phase 5: Check if there are unused vertex.");
        ConfigParserUtil.checkLinked(vertexStatusMap);
    }

    private static void fillVirtualVertices(List<? extends Config> configs, Map<String, Tuple2<Config, VertexStatus>> vertexStatusMap) {
        for (Config config : configs) {
            vertexStatusMap.compute(config.getString(CommonOptions.RESULT_TABLE_NAME.key()), (id, old) -> {
                if (old != null) {
                    throw new JobDefineCheckException(String.format("The value of the '%s' option of the (%s and %s) plugins is both '%s', and they must be different.", CommonOptions.RESULT_TABLE_NAME.key(), config.getString(CommonOptions.PLUGIN_NAME.key()), ((Config)old._1()).getString(CommonOptions.PLUGIN_NAME.key()), id));
                }
                return new Tuple2<Config, VertexStatus>(config, VertexStatus.CREATED);
            });
        }
    }

    private static void checkInputId(List<? extends Config> configs, Map<String, Tuple2<Config, VertexStatus>> vertexStatusMap) {
        for (Config config : configs) {
            List<String> inputIds = ConfigParserUtil.getInputIds(ReadonlyConfig.fromConfig(config));
            inputIds.forEach(inputId -> vertexStatusMap.compute((String)inputId, (id, old) -> {
                if (old == null) {
                    throw new JobDefineCheckException(String.format("The '%s' option configured in [%s] is incorrect, and the source/transform[%s] is not found.", CommonOptions.SOURCE_TABLE_NAME.key(), config.getString(CommonOptions.PLUGIN_NAME.key()), id));
                }
                return new Tuple2<Config, VertexStatus>((Config)old._1(), VertexStatus.LINKED);
            }));
        }
    }

    private static void checkLinked(Map<String, Tuple2<Config, VertexStatus>> vertexStatusMap) {
        vertexStatusMap.forEach((id, vertex) -> {
            if (vertex._2() == VertexStatus.CREATED) {
                throw new JobDefineCheckException(String.format("The '%s' option configured is incorrect, this table(%s) belonging to source/transform(%s) is not used.", CommonOptions.SOURCE_TABLE_NAME.key(), id, ((Config)vertex._1()).getString(CommonOptions.PLUGIN_NAME.key())));
            }
        });
    }

    private static void checkExistTableId(List<? extends Config> configs) {
        for (Config config : configs) {
            if (config.hasPath(CommonOptions.RESULT_TABLE_NAME.key())) continue;
            throw new JobDefineCheckException(String.format("The source/transform(%s) is not configured with '%s' option", config.getString(CommonOptions.PLUGIN_NAME.key()), CommonOptions.RESULT_TABLE_NAME.key()), new OptionValidationException(CommonOptions.RESULT_TABLE_NAME));
        }
    }

    private static void checkExistInputTableId(List<? extends Config> configs) {
        for (Config config : configs) {
            if (config.hasPath(CommonOptions.SOURCE_TABLE_NAME.key())) continue;
            throw new JobDefineCheckException(String.format("The transform/sink(%s) is not configured with '%s' option", config.getString(CommonOptions.PLUGIN_NAME.key()), CommonOptions.SOURCE_TABLE_NAME.key()), new OptionValidationException(CommonOptions.SOURCE_TABLE_NAME));
        }
    }

    private static String getTableId(ReadonlyConfig config) {
        return config.getOptional(CommonOptions.RESULT_TABLE_NAME).orElse("default-identifier");
    }

    static List<String> getInputIds(ReadonlyConfig config) {
        return config.getOptional(CommonOptions.SOURCE_TABLE_NAME).orElse(Collections.singletonList("default-identifier"));
    }

    public static String getFactoryId(ReadonlyConfig readonlyConfig) {
        String pluginName = readonlyConfig.get(CommonOptions.PLUGIN_NAME);
        if (StringUtils.isBlank(pluginName)) {
            throw new JobDefineCheckException(String.format("The '%s' option is not configured, please configure it.", CommonOptions.PLUGIN_NAME.key()));
        }
        return pluginName;
    }

    public static String getFactoryId(Config config) {
        return ConfigParserUtil.getFactoryId(ReadonlyConfig.fromConfig(config));
    }

    private static enum VertexStatus {
        CREATED,
        LINKED;

    }
}

