/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.Serializable;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.utils.SerializationException;

public class SerializationUtils {
    public static String objectToString(Serializable obj) {
        if (obj != null) {
            return Base64.encodeBase64String(SerializationUtils.serialize(obj));
        }
        return null;
    }

    public static <T extends Serializable> T stringToObject(String str) {
        if (StringUtils.isNotEmpty(str)) {
            return SerializationUtils.deserialize(Base64.decodeBase64(str));
        }
        return null;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> byte[] serialize(T obj) {
        try (ByteArrayOutputStream b = new ByteArrayOutputStream(512);){
            byte[] byArray;
            try (ObjectOutputStream out = new ObjectOutputStream(b);){
                out.writeObject(obj);
                byArray = b.toByteArray();
            }
            return byArray;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserialize(byte[] bytes) {
        try (ByteArrayInputStream s2 = new ByteArrayInputStream(bytes);){
            Serializable serializable;
            try (ObjectInputStream in = new ObjectInputStream(s2){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    ClassLoader cl = Thread.currentThread().getContextClassLoader();
                    if (cl == null) {
                        return super.resolveClass(desc);
                    }
                    return Class.forName(desc.getName(), false, cl);
                }
            };){
                Serializable obj;
                serializable = obj = (Serializable)in.readObject();
            }
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new SerializationException(ex);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static <T extends Serializable> T deserialize(byte[] bytes, final ClassLoader classLoader) {
        try (ByteArrayInputStream s2 = new ByteArrayInputStream(bytes);){
            Serializable serializable;
            try (ObjectInputStream in = new ObjectInputStream(s2){

                @Override
                protected Class<?> resolveClass(ObjectStreamClass desc) throws IOException, ClassNotFoundException {
                    if (classLoader == null) {
                        return super.resolveClass(desc);
                    }
                    return Class.forName(desc.getName(), false, classLoader);
                }
            };){
                Serializable obj;
                serializable = obj = (Serializable)in.readObject();
            }
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException ex) {
            throw new SerializationException(ex);
        }
    }
}

