/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.serialization.impl.compact.record;

import com.hazelcast.internal.serialization.impl.compact.Schema;
import com.hazelcast.internal.serialization.impl.compact.record.ComponentReader;
import com.hazelcast.nio.serialization.HazelcastSerializationException;
import com.hazelcast.nio.serialization.compact.CompactReader;
import java.lang.reflect.Constructor;

public final class JavaRecordReader {
    private final Constructor<?> recordConstructor;
    private final ComponentReader[] componentReaders;

    public JavaRecordReader(Constructor<?> recordConstructor, ComponentReader[] componentReaders) {
        this.recordConstructor = recordConstructor;
        this.componentReaders = componentReaders;
    }

    public Object readRecord(CompactReader compactReader, Schema schema) {
        Object[] components = new Object[this.componentReaders.length];
        try {
            for (int i = 0; i < this.componentReaders.length; ++i) {
                components[i] = this.componentReaders[i].readComponent(compactReader, schema);
            }
            return this.recordConstructor.newInstance(components);
        }
        catch (Exception e) {
            throw new HazelcastSerializationException("Failed to read the Java record", e);
        }
    }
}

