/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.group;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seatunnel.api.table.type.Record;
import org.apache.seatunnel.engine.server.execution.Task;
import org.apache.seatunnel.engine.server.execution.TaskGroupLocation;
import org.apache.seatunnel.engine.server.task.SeaTunnelTask;
import org.apache.seatunnel.engine.server.task.group.AbstractTaskGroupWithIntermediateQueue;
import org.apache.seatunnel.engine.server.task.group.queue.AbstractIntermediateQueue;
import org.apache.seatunnel.engine.server.task.group.queue.IntermediateBlockingQueue;

public class TaskGroupWithIntermediateBlockingQueue
extends AbstractTaskGroupWithIntermediateQueue {
    public static final int QUEUE_SIZE = 2048;
    private Map<Long, BlockingQueue<Record<?>>> blockingQueueCache = null;

    public TaskGroupWithIntermediateBlockingQueue(TaskGroupLocation taskGroupLocation, String taskGroupName, Collection<Task> tasks) {
        super(taskGroupLocation, taskGroupName, tasks);
    }

    @Override
    public void init() {
        this.blockingQueueCache = new ConcurrentHashMap();
        this.getTasks().stream().filter(SeaTunnelTask.class::isInstance).map(s2 -> (SeaTunnelTask)s2).forEach(s2 -> s2.setTaskGroup(this));
    }

    @Override
    public AbstractIntermediateQueue<?> getQueueCache(long id) {
        this.blockingQueueCache.computeIfAbsent(id, i -> new ArrayBlockingQueue(2048));
        return new IntermediateBlockingQueue(this.blockingQueueCache.get(id));
    }
}

