/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common;

import java.util.Properties;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.shade.com.typesafe.config.Config;
import org.apache.seatunnel.shade.com.typesafe.config.ConfigValue;

public final class PropertiesUtil {
    private PropertiesUtil() {
    }

    public static void setProperties(Config config, Properties properties, String prefix, boolean keepPrefix) {
        config.entrySet().forEach(entry -> {
            String key = (String)entry.getKey();
            Object value = ((ConfigValue)entry.getValue()).unwrapped();
            if (key.startsWith(prefix)) {
                if (keepPrefix) {
                    properties.put(key, value);
                } else {
                    properties.put(key.substring(prefix.length()), value);
                }
            }
        });
    }

    public static <E extends Enum<E>> E getEnum(Config conf, String key, Class<E> enumClass, E defaultEnum) {
        if (!conf.hasPath(key)) {
            return defaultEnum;
        }
        String value = conf.getString(key);
        if (StringUtils.isBlank(value)) {
            return defaultEnum;
        }
        return Enum.valueOf(enumClass, value.toUpperCase());
    }

    public static <T> void setOption(Config config, String optionName, T defaultValue, Function<String, T> getter2, Consumer<T> setter2) {
        T value = config.hasPath(optionName) ? getter2.apply(optionName) : defaultValue;
        if (value != null) {
            setter2.accept(value);
        }
    }

    public static <T> void setOption(Config config, String optionName, Function<String, T> getter2, Consumer<T> setter2) {
        Object value = null;
        if (config.hasPath(optionName)) {
            value = getter2.apply(optionName);
        }
        if (value != null) {
            setter2.accept(value);
        }
    }
}

