/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.type;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.api.table.type.SqlType;

public class MultipleRowType
implements SeaTunnelDataType<SeaTunnelRow>,
Iterable<Map.Entry<String, SeaTunnelRowType>> {
    private final Map<String, SeaTunnelRowType> rowTypeMap;
    private String[] tableIds;

    public MultipleRowType(String[] tableIds, SeaTunnelRowType[] rowTypes) {
        LinkedHashMap<String, SeaTunnelRowType> rowTypeMap = new LinkedHashMap<String, SeaTunnelRowType>();
        for (int i = 0; i < tableIds.length; ++i) {
            rowTypeMap.put(tableIds[i], rowTypes[i]);
        }
        this.tableIds = tableIds;
        this.rowTypeMap = rowTypeMap;
    }

    public MultipleRowType(Map<String, SeaTunnelRowType> rowTypeMap) {
        this.tableIds = rowTypeMap.keySet().toArray(new String[0]);
        this.rowTypeMap = rowTypeMap;
    }

    public SeaTunnelRowType getRowType(String tableId) {
        return this.rowTypeMap.get(tableId);
    }

    @Override
    public Class<SeaTunnelRow> getTypeClass() {
        return SeaTunnelRow.class;
    }

    @Override
    public SqlType getSqlType() {
        return SqlType.MULTIPLE_ROW;
    }

    @Override
    public Iterator<Map.Entry<String, SeaTunnelRowType>> iterator() {
        return this.rowTypeMap.entrySet().iterator();
    }

    public String[] getTableIds() {
        return this.tableIds;
    }
}

