/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.security;

import com.hazelcast.jet.core.ProcessorMetaSupplier;
import com.hazelcast.jet.impl.execution.init.Contexts;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.security.impl.function.SecuredFunction;
import com.hazelcast.security.permission.CachePermission;
import com.hazelcast.security.permission.ListPermission;
import com.hazelcast.security.permission.MapPermission;
import java.security.Permission;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;

public final class PermissionsUtil {
    private PermissionsUtil() {
    }

    @Nullable
    public static Permission checkRemote(@Nullable String clientXml, @Nonnull Permission permission) {
        if (clientXml == null) {
            return permission;
        }
        return null;
    }

    @Nullable
    public static Permission mapUpdatePermission(@Nullable String clientXml, @Nonnull String name) {
        return PermissionsUtil.checkRemote(clientXml, new MapPermission(name, "create", "put", "remove", "read"));
    }

    @Nullable
    public static Permission mapPutPermission(@Nullable String clientXml, @Nonnull String name) {
        return PermissionsUtil.checkRemote(clientXml, new MapPermission(name, "create", "put"));
    }

    @Nullable
    public static Permission cachePutPermission(@Nullable String clientXml, @Nonnull String name) {
        return PermissionsUtil.checkRemote(clientXml, new CachePermission(name, "create", "put"));
    }

    @Nullable
    public static Permission listAddPermission(@Nullable String clientXml, @Nonnull String name) {
        return PermissionsUtil.checkRemote(clientXml, new ListPermission(name, "create", "add"));
    }

    @Nullable
    public static Permission listReadPermission(@Nullable String clientXml, @Nonnull String name) {
        return PermissionsUtil.checkRemote(clientXml, new ListPermission(name, "create", "read"));
    }

    public static void checkPermission(SecuredFunction function, ProcessorMetaSupplier.Context context) {
        if (context instanceof Contexts.MetaSupplierCtx) {
            Contexts.MetaSupplierCtx metaSupplierCtx = (Contexts.MetaSupplierCtx)context;
            List<Permission> permissions = function.permissions();
            SecurityContext securityContext = metaSupplierCtx.nodeEngine().getNode().securityContext;
            Subject subject = metaSupplierCtx.subject();
            if (securityContext != null && permissions != null && !permissions.isEmpty() && subject != null) {
                permissions.forEach(permission -> {
                    if (permission != null) {
                        securityContext.checkPermission(subject, (Permission)permission);
                    }
                });
            }
        }
    }
}

