/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.util;

import com.hazelcast.core.HazelcastException;
import com.hazelcast.instance.impl.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.invoke.WrongMethodTypeException;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.ExecutionException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ExceptionUtil {
    private static final String EXCEPTION_SEPARATOR = "------ submitted from ------";
    private static final BiFunction<Throwable, String, HazelcastException> HAZELCAST_EXCEPTION_WRAPPER = (throwable, message) -> {
        if (message != null) {
            return new HazelcastException((String)message, (Throwable)throwable);
        }
        return new HazelcastException((Throwable)throwable);
    };

    private ExceptionUtil() {
    }

    public static String toString(Throwable cause) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        cause.printStackTrace(pw);
        return sw.toString();
    }

    public static RuntimeException peel(Throwable t) {
        return (RuntimeException)ExceptionUtil.peel(t, null, null, HAZELCAST_EXCEPTION_WRAPPER);
    }

    public static <T extends Throwable> Throwable peel(Throwable t, Class<T> allowedType, String message) {
        return ExceptionUtil.peel(t, allowedType, message, HAZELCAST_EXCEPTION_WRAPPER);
    }

    public static <T, W extends Throwable> Throwable peel(Throwable t, Class<T> allowedType, String message, BiFunction<Throwable, String, W> exceptionWrapper) {
        if (t instanceof RuntimeException) {
            return t;
        }
        if (t instanceof ExecutionException || t instanceof InvocationTargetException) {
            Throwable cause = t.getCause();
            if (cause != null) {
                return ExceptionUtil.peel(cause, allowedType, message, exceptionWrapper);
            }
            return (Throwable)exceptionWrapper.apply(t, message);
        }
        if (allowedType != null && allowedType.isAssignableFrom(t.getClass())) {
            return t;
        }
        return (Throwable)exceptionWrapper.apply(t, message);
    }

    public static RuntimeException rethrow(Throwable t) {
        ExceptionUtil.rethrowIfError(t);
        throw ExceptionUtil.peel(t);
    }

    public static RuntimeException rethrow(Throwable t, BiFunction<Throwable, String, RuntimeException> exceptionWrapper) {
        ExceptionUtil.rethrowIfError(t);
        throw (RuntimeException)ExceptionUtil.peel(t, null, null, exceptionWrapper);
    }

    public static <T extends Throwable> RuntimeException rethrow(Throwable t, Class<T> allowedType) throws T {
        ExceptionUtil.rethrowIfError(t);
        throw ExceptionUtil.peel(t, allowedType, null);
    }

    public static <T extends Throwable> RuntimeException rethrowAllowedTypeFirst(Throwable t, Class<T> allowedType) throws T {
        ExceptionUtil.rethrowIfError(t);
        if (allowedType.isAssignableFrom(t.getClass())) {
            throw t;
        }
        throw ExceptionUtil.peel(t);
    }

    public static void rethrowIfError(Throwable t) {
        if (t instanceof Error) {
            if (t instanceof OutOfMemoryError) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)t);
            }
            throw (Error)t;
        }
    }

    public static RuntimeException rethrowAllowInterrupted(Throwable t) throws InterruptedException {
        return ExceptionUtil.rethrow(t, InterruptedException.class);
    }

    @Nonnull
    public static <T extends Throwable> RuntimeException sneakyThrow(@Nonnull Throwable t) throws T {
        throw t;
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return ExceptionUtil.withTryCatch(logger, "Exception during callback", consumer);
    }

    @Nonnull
    public static <T> BiConsumer<T, ? super Throwable> withTryCatch(@Nonnull ILogger logger, @Nonnull String message, @Nonnull BiConsumer<T, ? super Throwable> consumer) {
        return (r, t) -> {
            try {
                consumer.accept((Object)r, (Throwable)t);
            }
            catch (Throwable e) {
                logger.severe(message, e);
            }
        };
    }

    public static <T extends Throwable> T tryCreateExceptionWithMessageAndCause(Class<? extends Throwable> exceptionClass, String message, @Nullable Throwable cause) {
        T cloned;
        int i = 0;
        while ((cloned = ExceptionUtil.cloneException(exceptionClass, message, cause, ConstructorMethod.METHODS[i])) == null && ++i < ConstructorMethod.METHODS.length) {
        }
        return cloned;
    }

    private static <T extends Throwable> T cloneException(Class<? extends Throwable> exceptionClass, String message, @Nullable Throwable cause, ConstructorMethod constructorMethod) {
        try {
            MethodHandle constructor = MethodHandles.publicLookup().findConstructor(exceptionClass, constructorMethod.signature());
            return constructorMethod.cloneWith(constructor, message, cause);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchMethodException | SecurityException | WrongMethodTypeException constructor) {
        }
        catch (Throwable t) {
            throw new RuntimeException("Exception creation failed ", t);
        }
        return null;
    }

    public static <T extends Throwable> T cloneExceptionWithFixedAsyncStackTrace(T original) {
        StackTraceElement[] fixedStackTrace = ExceptionUtil.getFixedStackTrace(original, Thread.currentThread().getStackTrace());
        Class<?> exceptionClass = original.getClass();
        T clone = ExceptionUtil.tryCreateExceptionWithMessageAndCause(exceptionClass, original.getMessage(), original.getCause());
        if (clone != null) {
            ((Throwable)clone).setStackTrace(fixedStackTrace);
            return clone;
        }
        return null;
    }

    private static StackTraceElement[] getFixedStackTrace(Throwable throwable, StackTraceElement[] localSideStackTrace) {
        StackTraceElement[] remoteStackTrace = throwable.getStackTrace();
        StackTraceElement[] newStackTrace = new StackTraceElement[localSideStackTrace.length + remoteStackTrace.length];
        System.arraycopy(remoteStackTrace, 0, newStackTrace, 0, remoteStackTrace.length);
        newStackTrace[remoteStackTrace.length] = new StackTraceElement(EXCEPTION_SEPARATOR, "", "", -1);
        System.arraycopy(localSideStackTrace, 1, newStackTrace, remoteStackTrace.length + 1, localSideStackTrace.length - 1);
        return newStackTrace;
    }

    private static enum ConstructorMethod {
        MT_INIT_STRING_THROWABLE{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE, String.class, Throwable.class);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(message, cause));
            }
        }
        ,
        MT_INIT_THROWABLE{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE, Throwable.class);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                return (T)((Throwable)constructor.invokeWithArguments(cause));
            }
        }
        ,
        MT_INIT_STRING{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE, String.class);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                Throwable cloned = (Throwable)constructor.invokeWithArguments(message);
                cloned.initCause(cause);
                return (T)cloned;
            }
        }
        ,
        MT_INIT{

            @Override
            MethodType signature() {
                return MethodType.methodType(Void.TYPE);
            }

            @Override
            <T extends Throwable> T cloneWith(MethodHandle constructor, String message, @Nullable Throwable cause) throws Throwable {
                Throwable cloned = (Throwable)constructor.invokeWithArguments(new Object[0]);
                cloned.initCause(cause);
                return (T)cloned;
            }
        };

        private static final ConstructorMethod[] METHODS;

        abstract MethodType signature();

        abstract <T extends Throwable> T cloneWith(MethodHandle var1, String var2, @Nullable Throwable var3) throws Throwable;

        static {
            METHODS = ConstructorMethod.values();
        }
    }
}

