/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.transform.sql.zeta;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonErrorCodeDeprecated;
import org.apache.seatunnel.common.exception.SeaTunnelErrorCode;
import org.apache.seatunnel.transform.exception.TransformException;
import org.apache.seatunnel.transform.sql.SQLEngine;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLFilter;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLFunction;
import org.apache.seatunnel.transform.sql.zeta.ZetaSQLType;
import org.apache.seatunnel.transform.sql.zeta.ZetaUDF;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZetaSQLEngine
implements SQLEngine {
    private static final Logger log = LoggerFactory.getLogger(ZetaSQLEngine.class);
    private String inputTableName;
    @Nullable
    private String catalogTableName;
    private SeaTunnelRowType inputRowType;
    private String sql;
    private PlainSelect selectBody;
    private ZetaSQLFunction zetaSQLFunction;
    private ZetaSQLFilter zetaSQLFilter;
    private ZetaSQLType zetaSQLType;
    private Integer allColumnsCount = null;

    @Override
    public void init(String inputTableName, String catalogTableName, SeaTunnelRowType inputRowType, String sql) {
        this.inputTableName = inputTableName;
        this.catalogTableName = catalogTableName;
        this.inputRowType = inputRowType;
        this.sql = sql;
        ArrayList<ZetaUDF> udfList = new ArrayList<ZetaUDF>();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ServiceLoader.load(ZetaUDF.class, classLoader).forEach(udfList::add);
        this.zetaSQLType = new ZetaSQLType(inputRowType, udfList);
        this.zetaSQLFunction = new ZetaSQLFunction(inputRowType, this.zetaSQLType, udfList);
        this.zetaSQLFilter = new ZetaSQLFilter(this.zetaSQLFunction, this.zetaSQLType);
        this.parseSQL();
    }

    private void parseSQL() {
        try {
            Statement statement = CCJSqlParserUtil.parse(this.sql);
            this.validateSQL(statement);
            this.selectBody = (PlainSelect)((Select)statement).getSelectBody();
        }
        catch (JSQLParserException e) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("SQL parse failed: %s, cause: %s", this.sql, e.getMessage()));
        }
    }

    private void validateSQL(Statement statement) {
        try {
            if (!(statement instanceof Select)) {
                throw new IllegalArgumentException("Only supported DQL(select) SQL");
            }
            Select select = (Select)statement;
            if (!(select.getSelectBody() instanceof PlainSelect)) {
                throw new IllegalArgumentException("Unsupported SQL syntax");
            }
            PlainSelect selectBody = (PlainSelect)select.getSelectBody();
            FromItem fromItem = selectBody.getFromItem();
            if (fromItem instanceof Table) {
                Table table = (Table)fromItem;
                if (table.getSchemaName() != null) {
                    throw new IllegalArgumentException("Unsupported schema syntax");
                }
                if (table.getAlias() != null) {
                    throw new IllegalArgumentException("Unsupported table alias name syntax");
                }
                String tableName = table.getName();
                if (!this.inputTableName.equalsIgnoreCase(tableName) && !tableName.equalsIgnoreCase(this.catalogTableName)) {
                    log.warn("SQL table name {} is not equal to input table name {} or catalog table name {}", new Object[]{tableName, this.inputTableName, this.catalogTableName});
                }
            } else {
                throw new IllegalArgumentException("Unsupported sub table syntax");
            }
            if (selectBody.getJoins() != null) {
                throw new IllegalArgumentException("Unsupported table join syntax");
            }
            if (selectBody.getOrderByElements() != null) {
                throw new IllegalArgumentException("Unsupported ORDER BY syntax");
            }
            if (selectBody.getGroupBy() != null) {
                throw new IllegalArgumentException("Unsupported GROUP BY syntax");
            }
            if (selectBody.getLimit() != null || selectBody.getOffset() != null) {
                throw new IllegalArgumentException("Unsupported LIMIT,OFFSET syntax");
            }
        }
        catch (Exception e) {
            throw new TransformException((SeaTunnelErrorCode)CommonErrorCodeDeprecated.UNSUPPORTED_OPERATION, String.format("SQL validate failed: %s, cause: %s", this.sql, e.getMessage()));
        }
    }

    @Override
    public SeaTunnelRowType typeMapping(List<String> inputColumnsMapping) {
        List<SelectItem> selectItems = this.selectBody.getSelectItems();
        int columnsSize = this.countColumnsSize(selectItems);
        String[] fieldNames = new String[columnsSize];
        SeaTunnelDataType[] seaTunnelDataTypes = new SeaTunnelDataType[columnsSize];
        if (inputColumnsMapping != null) {
            for (int i = 0; i < columnsSize; ++i) {
                inputColumnsMapping.add(null);
            }
        }
        List inputColumnNames = Arrays.stream(this.inputRowType.getFieldNames()).collect(Collectors.toList());
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            if (selectItem instanceof AllColumns) {
                for (int i = 0; i < this.inputRowType.getFieldNames().length; ++i) {
                    fieldNames[idx] = this.inputRowType.getFieldName(i);
                    seaTunnelDataTypes[idx] = this.inputRowType.getFieldType(i);
                    if (inputColumnsMapping != null) {
                        inputColumnsMapping.set(idx, this.inputRowType.getFieldName(i));
                    }
                    ++idx;
                }
                continue;
            }
            if (selectItem instanceof SelectExpressionItem) {
                SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
                Expression expression = expressionItem.getExpression();
                fieldNames[idx] = expressionItem.getAlias() != null ? expressionItem.getAlias().getName() : (expression instanceof Column ? ((Column)expression).getColumnName() : expression.toString());
                if (inputColumnsMapping != null && expression instanceof Column && inputColumnNames.contains(((Column)expression).getColumnName())) {
                    inputColumnsMapping.set(idx, ((Column)expression).getColumnName());
                }
                seaTunnelDataTypes[idx] = this.zetaSQLType.getExpressionType(expression);
                ++idx;
                continue;
            }
            ++idx;
        }
        return new SeaTunnelRowType(fieldNames, seaTunnelDataTypes);
    }

    @Override
    public SeaTunnelRow transformBySQL(SeaTunnelRow inputRow) {
        Object[] inputFields = this.scanTable(inputRow);
        boolean retain = this.zetaSQLFilter.executeFilter(this.selectBody.getWhere(), inputFields);
        if (!retain) {
            return null;
        }
        Object[] outputFields = this.project(inputFields);
        SeaTunnelRow seaTunnelRow = new SeaTunnelRow(outputFields);
        seaTunnelRow.setRowKind(inputRow.getRowKind());
        seaTunnelRow.setTableId(inputRow.getTableId());
        return seaTunnelRow;
    }

    private Object[] scanTable(SeaTunnelRow inputRow) {
        return inputRow.getFields();
    }

    private Object[] project(Object[] inputFields) {
        List<SelectItem> selectItems = this.selectBody.getSelectItems();
        int columnsSize = this.countColumnsSize(selectItems);
        Object[] fields = new Object[columnsSize];
        int idx = 0;
        for (SelectItem selectItem : selectItems) {
            if (selectItem instanceof AllColumns) {
                Object[] objectArray = inputFields;
                int n = objectArray.length;
                for (int i = 0; i < n; ++i) {
                    Object inputField;
                    fields[idx] = inputField = objectArray[i];
                    ++idx;
                }
                continue;
            }
            if (selectItem instanceof SelectExpressionItem) {
                SelectExpressionItem expressionItem = (SelectExpressionItem)selectItem;
                Expression expression = expressionItem.getExpression();
                fields[idx] = this.zetaSQLFunction.computeForValue(expression, inputFields);
                ++idx;
                continue;
            }
            ++idx;
        }
        return fields;
    }

    private int countColumnsSize(List<SelectItem> selectItems) {
        if (this.allColumnsCount != null) {
            return this.allColumnsCount;
        }
        int allColumnsCnt = 0;
        for (SelectItem selectItem : selectItems) {
            if (!(selectItem instanceof AllColumns)) continue;
            ++allColumnsCnt;
        }
        this.allColumnsCount = selectItems.size() + this.inputRowType.getFieldNames().length * allColumnsCnt - allColumnsCnt;
        return this.allColumnsCount;
    }
}

