/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.format.json.debezium;

import java.io.IOException;
import org.apache.seatunnel.api.serialization.DeserializationSchema;
import org.apache.seatunnel.api.source.Collector;
import org.apache.seatunnel.api.table.type.RowKind;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;
import org.apache.seatunnel.common.exception.CommonError;
import org.apache.seatunnel.format.json.JsonDeserializationSchema;
import org.apache.seatunnel.format.json.debezium.DebeziumRowConverter;
import org.apache.seatunnel.shade.com.fasterxml.jackson.databind.JsonNode;

public class DebeziumJsonDeserializationSchema
implements DeserializationSchema<SeaTunnelRow> {
    private static final long serialVersionUID = 1L;
    private static final String OP_READ = "r";
    private static final String OP_CREATE = "c";
    private static final String OP_UPDATE = "u";
    private static final String OP_DELETE = "d";
    private static final String REPLICA_IDENTITY_EXCEPTION = "The \"before\" field of %s operation is null, if you are using Debezium Postgres Connector, please check the Postgres table has been set REPLICA IDENTITY to FULL level.";
    public static final String FORMAT = "Debezium";
    private final SeaTunnelRowType rowType;
    private final JsonDeserializationSchema jsonDeserializer;
    private final DebeziumRowConverter debeziumRowConverter;
    private final boolean ignoreParseErrors;
    private final boolean debeziumEnabledSchema;

    public DebeziumJsonDeserializationSchema(SeaTunnelRowType rowType, boolean ignoreParseErrors) {
        this.rowType = rowType;
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonDeserializationSchema(false, ignoreParseErrors, DebeziumJsonDeserializationSchema.createJsonRowType(rowType));
        this.debeziumRowConverter = new DebeziumRowConverter(rowType);
        this.debeziumEnabledSchema = false;
    }

    public DebeziumJsonDeserializationSchema(SeaTunnelRowType rowType, boolean ignoreParseErrors, boolean debeziumEnabledSchema) {
        this.rowType = rowType;
        this.ignoreParseErrors = ignoreParseErrors;
        this.jsonDeserializer = new JsonDeserializationSchema(false, ignoreParseErrors, DebeziumJsonDeserializationSchema.createJsonRowType(rowType));
        this.debeziumRowConverter = new DebeziumRowConverter(rowType);
        this.debeziumEnabledSchema = debeziumEnabledSchema;
    }

    public SeaTunnelRow deserialize(byte[] message) throws IOException {
        throw new UnsupportedOperationException("Please invoke DeserializationSchema#deserialize(byte[], Collector<SeaTunnelRow>) instead.");
    }

    public void deserialize(byte[] message, Collector<SeaTunnelRow> out) throws IOException {
        block8: {
            if (message == null || message.length == 0) {
                return;
            }
            try {
                JsonNode payload = this.getPayload(this.convertBytes(message));
                String op = payload.get("op").asText();
                if (OP_CREATE.equals(op) || OP_READ.equals(op)) {
                    SeaTunnelRow insert = this.convertJsonNode(payload.get("after"));
                    insert.setRowKind(RowKind.INSERT);
                    out.collect((Object)insert);
                    break block8;
                }
                if (OP_UPDATE.equals(op)) {
                    SeaTunnelRow before = this.convertJsonNode(payload.get("before"));
                    if (before == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    before.setRowKind(RowKind.UPDATE_BEFORE);
                    out.collect((Object)before);
                    SeaTunnelRow after = this.convertJsonNode(payload.get("after"));
                    after.setRowKind(RowKind.UPDATE_AFTER);
                    out.collect((Object)after);
                    break block8;
                }
                if (OP_DELETE.equals(op)) {
                    SeaTunnelRow delete = this.convertJsonNode(payload.get("before"));
                    if (delete == null) {
                        throw new IllegalStateException(String.format(REPLICA_IDENTITY_EXCEPTION, "UPDATE"));
                    }
                    delete.setRowKind(RowKind.DELETE);
                    out.collect((Object)delete);
                    break block8;
                }
                throw new IllegalStateException(String.format("Unknown operation type '%s'.", op));
            }
            catch (RuntimeException e) {
                if (this.ignoreParseErrors) break block8;
                throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)e);
            }
        }
    }

    private JsonNode getPayload(JsonNode jsonNode) {
        if (this.debeziumEnabledSchema) {
            return jsonNode.get("payload");
        }
        return jsonNode;
    }

    private JsonNode convertBytes(byte[] message) {
        try {
            return this.jsonDeserializer.deserializeToJsonNode(message);
        }
        catch (IOException t) {
            throw CommonError.jsonOperationError((String)FORMAT, (String)new String(message), (Throwable)t);
        }
    }

    private SeaTunnelRow convertJsonNode(JsonNode root) {
        return this.debeziumRowConverter.serializeValue(root);
    }

    public SeaTunnelDataType<SeaTunnelRow> getProducedType() {
        return this.rowType;
    }

    private static SeaTunnelRowType createJsonRowType(SeaTunnelRowType databaseSchema) {
        return databaseSchema;
    }
}

