/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.yarn.client.api.impl;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.ipc.RPC;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.hadoop.yarn.api.ApplicationMasterProtocol;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateRequest;
import org.apache.hadoop.yarn.api.protocolrecords.AllocateResponse;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.FinishApplicationMasterResponse;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterRequest;
import org.apache.hadoop.yarn.api.protocolrecords.RegisterApplicationMasterResponse;
import org.apache.hadoop.yarn.api.records.Container;
import org.apache.hadoop.yarn.api.records.ContainerId;
import org.apache.hadoop.yarn.api.records.ContainerStatus;
import org.apache.hadoop.yarn.api.records.ContainerUpdateType;
import org.apache.hadoop.yarn.api.records.ExecutionType;
import org.apache.hadoop.yarn.api.records.ExecutionTypeRequest;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.NMToken;
import org.apache.hadoop.yarn.api.records.Priority;
import org.apache.hadoop.yarn.api.records.Resource;
import org.apache.hadoop.yarn.api.records.ResourceBlacklistRequest;
import org.apache.hadoop.yarn.api.records.ResourceInformation;
import org.apache.hadoop.yarn.api.records.ResourceRequest;
import org.apache.hadoop.yarn.api.records.SchedulingRequest;
import org.apache.hadoop.yarn.api.records.UpdateContainerRequest;
import org.apache.hadoop.yarn.api.records.UpdatedContainer;
import org.apache.hadoop.yarn.api.resource.PlacementConstraint;
import org.apache.hadoop.yarn.client.ClientRMProxy;
import org.apache.hadoop.yarn.client.api.AMRMClient;
import org.apache.hadoop.yarn.client.api.InvalidContainerRequestException;
import org.apache.hadoop.yarn.client.api.impl.RemoteRequestsTable;
import org.apache.hadoop.yarn.conf.YarnConfiguration;
import org.apache.hadoop.yarn.exceptions.ApplicationMasterNotRegisteredException;
import org.apache.hadoop.yarn.exceptions.YarnException;
import org.apache.hadoop.yarn.exceptions.YarnRuntimeException;
import org.apache.hadoop.yarn.util.RackResolver;
import org.apache.hadoop.yarn.util.resource.Resources;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Joiner;
import org.apache.seatunnel.shade.hadoop.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public class AMRMClientImpl<T extends AMRMClient.ContainerRequest>
extends AMRMClient<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AMRMClientImpl.class);
    private static final List<String> ANY_LIST = Collections.singletonList("*");
    private int lastResponseId = 0;
    protected String appHostName;
    protected int appHostPort;
    protected String appTrackingUrl;
    protected String newTrackingUrl;
    protected ApplicationMasterProtocol rmClient;
    protected Resource clusterAvailableResources;
    protected int clusterNodeCount;
    protected final Set<String> blacklistedNodes = new HashSet<String>();
    protected final Set<String> blacklistAdditions = new HashSet<String>();
    protected final Set<String> blacklistRemovals = new HashSet<String>();
    private Map<Set<String>, PlacementConstraint> placementConstraints = new HashMap<Set<String>, PlacementConstraint>();
    private Queue<Collection<SchedulingRequest>> batchedSchedulingRequests = new LinkedList<Collection<SchedulingRequest>>();
    private Map<Set<String>, List<SchedulingRequest>> outstandingSchedRequests = new ConcurrentHashMap<Set<String>, List<SchedulingRequest>>();
    protected Map<String, Resource> resourceProfilesMap;
    private final Map<Long, RemoteRequestsTable<T>> remoteRequests = new HashMap<Long, RemoteRequestsTable<T>>();
    protected final Set<ResourceRequest> ask = new TreeSet<ResourceRequest>(new ResourceRequest.ResourceRequestComparator());
    protected final Set<ContainerId> release = new TreeSet<ContainerId>();
    protected Set<ContainerId> pendingRelease = new TreeSet<ContainerId>();
    protected final Map<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>> change = new HashMap<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>>();
    protected final Map<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>> pendingChange = new HashMap<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>>();

    public AMRMClientImpl() {
        super(AMRMClientImpl.class.getName());
    }

    @VisibleForTesting
    AMRMClientImpl(ApplicationMasterProtocol protocol) {
        super(AMRMClientImpl.class.getName());
        this.rmClient = protocol;
    }

    @Override
    protected void serviceInit(Configuration conf) throws Exception {
        RackResolver.init(conf);
        super.serviceInit(conf);
    }

    @Override
    protected void serviceStart() throws Exception {
        YarnConfiguration conf = new YarnConfiguration(this.getConfig());
        try {
            if (this.rmClient == null) {
                this.rmClient = ClientRMProxy.createRMProxy(conf, ApplicationMasterProtocol.class);
            }
        }
        catch (IOException e) {
            throw new YarnRuntimeException(e);
        }
        super.serviceStart();
    }

    @Override
    protected void serviceStop() throws Exception {
        if (this.rmClient != null) {
            RPC.stopProxy(this.rmClient);
        }
        super.serviceStop();
    }

    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl) throws YarnException, IOException {
        return this.registerApplicationMaster(appHostName, appHostPort, appTrackingUrl, null);
    }

    @Override
    public RegisterApplicationMasterResponse registerApplicationMaster(String appHostName, int appHostPort, String appTrackingUrl, Map<Set<String>, PlacementConstraint> placementConstraintsMap) throws YarnException, IOException {
        this.appHostName = appHostName;
        this.appHostPort = appHostPort;
        this.appTrackingUrl = appTrackingUrl;
        if (placementConstraintsMap != null && !placementConstraintsMap.isEmpty()) {
            this.placementConstraints.putAll(placementConstraintsMap);
        }
        Preconditions.checkArgument(appHostName != null, "The host name should not be null");
        Preconditions.checkArgument(appHostPort >= -1, "Port number of the host should be any integers larger than or equal to -1");
        return this.registerApplicationMaster();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RegisterApplicationMasterResponse registerApplicationMaster() throws YarnException, IOException {
        RegisterApplicationMasterRequest request = RegisterApplicationMasterRequest.newInstance(this.appHostName, this.appHostPort, this.appTrackingUrl);
        if (!this.placementConstraints.isEmpty()) {
            request.setPlacementConstraints(this.placementConstraints);
        }
        RegisterApplicationMasterResponse response = this.rmClient.registerApplicationMaster(request);
        AMRMClientImpl aMRMClientImpl = this;
        synchronized (aMRMClientImpl) {
            this.lastResponseId = 0;
            if (!response.getNMTokensFromPreviousAttempts().isEmpty()) {
                this.populateNMTokens(response.getNMTokensFromPreviousAttempts());
            }
            this.resourceProfilesMap = response.getResourceProfiles();
            List<Container> prevContainers = response.getContainersFromPreviousAttempts();
            this.removeFromOutstandingSchedulingRequests(prevContainers);
            this.recreateSchedulingRequestBatch();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addSchedulingRequests(Collection<SchedulingRequest> schedulingRequests) {
        Queue<Collection<SchedulingRequest>> queue = this.batchedSchedulingRequests;
        synchronized (queue) {
            this.batchedSchedulingRequests.add(schedulingRequests);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AllocateResponse allocate(float progressIndicator) throws YarnException, IOException {
        Preconditions.checkArgument(progressIndicator >= 0.0f, "Progress indicator should not be negative");
        AllocateResponse allocateResponse = null;
        List<ResourceRequest> askList = null;
        ArrayList<ContainerId> releaseList = null;
        AllocateRequest allocateRequest = null;
        ArrayList<String> blacklistToAdd = new ArrayList<String>();
        ArrayList<String> blacklistToRemove = new ArrayList<String>();
        HashMap<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>> oldChange = new HashMap<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>>();
        try {
            Object blacklistRequest;
            Object updateList;
            AMRMClientImpl aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                askList = this.cloneAsks();
                oldChange.putAll(this.change);
                updateList = this.createUpdateList();
                releaseList = new ArrayList<ContainerId>(this.release);
                this.ask.clear();
                this.release.clear();
                this.change.clear();
                blacklistToAdd.addAll(this.blacklistAdditions);
                blacklistToRemove.addAll(this.blacklistRemovals);
                blacklistRequest = ResourceBlacklistRequest.newInstance(blacklistToAdd, blacklistToRemove);
                allocateRequest = AllocateRequest.newBuilder().responseId(this.lastResponseId).progress(progressIndicator).askList(askList).resourceBlacklistRequest((ResourceBlacklistRequest)blacklistRequest).releaseList(releaseList).updateRequests((List<UpdateContainerRequest>)updateList).build();
                this.populateSchedulingRequests(allocateRequest);
                if (this.newTrackingUrl != null) {
                    allocateRequest.setTrackingUrl(this.newTrackingUrl);
                    this.appTrackingUrl = this.newTrackingUrl;
                    this.newTrackingUrl = null;
                }
                this.blacklistAdditions.clear();
                this.blacklistRemovals.clear();
            }
            try {
                allocateResponse = this.rmClient.allocate(allocateRequest);
                this.removeFromOutstandingSchedulingRequests(allocateResponse.getAllocatedContainers());
                this.removeFromOutstandingSchedulingRequests(allocateResponse.getContainersFromPreviousAttempts());
            }
            catch (ApplicationMasterNotRegisteredException e) {
                LOG.warn("ApplicationMaster is out of sync with ResourceManager, hence resyncing.");
                updateList = this;
                synchronized (updateList) {
                    this.release.addAll(this.pendingRelease);
                    this.blacklistAdditions.addAll(this.blacklistedNodes);
                    for (RemoteRequestsTable remoteRequestsTable : this.remoteRequests.values()) {
                        Iterator<ResourceRequestInfo> reqIter = remoteRequestsTable.iterator();
                        while (reqIter.hasNext()) {
                            this.addResourceRequestToAsk(reqIter.next().remoteRequest);
                        }
                    }
                    this.change.putAll(this.pendingChange);
                }
                this.registerApplicationMaster();
                allocateResponse = this.allocate(progressIndicator);
                updateList = allocateResponse;
                if (allocateResponse == null) {
                    blacklistRequest = this;
                    synchronized (blacklistRequest) {
                        this.release.addAll(releaseList);
                        for (ResourceRequest oldAsk : askList) {
                            if (this.ask.contains(oldAsk)) continue;
                            this.ask.add(oldAsk);
                        }
                        for (Map.Entry entry : oldChange.entrySet()) {
                            ContainerId oldContainerId = (ContainerId)entry.getKey();
                            Container oldContainer = (Container)((AbstractMap.SimpleEntry)entry.getValue()).getKey();
                            UpdateContainerRequest oldupdate = (UpdateContainerRequest)((AbstractMap.SimpleEntry)entry.getValue()).getValue();
                            if (this.change.get(oldContainerId) != null) continue;
                            this.change.put(oldContainerId, new AbstractMap.SimpleEntry<Container, UpdateContainerRequest>(oldContainer, oldupdate));
                        }
                        this.blacklistAdditions.addAll(blacklistToAdd);
                        this.blacklistRemovals.addAll(blacklistToRemove);
                    }
                }
                return updateList;
            }
            aMRMClientImpl = this;
            synchronized (aMRMClientImpl) {
                this.clusterNodeCount = allocateResponse.getNumClusterNodes();
                this.lastResponseId = allocateResponse.getResponseId();
                this.clusterAvailableResources = allocateResponse.getAvailableResources();
                if (!allocateResponse.getNMTokens().isEmpty()) {
                    this.populateNMTokens(allocateResponse.getNMTokens());
                }
                if (allocateResponse.getAMRMToken() != null) {
                    this.updateAMRMToken(allocateResponse.getAMRMToken());
                }
                if (!this.pendingRelease.isEmpty() && !allocateResponse.getCompletedContainersStatuses().isEmpty()) {
                    this.removePendingReleaseRequests(allocateResponse.getCompletedContainersStatuses());
                }
                if (!this.pendingChange.isEmpty()) {
                    List<ContainerStatus> completed = allocateResponse.getCompletedContainersStatuses();
                    ArrayList<UpdatedContainer> changed = new ArrayList<UpdatedContainer>();
                    changed.addAll(allocateResponse.getUpdatedContainers());
                    for (ContainerStatus status : completed) {
                        ContainerId containerId = status.getContainerId();
                        this.pendingChange.remove(containerId);
                    }
                    if (!changed.isEmpty()) {
                        this.removePendingChangeRequests(changed);
                    }
                }
            }
        }
        finally {
            if (allocateResponse == null) {
                AMRMClientImpl aMRMClientImpl = this;
                synchronized (aMRMClientImpl) {
                    this.release.addAll(releaseList);
                    for (ResourceRequest resourceRequest : askList) {
                        if (this.ask.contains(resourceRequest)) continue;
                        this.ask.add(resourceRequest);
                    }
                    for (Map.Entry entry : oldChange.entrySet()) {
                        ContainerId oldContainerId = (ContainerId)entry.getKey();
                        Container oldContainer = (Container)((AbstractMap.SimpleEntry)entry.getValue()).getKey();
                        UpdateContainerRequest oldupdate = (UpdateContainerRequest)((AbstractMap.SimpleEntry)entry.getValue()).getValue();
                        if (this.change.get(oldContainerId) != null) continue;
                        this.change.put(oldContainerId, new AbstractMap.SimpleEntry<Container, UpdateContainerRequest>(oldContainer, oldupdate));
                    }
                    this.blacklistAdditions.addAll(blacklistToAdd);
                    this.blacklistRemovals.addAll(blacklistToRemove);
                }
            }
        }
        return allocateResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void populateSchedulingRequests(AllocateRequest allocateRequest) {
        Queue<Collection<SchedulingRequest>> queue = this.batchedSchedulingRequests;
        synchronized (queue) {
            if (!this.batchedSchedulingRequests.isEmpty()) {
                LinkedList<SchedulingRequest> newReqs = new LinkedList<SchedulingRequest>();
                Iterator iter = this.batchedSchedulingRequests.iterator();
                while (iter.hasNext()) {
                    Collection requests = (Collection)iter.next();
                    newReqs.addAll(requests);
                    this.addToOutstandingSchedulingRequests(requests);
                    iter.remove();
                }
                allocateRequest.setSchedulingRequests(newReqs);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recreateSchedulingRequestBatch() {
        ArrayList<SchedulingRequest> batched = new ArrayList<SchedulingRequest>();
        Object object = this.outstandingSchedRequests;
        synchronized (object) {
            for (List<SchedulingRequest> schedReqs : this.outstandingSchedRequests.values()) {
                batched.addAll(schedReqs);
            }
        }
        object = this.batchedSchedulingRequests;
        synchronized (object) {
            this.batchedSchedulingRequests.add(batched);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToOutstandingSchedulingRequests(Collection<SchedulingRequest> requests) {
        for (SchedulingRequest req : requests) {
            List schedulingRequests = this.outstandingSchedRequests.computeIfAbsent(req.getAllocationTags(), x -> new LinkedList());
            SchedulingRequest matchingReq = null;
            List list = schedulingRequests;
            synchronized (list) {
                for (SchedulingRequest schedReq : schedulingRequests) {
                    if (!this.isMatching(req, schedReq)) continue;
                    matchingReq = schedReq;
                    break;
                }
                if (matchingReq != null) {
                    matchingReq.getResourceSizing().setNumAllocations(req.getResourceSizing().getNumAllocations());
                } else {
                    schedulingRequests.add(req);
                }
            }
        }
    }

    private boolean isMatching(SchedulingRequest schedReq1, SchedulingRequest schedReq2) {
        return schedReq1.getPriority().equals(schedReq2.getPriority()) && schedReq1.getExecutionType().getExecutionType().equals((Object)schedReq1.getExecutionType().getExecutionType()) && schedReq1.getAllocationRequestId() == schedReq2.getAllocationRequestId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFromOutstandingSchedulingRequests(Collection<Container> containers) {
        if (containers == null || containers.isEmpty()) {
            return;
        }
        for (Container container : containers) {
            List<SchedulingRequest> schedReqs;
            if (container.getAllocationTags() == null || container.getAllocationTags().isEmpty() || (schedReqs = this.outstandingSchedRequests.get(container.getAllocationTags())) == null || schedReqs.isEmpty()) continue;
            List<SchedulingRequest> list = schedReqs;
            synchronized (list) {
                Iterator<SchedulingRequest> iter = schedReqs.iterator();
                while (iter.hasNext()) {
                    SchedulingRequest schedReq = iter.next();
                    if (!schedReq.getPriority().equals(container.getPriority()) || schedReq.getAllocationRequestId() != container.getAllocationRequestId()) continue;
                    int numAllocations = schedReq.getResourceSizing().getNumAllocations();
                    if (--numAllocations == 0) {
                        iter.remove();
                        continue;
                    }
                    schedReq.getResourceSizing().setNumAllocations(numAllocations);
                }
            }
        }
    }

    private List<UpdateContainerRequest> createUpdateList() {
        ArrayList<UpdateContainerRequest> updateList = new ArrayList<UpdateContainerRequest>();
        for (Map.Entry<ContainerId, AbstractMap.SimpleEntry<Container, UpdateContainerRequest>> entry : this.change.entrySet()) {
            Resource targetCapability = entry.getValue().getValue().getCapability();
            ExecutionType targetExecType = entry.getValue().getValue().getExecutionType();
            ContainerUpdateType updateType = entry.getValue().getValue().getContainerUpdateType();
            int version = entry.getValue().getKey().getVersion();
            updateList.add(UpdateContainerRequest.newInstance(version, entry.getKey(), updateType, targetCapability, targetExecType));
        }
        return updateList;
    }

    private List<ResourceRequest> cloneAsks() {
        ArrayList<ResourceRequest> askList = new ArrayList<ResourceRequest>(this.ask.size());
        for (ResourceRequest r : this.ask) {
            ResourceRequest rr = ResourceRequest.newBuilder().priority(r.getPriority()).resourceName(r.getResourceName()).capability(r.getCapability()).numContainers(r.getNumContainers()).relaxLocality(r.getRelaxLocality()).nodeLabelExpression(r.getNodeLabelExpression()).executionTypeRequest(r.getExecutionTypeRequest()).allocationRequestId(r.getAllocationRequestId()).build();
            askList.add(rr);
        }
        return askList;
    }

    protected void removePendingReleaseRequests(List<ContainerStatus> completedContainersStatuses) {
        for (ContainerStatus containerStatus : completedContainersStatuses) {
            this.pendingRelease.remove(containerStatus.getContainerId());
        }
    }

    protected void removePendingChangeRequests(List<UpdatedContainer> changedContainers) {
        for (UpdatedContainer changedContainer : changedContainers) {
            ContainerId containerId = changedContainer.getContainer().getId();
            if (this.pendingChange.get(containerId) == null) continue;
            if (LOG.isDebugEnabled()) {
                LOG.debug("RM has confirmed changed resource allocation for container " + containerId + ". Current resource allocation:" + changedContainer.getContainer().getResource() + ". Remove pending change request:" + this.pendingChange.get(containerId).getValue());
            }
            this.pendingChange.remove(containerId);
        }
    }

    @InterfaceAudience.Private
    @VisibleForTesting
    protected void populateNMTokens(List<NMToken> nmTokens) {
        for (NMToken token : nmTokens) {
            String nodeId = token.getNodeId().toString();
            if (LOG.isDebugEnabled()) {
                if (this.getNMTokenCache().containsToken(nodeId)) {
                    LOG.debug("Replacing token for : " + nodeId);
                } else {
                    LOG.debug("Received new token for : " + nodeId);
                }
            }
            this.getNMTokenCache().setToken(nodeId, token.getToken());
        }
    }

    @Override
    public void unregisterApplicationMaster(FinalApplicationStatus appStatus, String appMessage, String appTrackingUrl) throws YarnException, IOException {
        Preconditions.checkArgument(appStatus != null, "AppStatus should not be null.");
        FinishApplicationMasterRequest request = FinishApplicationMasterRequest.newInstance(appStatus, appMessage, appTrackingUrl);
        try {
            FinishApplicationMasterResponse response;
            while (!(response = this.rmClient.finishApplicationMaster(request)).getIsUnregistered()) {
                LOG.info("Waiting for application to be successfully unregistered.");
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException e) {
            LOG.info("Interrupted while waiting for application to be removed from RMStateStore");
        }
        catch (ApplicationMasterNotRegisteredException e) {
            LOG.warn("ApplicationMaster is out of sync with ResourceManager, hence resyncing.");
            this.registerApplicationMaster();
            this.unregisterApplicationMaster(appStatus, appMessage, appTrackingUrl);
        }
    }

    @Override
    public synchronized void addContainerRequest(T req) {
        Preconditions.checkArgument(req != null, "Resource request can not be null.");
        HashSet<String> dedupedRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            dedupedRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
            if (((AMRMClient.ContainerRequest)req).getRacks().size() != dedupedRacks.size()) {
                Joiner joiner = Joiner.on(',');
                LOG.warn("ContainerRequest has duplicate racks: " + joiner.join(((AMRMClient.ContainerRequest)req).getRacks()));
            }
        }
        Set<String> inferredRacks = this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes());
        inferredRacks.removeAll(dedupedRacks);
        Resource resource = this.checkAndGetResourceProfile(((AMRMClient.ContainerRequest)req).getResourceProfile(), ((AMRMClient.ContainerRequest)req).getCapability());
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getAllocationRequestId(), ((AMRMClient.ContainerRequest)req).getPriority(), ANY_LIST, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getAllocationRequestId(), ((AMRMClient.ContainerRequest)req).getPriority(), dedupedRacks, true);
        this.checkLocalityRelaxationConflict(((AMRMClient.ContainerRequest)req).getAllocationRequestId(), ((AMRMClient.ContainerRequest)req).getPriority(), inferredRacks, ((AMRMClient.ContainerRequest)req).getRelaxLocality());
        this.checkNodeLabelExpression(req);
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            HashSet<String> dedupedNodes = new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes());
            if (dedupedNodes.size() != ((AMRMClient.ContainerRequest)req).getNodes().size()) {
                Joiner joiner = Joiner.on(',');
                LOG.warn("ContainerRequest has duplicate nodes: " + joiner.join(((AMRMClient.ContainerRequest)req).getNodes()));
            }
            for (String node : dedupedNodes) {
                this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req, true, ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
            }
        }
        for (String rack : dedupedRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req, true, ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
        }
        for (String rack : inferredRacks) {
            this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req, ((AMRMClient.ContainerRequest)req).getRelaxLocality(), ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
        }
        this.addResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req, ((AMRMClient.ContainerRequest)req).getRelaxLocality(), ((AMRMClient.ContainerRequest)req).getNodeLabelExpression());
    }

    @Override
    public synchronized void removeContainerRequest(T req) {
        Preconditions.checkArgument(req != null, "Resource request can not be null.");
        Resource resource = this.checkAndGetResourceProfile(((AMRMClient.ContainerRequest)req).getResourceProfile(), ((AMRMClient.ContainerRequest)req).getCapability());
        HashSet<String> allRacks = new HashSet<String>();
        if (((AMRMClient.ContainerRequest)req).getRacks() != null) {
            allRacks.addAll(((AMRMClient.ContainerRequest)req).getRacks());
        }
        allRacks.addAll(this.resolveRacks(((AMRMClient.ContainerRequest)req).getNodes()));
        if (((AMRMClient.ContainerRequest)req).getNodes() != null) {
            for (String node : new HashSet<String>(((AMRMClient.ContainerRequest)req).getNodes())) {
                this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), node, ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req);
            }
        }
        for (String rack : allRacks) {
            this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), rack, ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req);
        }
        this.decResourceRequest(((AMRMClient.ContainerRequest)req).getPriority(), "*", ((AMRMClient.ContainerRequest)req).getExecutionTypeRequest(), resource, req);
    }

    @Override
    public synchronized void requestContainerUpdate(Container container, UpdateContainerRequest updateContainerRequest) {
        Preconditions.checkNotNull(container, "Container cannot be null!!");
        Preconditions.checkNotNull(updateContainerRequest, "UpdateContainerRequest cannot be null!!");
        LOG.info("Requesting Container update : container=" + container + ", updateType=" + (Object)((Object)updateContainerRequest.getContainerUpdateType()) + ", targetCapability=" + updateContainerRequest.getCapability() + ", targetExecType=" + (Object)((Object)updateContainerRequest.getExecutionType()));
        if (updateContainerRequest.getCapability() != null && updateContainerRequest.getExecutionType() == null) {
            this.validateContainerResourceChangeRequest(updateContainerRequest.getContainerUpdateType(), container.getId(), container.getResource(), updateContainerRequest.getCapability());
        } else if (updateContainerRequest.getExecutionType() != null && updateContainerRequest.getCapability() == null) {
            this.validateContainerExecTypeChangeRequest(updateContainerRequest.getContainerUpdateType(), container.getId(), container.getExecutionType(), updateContainerRequest.getExecutionType());
        } else {
            if (updateContainerRequest.getExecutionType() == null && updateContainerRequest.getCapability() == null) {
                throw new IllegalArgumentException("Both target Capability andtarget Execution Type are null");
            }
            throw new IllegalArgumentException("Support currently exists only for EITHER update of Capability OR update of Execution Type NOT both");
        }
        if (this.change.get(container.getId()) == null) {
            this.change.put(container.getId(), new AbstractMap.SimpleEntry<Container, UpdateContainerRequest>(container, updateContainerRequest));
        } else {
            this.change.get(container.getId()).setValue(updateContainerRequest);
        }
        if (this.pendingChange.get(container.getId()) == null) {
            this.pendingChange.put(container.getId(), new AbstractMap.SimpleEntry<Container, UpdateContainerRequest>(container, updateContainerRequest));
        } else {
            this.pendingChange.get(container.getId()).setValue(updateContainerRequest);
        }
    }

    @Override
    public synchronized void releaseAssignedContainer(ContainerId containerId) {
        Preconditions.checkArgument(containerId != null, "ContainerId can not be null.");
        this.pendingRelease.add(containerId);
        this.release.add(containerId);
        this.pendingChange.remove(containerId);
    }

    @Override
    public synchronized Resource getAvailableResources() {
        return this.clusterAvailableResources;
    }

    @Override
    public synchronized int getClusterNodeCount() {
        return this.clusterNodeCount;
    }

    @Override
    public Collection<T> getMatchingRequests(long allocationRequestId) {
        RemoteRequestsTable<T> remoteRequestsTable = this.getTable(allocationRequestId);
        LinkedHashSet list = new LinkedHashSet();
        if (remoteRequestsTable != null) {
            for (ResourceRequestInfo resReqInfo : remoteRequestsTable) {
                list.addAll(resReqInfo.containerRequests);
            }
        }
        return list;
    }

    @Override
    public synchronized List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, Resource capability) {
        return this.getMatchingRequests(priority, resourceName, ExecutionType.GUARANTEED, capability);
    }

    @Override
    public List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, ExecutionType executionType, Resource capability, String profile) {
        capability = this.checkAndGetResourceProfile(profile, capability);
        return this.getMatchingRequests(priority, resourceName, executionType, capability);
    }

    @Override
    public synchronized List<? extends Collection<T>> getMatchingRequests(Priority priority, String resourceName, ExecutionType executionType, Resource capability) {
        List<ResourceRequestInfo> matchingRequests;
        Preconditions.checkArgument(capability != null, "The Resource to be requested should not be null ");
        Preconditions.checkArgument(priority != null, "The priority at which to request containers should not be null ");
        LinkedList list = new LinkedList();
        RemoteRequestsTable<T> remoteRequestsTable = this.getTable(0L);
        if (null != remoteRequestsTable && null != (matchingRequests = remoteRequestsTable.getMatchingRequests(priority, resourceName, executionType, capability))) {
            for (ResourceRequestInfo resReqInfo : matchingRequests) {
                if (!Resources.fitsIn(resReqInfo.remoteRequest.getCapability(), capability) || resReqInfo.containerRequests.isEmpty()) continue;
                list.add(resReqInfo.containerRequests);
            }
        }
        return list;
    }

    private Set<String> resolveRacks(List<String> nodes) {
        HashSet<String> racks = new HashSet<String>();
        if (nodes != null) {
            for (String node : nodes) {
                String rack = RackResolver.resolve(node).getNetworkLocation();
                if (rack == null) {
                    LOG.warn("Failed to resolve rack for node " + node + ".");
                    continue;
                }
                racks.add(rack);
            }
        }
        return racks;
    }

    private void checkLocalityRelaxationConflict(Long allocationReqId, Priority priority, Collection<String> locations, boolean relaxLocality) {
        RemoteRequestsTable<T> remoteRequestsTable = this.getTable(allocationReqId);
        if (remoteRequestsTable != null) {
            List<ResourceRequestInfo> allCapabilityMaps = remoteRequestsTable.getAllResourceRequestInfos(priority, locations);
            for (ResourceRequestInfo reqs : allCapabilityMaps) {
                ResourceRequest remoteRequest = reqs.remoteRequest;
                boolean existingRelaxLocality = remoteRequest.getRelaxLocality();
                if (relaxLocality == existingRelaxLocality) continue;
                throw new InvalidContainerRequestException("Cannot submit a ContainerRequest asking for location " + remoteRequest.getResourceName() + " with locality relaxation " + relaxLocality + " when it has already been requestedwith locality relaxation " + existingRelaxLocality);
            }
        }
    }

    private Resource checkAndGetResourceProfile(String profile, Resource overrideResource) {
        Resource returnResource = overrideResource;
        if (profile != null && !profile.isEmpty()) {
            if (this.resourceProfilesMap == null || !this.resourceProfilesMap.containsKey(profile)) {
                throw new InvalidContainerRequestException("Invalid profile name specified=" + profile + (this.resourceProfilesMap == null ? "" : ", valid profile names are " + this.resourceProfilesMap.keySet()));
            }
            returnResource = Resources.clone(this.resourceProfilesMap.get(profile));
            for (ResourceInformation info : overrideResource.getAllResourcesListCopy()) {
                if (info.getValue() <= 0L) continue;
                returnResource.setResourceInformation(info.getName(), info);
            }
        }
        return returnResource;
    }

    private void checkNodeLabelExpression(T containerRequest) {
        String exp = ((AMRMClient.ContainerRequest)containerRequest).getNodeLabelExpression();
        if (null == exp || exp.isEmpty()) {
            return;
        }
        if (exp.contains("&&") || exp.contains("||")) {
            throw new InvalidContainerRequestException("Cannot specify more than one node label in a single node label expression");
        }
    }

    private void validateContainerResourceChangeRequest(ContainerUpdateType updateType, ContainerId containerId, Resource original, Resource target) {
        Preconditions.checkArgument(containerId != null, "ContainerId cannot be null");
        Preconditions.checkArgument(original != null, "Original resource capability cannot be null");
        Preconditions.checkArgument(!Resources.equals(Resources.none(), original) && Resources.fitsIn(Resources.none(), original), "Original resource capability must be greater than 0");
        Preconditions.checkArgument(target != null, "Target resource capability cannot be null");
        Preconditions.checkArgument(!Resources.equals(Resources.none(), target) && Resources.fitsIn(Resources.none(), target), "Target resource capability must be greater than 0");
        if (ContainerUpdateType.DECREASE_RESOURCE == updateType) {
            Preconditions.checkArgument(Resources.fitsIn(target, original), "Target resource capability must fit in Original capability");
        } else {
            Preconditions.checkArgument(Resources.fitsIn(original, target), "Target resource capability must be more than Original capability");
        }
    }

    private void validateContainerExecTypeChangeRequest(ContainerUpdateType updateType, ContainerId containerId, ExecutionType original, ExecutionType target) {
        Preconditions.checkArgument(containerId != null, "ContainerId cannot be null");
        Preconditions.checkArgument(original != null, "Original Execution Type cannot be null");
        Preconditions.checkArgument(target != null, "Target Execution Type cannot be null");
        if (ContainerUpdateType.DEMOTE_EXECUTION_TYPE == updateType) {
            Preconditions.checkArgument(target == ExecutionType.OPPORTUNISTIC && original == ExecutionType.GUARANTEED, "Incorrect Container update request, target should be OPPORTUNISTIC and original should be GUARANTEED");
        } else {
            Preconditions.checkArgument(target == ExecutionType.GUARANTEED && original == ExecutionType.OPPORTUNISTIC, "Incorrect Container update request, target should be GUARANTEED and original should be OPPORTUNISTIC");
        }
    }

    private void addResourceRequestToAsk(ResourceRequest remoteRequest) {
        if (this.ask.contains(remoteRequest)) {
            this.ask.remove(remoteRequest);
        }
        this.ask.add(remoteRequest);
    }

    private void addResourceRequest(Priority priority, String resourceName, ExecutionTypeRequest execTypeReq, Resource capability, T req, boolean relaxLocality, String labelExpression) {
        RemoteRequestsTable<T> remoteRequestsTable = this.getTable(((AMRMClient.ContainerRequest)req).getAllocationRequestId());
        if (remoteRequestsTable == null) {
            remoteRequestsTable = new RemoteRequestsTable();
            this.putTable(((AMRMClient.ContainerRequest)req).getAllocationRequestId(), remoteRequestsTable);
        }
        ResourceRequestInfo resourceRequestInfo = remoteRequestsTable.addResourceRequest(((AMRMClient.ContainerRequest)req).getAllocationRequestId(), priority, resourceName, execTypeReq, capability, req, relaxLocality, labelExpression);
        this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding request to ask " + resourceRequestInfo.remoteRequest);
            LOG.debug("addResourceRequest: applicationId= priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size());
        }
    }

    private void decResourceRequest(Priority priority, String resourceName, ExecutionTypeRequest execTypeReq, Resource capability, T req) {
        RemoteRequestsTable<T> remoteRequestsTable = this.getTable(((AMRMClient.ContainerRequest)req).getAllocationRequestId());
        if (remoteRequestsTable != null) {
            ResourceRequestInfo resourceRequestInfo = remoteRequestsTable.decResourceRequest(priority, resourceName, execTypeReq, capability, req);
            if (resourceRequestInfo != null) {
                this.addResourceRequestToAsk(resourceRequestInfo.remoteRequest);
                if (resourceRequestInfo.remoteRequest.getNumContainers() == 0) {
                    remoteRequestsTable.remove(priority, resourceName, execTypeReq.getExecutionType(), capability);
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug("AFTER decResourceRequest: allocationRequestId=" + ((AMRMClient.ContainerRequest)req).getAllocationRequestId() + " priority=" + priority.getPriority() + " resourceName=" + resourceName + " numContainers=" + resourceRequestInfo.remoteRequest.getNumContainers() + " #asks=" + this.ask.size());
                }
            }
        } else {
            LOG.info("No remoteRequestTable found with allocationRequestId=" + ((AMRMClient.ContainerRequest)req).getAllocationRequestId());
        }
    }

    @Override
    public synchronized void updateBlacklist(List<String> blacklistAdditions, List<String> blacklistRemovals) {
        if (blacklistAdditions != null) {
            this.blacklistAdditions.addAll(blacklistAdditions);
            this.blacklistedNodes.addAll(blacklistAdditions);
            this.blacklistRemovals.removeAll(blacklistAdditions);
        }
        if (blacklistRemovals != null) {
            this.blacklistRemovals.addAll(blacklistRemovals);
            this.blacklistedNodes.removeAll(blacklistRemovals);
            this.blacklistAdditions.removeAll(blacklistRemovals);
        }
        if (blacklistAdditions != null && blacklistRemovals != null && blacklistAdditions.removeAll(blacklistRemovals)) {
            LOG.warn("The same resources appear in both blacklistAdditions and blacklistRemovals in updateBlacklist.");
        }
    }

    @Override
    public synchronized void updateTrackingUrl(String trackingUrl) {
        this.newTrackingUrl = trackingUrl;
    }

    private void updateAMRMToken(org.apache.hadoop.yarn.api.records.Token token) throws IOException {
        Token amrmToken = new Token(token.getIdentifier().array(), token.getPassword().array(), new Text(token.getKind()), new Text(token.getService()));
        UserGroupInformation currentUGI = UserGroupInformation.getCurrentUser();
        currentUGI.addToken(amrmToken);
        amrmToken.setService(ClientRMProxy.getAMRMTokenService(this.getConfig()));
    }

    @VisibleForTesting
    RemoteRequestsTable<T> getTable(long allocationRequestId) {
        return this.remoteRequests.get(allocationRequestId);
    }

    RemoteRequestsTable<T> putTable(long allocationRequestId, RemoteRequestsTable<T> table) {
        return this.remoteRequests.put(allocationRequestId, table);
    }

    static class ResourceReverseComparator<T extends Resource>
    implements Comparator<T>,
    Serializable {
        ResourceReverseComparator() {
        }

        @Override
        public int compare(Resource res0, Resource res1) {
            return res1.compareTo(res0);
        }
    }

    static class ResourceRequestInfo<T> {
        ResourceRequest remoteRequest;
        LinkedHashSet<T> containerRequests;

        ResourceRequestInfo(Long allocationRequestId, Priority priority, String resourceName, Resource capability, boolean relaxLocality) {
            this.remoteRequest = ResourceRequest.newBuilder().priority(priority).resourceName(resourceName).capability(capability).numContainers(0).allocationRequestId(allocationRequestId).relaxLocality(relaxLocality).build();
            this.containerRequests = new LinkedHashSet();
        }
    }
}

