/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.imap.storage.file.disruptor;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.EventTranslatorThreeArg;
import com.lmax.disruptor.TimeoutException;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.dsl.Disruptor;
import com.lmax.disruptor.dsl.ProducerType;
import com.lmax.disruptor.util.DaemonThreadFactory;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.fs.FileSystem;
import org.apache.seatunnel.engine.imap.storage.api.exception.IMapStorageException;
import org.apache.seatunnel.engine.imap.storage.file.bean.IMapFileData;
import org.apache.seatunnel.engine.imap.storage.file.config.FileConfiguration;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.FileWALEvent;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.WALEventType;
import org.apache.seatunnel.engine.imap.storage.file.disruptor.WALWorkHandler;
import org.apache.seatunnel.engine.serializer.api.Serializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WALDisruptor
implements Closeable {
    private static final Logger log = LoggerFactory.getLogger(WALDisruptor.class);
    private volatile Disruptor<FileWALEvent> disruptor;
    private static final int DEFAULT_RING_BUFFER_SIZE = 1024;
    private static final int DEFAULT_CLOSE_WAIT_TIME_SECONDS = 5;
    private boolean isClosed = false;
    private static final EventTranslatorThreeArg<FileWALEvent, IMapFileData, WALEventType, Long> TRANSLATOR = (event, sequence, data, walEventStatus, requestId) -> {
        event.setData((IMapFileData)data);
        event.setType((WALEventType)((Object)walEventStatus));
        event.setRequestId((long)requestId);
    };

    public WALDisruptor(FileSystem fs, FileConfiguration fileConfiguration, String parentPath, Serializer serializer) {
        DaemonThreadFactory threadFactory = DaemonThreadFactory.INSTANCE;
        this.disruptor = new Disruptor<FileWALEvent>(FileWALEvent.FACTORY, 1024, threadFactory, ProducerType.SINGLE, (WaitStrategy)new BlockingWaitStrategy());
        this.disruptor.handleEventsWithWorkerPool(new WALWorkHandler(fs, fileConfiguration, parentPath, serializer));
        this.disruptor.start();
    }

    public boolean tryPublish(IMapFileData message, WALEventType status, Long requestId) {
        if (this.isClosed()) {
            return false;
        }
        this.disruptor.getRingBuffer().publishEvent(TRANSLATOR, message, status, requestId);
        return true;
    }

    public boolean tryAppendPublish(IMapFileData message, long requestId) {
        return this.tryPublish(message, WALEventType.APPEND, requestId);
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void close() throws IOException {
        try {
            this.tryPublish(null, WALEventType.CLOSED, 0L);
            this.isClosed = true;
            this.disruptor.shutdown(5L, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            log.error("WALDisruptor close timeout error", e);
            throw new IMapStorageException("WALDisruptor close timeout error", e);
        }
    }
}

