/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.core.job;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.seatunnel.engine.core.job.ConnectorJar;
import org.apache.seatunnel.engine.core.job.ConnectorJarType;

public class ConnectorJarIdentifier
implements Serializable {
    private byte[] connectorJarID;
    private ConnectorJarType type;
    private String fileName;
    private String storagePath;

    public ConnectorJarIdentifier() {
    }

    public ConnectorJarIdentifier(ConnectorJarType type, String fileName, String storagePath) {
        this.connectorJarID = new byte[0];
        this.type = type;
        this.fileName = fileName;
        this.storagePath = storagePath;
    }

    public ConnectorJarIdentifier(byte[] connectorJarID, ConnectorJarType type, String fileName, String storagePath) {
        this.connectorJarID = connectorJarID;
        this.type = type;
        this.fileName = fileName;
        this.storagePath = storagePath;
    }

    public static ConnectorJarIdentifier of(ConnectorJar connectorJar, String storagePath) {
        return ConnectorJarIdentifier.of(connectorJar.getConnectorJarID(), connectorJar.getType(), connectorJar.getFileName(), storagePath);
    }

    public static ConnectorJarIdentifier of(ConnectorJarType type, String fileName, String storagePath) {
        return new ConnectorJarIdentifier(type, fileName, storagePath);
    }

    public static ConnectorJarIdentifier of(byte[] connectorJarID, ConnectorJarType type, String fileName, String storagePath) {
        return new ConnectorJarIdentifier(connectorJarID, type, fileName, storagePath);
    }

    public byte[] getConnectorJarID() {
        return this.connectorJarID;
    }

    public ConnectorJarType getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getStoragePath() {
        return this.storagePath;
    }

    public void setConnectorJarID(byte[] connectorJarID) {
        this.connectorJarID = connectorJarID;
    }

    public void setType(ConnectorJarType type) {
        this.type = type;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setStoragePath(String storagePath) {
        this.storagePath = storagePath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ConnectorJarIdentifier)) {
            return false;
        }
        ConnectorJarIdentifier other = (ConnectorJarIdentifier)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getConnectorJarID(), other.getConnectorJarID())) {
            return false;
        }
        ConnectorJarType this$type = this.getType();
        ConnectorJarType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$fileName = this.getFileName();
        String other$fileName = other.getFileName();
        if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
            return false;
        }
        String this$storagePath = this.getStoragePath();
        String other$storagePath = other.getStoragePath();
        return !(this$storagePath == null ? other$storagePath != null : !this$storagePath.equals(other$storagePath));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ConnectorJarIdentifier;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getConnectorJarID());
        ConnectorJarType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $fileName = this.getFileName();
        result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
        String $storagePath = this.getStoragePath();
        result = result * 59 + ($storagePath == null ? 43 : $storagePath.hashCode());
        return result;
    }
}

