/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.api.table.converter;

import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.seatunnel.api.table.catalog.Column;
import org.apache.seatunnel.api.table.converter.DataConverter;
import org.apache.seatunnel.api.table.type.ArrayType;
import org.apache.seatunnel.api.table.type.BasicType;
import org.apache.seatunnel.api.table.type.MapType;
import org.apache.seatunnel.api.table.type.SeaTunnelDataType;
import org.apache.seatunnel.api.table.type.SeaTunnelRow;
import org.apache.seatunnel.api.table.type.SeaTunnelRowType;

public interface BasicDataConverter<T>
extends DataConverter<T> {
    @Override
    default public Object convert(SeaTunnelDataType typeDefine, Object value) {
        if (value == null) {
            return null;
        }
        switch (typeDefine.getSqlType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return this.convertBoolean(value);
            }
            case TINYINT: {
                return this.convertByte(value);
            }
            case SMALLINT: {
                return this.convertShort(value);
            }
            case INT: {
                return this.convertInt(value);
            }
            case BIGINT: {
                return this.convertLong(value);
            }
            case FLOAT: {
                return Float.valueOf(this.convertFloat(value));
            }
            case DOUBLE: {
                return this.convertDouble(value);
            }
            case DECIMAL: {
                return this.convertDecimal(value);
            }
            case DATE: {
                return this.convertLocalDate(value);
            }
            case TIME: {
                return this.convertTime(value);
            }
            case TIMESTAMP: {
                return this.convertLocalDateTime(value);
            }
            case BYTES: {
                return this.convertBytes(value);
            }
            case STRING: {
                return this.convertString(value);
            }
            case ROW: {
                return this.convertRow((SeaTunnelRowType)typeDefine, value);
            }
            case ARRAY: {
                return this.convertArray((ArrayType)typeDefine, value);
            }
            case MAP: {
                return this.convertMap((MapType)typeDefine, value);
            }
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to " + (Object)((Object)typeDefine.getSqlType()));
    }

    @Override
    default public Object convert(T typeDefine, Column columnDefine, Object value) {
        if (value == null) {
            return null;
        }
        switch (columnDefine.getDataType().getSqlType()) {
            case NULL: {
                return null;
            }
            case BOOLEAN: {
                return this.convertBoolean(typeDefine, value);
            }
            case TINYINT: {
                return this.convertByte(typeDefine, value);
            }
            case SMALLINT: {
                return this.convertShort(typeDefine, value);
            }
            case INT: {
                return this.convertInt(typeDefine, value);
            }
            case BIGINT: {
                return this.convertLong(typeDefine, value);
            }
            case FLOAT: {
                return Float.valueOf(this.convertFloat(typeDefine, value));
            }
            case DOUBLE: {
                return this.convertDouble(typeDefine, value);
            }
            case DECIMAL: {
                return this.convertDecimal(typeDefine, value);
            }
            case DATE: {
                return this.convertLocalDate(typeDefine, value);
            }
            case TIME: {
                return this.convertTime(typeDefine, value);
            }
            case TIMESTAMP: {
                return this.convertLocalDateTime(typeDefine, value);
            }
            case BYTES: {
                return this.convertBytes(typeDefine, value);
            }
            case STRING: {
                return this.convertString(typeDefine, value);
            }
            case ROW: {
                return this.convertRow(typeDefine, columnDefine, value);
            }
            case ARRAY: {
                return this.convertArray(typeDefine, columnDefine, value);
            }
            case MAP: {
                return this.convertMap(typeDefine, columnDefine, value);
            }
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to " + (Object)((Object)columnDefine.getDataType().getSqlType()));
    }

    default public Map convertMap(T typeDefine, Column columnDefine, Object value) throws UnsupportedOperationException {
        return this.convertMap((MapType)columnDefine.getDataType(), value);
    }

    default public Map convertMap(MapType typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Map) {
            return (Map)value;
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Map, typeDefine: " + typeDefine);
    }

    default public Object[] convertArray(T typeDefine, Column columnDefine, Object value) throws UnsupportedOperationException {
        return this.convertArray((ArrayType)columnDefine.getDataType(), value);
    }

    default public Object[] convertArray(ArrayType typeDefine, Object value) throws UnsupportedOperationException {
        if (value.getClass().isArray()) {
            BasicType elementType = typeDefine.getElementType();
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                array[i] = this.convert(elementType, array[i]);
            }
            return array;
        }
        if (value instanceof List) {
            BasicType elementType = typeDefine.getElementType();
            List list = (List)value;
            int elements = list.size();
            for (int i = 0; i < elements; ++i) {
                list.set(i, this.convert(elementType, list.get(i)));
            }
            return list.toArray();
        }
        if (value instanceof Set) {
            BasicType elementType = typeDefine.getElementType();
            return ((Set)value).stream().map(e -> this.convert(elementType, e)).toArray();
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Array, typeDefine: " + typeDefine);
    }

    default public SeaTunnelRow convertRow(T typeDefine, Column columnDefine, Object value) throws UnsupportedOperationException {
        return this.convertRow((SeaTunnelRowType)columnDefine.getDataType(), value);
    }

    default public SeaTunnelRow convertRow(SeaTunnelRowType typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof SeaTunnelRow) {
            return (SeaTunnelRow)value;
        }
        if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (collection.size() != typeDefine.getTotalFields()) {
                throw new IllegalArgumentException("The size of collection is not equal to the size of row type");
            }
            Object[] array = new Object[collection.size()];
            int i = 0;
            for (Object object : collection) {
                SeaTunnelDataType<?> type = typeDefine.getFieldType(i);
                array[i] = this.convert(type, object);
                ++i;
            }
            return new SeaTunnelRow(array);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            Object[] array = new Object[typeDefine.getTotalFields()];
            for (int i = 0; i < typeDefine.getTotalFields(); ++i) {
                String key = typeDefine.getFieldName(i);
                SeaTunnelDataType<?> type = typeDefine.getFieldType(i);
                Object object = map.get(key);
                array[i] = this.convert(type, object);
            }
            return new SeaTunnelRow(array);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Row, typeDefine: " + typeDefine);
    }

    default public String convertString(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return this.convertString(typeDefine, (Number)value);
        }
        if (value instanceof byte[]) {
            return this.convertString(typeDefine, (byte[])value);
        }
        if (value instanceof Boolean) {
            return this.convertString(typeDefine, (Boolean)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertString(typeDefine, (java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertString(typeDefine, (LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return this.convertString(typeDefine, (LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertString(typeDefine, (LocalDateTime)value);
        }
        return value.toString();
    }

    default public String convertString(T typeDefine, Number value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, byte[] value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, boolean value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, java.util.Date value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, LocalDate value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, Time value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, LocalTime value) {
        return this.convertString(value);
    }

    default public String convertString(T typeDefine, LocalDateTime value) {
        return this.convertString(value);
    }

    default public String convertString(Object value) throws UnsupportedOperationException {
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return this.convertString((Number)value);
        }
        if (value instanceof byte[]) {
            return this.convertString((byte[])value);
        }
        if (value instanceof Boolean) {
            return this.convertString((Boolean)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertString((java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertString((LocalDate)value);
        }
        if (value instanceof LocalTime) {
            return this.convertString((LocalTime)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertString((LocalDateTime)value);
        }
        return value.toString();
    }

    default public String convertString(Number value) {
        return String.valueOf(value);
    }

    default public String convertString(byte[] value) {
        return new String(value);
    }

    default public String convertString(boolean value) {
        return value ? "true" : "false";
    }

    default public String convertString(java.util.Date value) {
        return value.toString();
    }

    default public String convertString(LocalDate value) {
        return value.toString();
    }

    default public String convertString(Time value) {
        return value.toString();
    }

    default public String convertString(LocalTime value) {
        return value.toString();
    }

    default public String convertString(LocalDateTime value) {
        return value.toString();
    }

    default public byte[] convertBytes(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof ByteBuffer) {
            return this.convertBytes((ByteBuffer)value);
        }
        if (value instanceof String) {
            return this.convertBytes(typeDefine, (String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to byte[], typeDefine: " + typeDefine);
    }

    default public byte[] convertBytes(T typeDefine, String value) {
        return this.convertBytes(value);
    }

    default public byte[] convertBytes(Object value) throws UnsupportedOperationException {
        if (value instanceof byte[]) {
            return (byte[])value;
        }
        if (value instanceof ByteBuffer) {
            return this.convertBytes((ByteBuffer)value);
        }
        if (value instanceof String) {
            return this.convertBytes((String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to byte[]");
    }

    default public byte[] convertBytes(ByteBuffer value) {
        byte[] bytes = new byte[value.remaining()];
        value.get(bytes);
        return bytes;
    }

    default public byte[] convertBytes(String value) {
        return value.getBytes();
    }

    default public LocalDateTime convertLocalDateTime(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof Instant) {
            return this.convertLocalDateTime(typeDefine, (Instant)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertLocalDateTime(typeDefine, (java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertLocalDateTime((LocalDate)value);
        }
        if (value instanceof Date) {
            return this.convertLocalDateTime((Date)value);
        }
        if (value instanceof Timestamp) {
            return this.convertLocalDateTime((Timestamp)value);
        }
        if (value instanceof String) {
            return this.convertLocalDateTime(typeDefine, (String)value);
        }
        if (value instanceof Number) {
            return this.convertLocalDateTime(typeDefine, (Number)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to LocalDateTime, typeDefine: " + typeDefine);
    }

    default public LocalDateTime convertLocalDateTime(T typeDefine, Instant value) {
        return this.convertLocalDateTime(value);
    }

    default public LocalDateTime convertLocalDateTime(T typeDefine, java.util.Date value) {
        return this.convertLocalDateTime(value);
    }

    default public LocalDateTime convertLocalDateTime(T typeDefine, String value) {
        return this.convertLocalDateTime(value);
    }

    default public LocalDateTime convertLocalDateTime(T typeDefine, Number value) {
        return this.convertLocalDateTime(value);
    }

    default public LocalDateTime convertLocalDateTime(Object value) throws UnsupportedOperationException {
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        if (value instanceof OffsetDateTime) {
            return ((OffsetDateTime)value).toLocalDateTime();
        }
        if (value instanceof Instant) {
            return this.convertLocalDateTime((Instant)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertLocalDateTime((java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertLocalDateTime((LocalDate)value);
        }
        if (value instanceof Date) {
            return this.convertLocalDateTime((Date)value);
        }
        if (value instanceof Timestamp) {
            return this.convertLocalDateTime((Timestamp)value);
        }
        if (value instanceof String) {
            return this.convertLocalDateTime((String)value);
        }
        if (value instanceof Number) {
            return this.convertLocalDateTime((Number)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to LocalDateTime");
    }

    default public LocalDateTime convertLocalDateTime(Instant value) {
        return value.atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    default public LocalDateTime convertLocalDateTime(java.util.Date value) {
        return value.toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    default public LocalDateTime convertLocalDateTime(LocalDate value) {
        return LocalDateTime.of(value, LocalTime.MIDNIGHT);
    }

    default public LocalDateTime convertLocalDateTime(Date value) {
        LocalDate date = value.toLocalDate();
        return LocalDateTime.of(date, LocalTime.MIDNIGHT);
    }

    default public LocalDateTime convertLocalDateTime(Timestamp value) {
        return LocalDateTime.of(value.getYear() + 1900, value.getMonth() + 1, value.getDate(), value.getHours(), value.getMinutes(), value.getSeconds(), value.getNanos());
    }

    default public LocalDateTime convertLocalDateTime(String value) {
        return LocalDateTime.parse(value);
    }

    default public LocalDateTime convertLocalDateTime(Number value) {
        if (value.longValue() < 999999999L) {
            return LocalDateTime.ofEpochSecond(value.longValue(), 0, ZoneId.systemDefault().getRules().getOffset(LocalDateTime.now()));
        }
        return new java.util.Date(value.longValue()).toInstant().atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    default public LocalTime convertTime(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof java.util.Date) {
            return this.convertLocalTime((java.util.Date)value);
        }
        if (value instanceof Time) {
            return this.convertLocalTime(typeDefine, (Time)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertLocalTime((LocalDateTime)value);
        }
        if (value instanceof Timestamp) {
            return this.convertLocalTime((Timestamp)value);
        }
        if (value instanceof String) {
            return this.convertLocalTime(typeDefine, (String)value);
        }
        if (value instanceof Number) {
            return this.convertLocalTime(typeDefine, (Number)value);
        }
        if (value instanceof Duration) {
            return this.convertLocalTime((Duration)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to LocalTime, typeDefine: " + typeDefine);
    }

    default public LocalTime convertLocalTime(T typeDefine, Time value) {
        return this.convertLocalTime(value);
    }

    default public LocalTime convertLocalTime(T typeDefine, String value) {
        return this.convertLocalTime(value);
    }

    default public LocalTime convertLocalTime(T typeDefine, Number value) {
        return this.convertLocalTime(value);
    }

    default public LocalTime convertTime(Object value) throws UnsupportedOperationException {
        if (value instanceof LocalTime) {
            return (LocalTime)value;
        }
        if (value instanceof java.util.Date) {
            return this.convertLocalTime((java.util.Date)value);
        }
        if (value instanceof Time) {
            return this.convertLocalTime((Time)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertLocalTime((LocalDateTime)value);
        }
        if (value instanceof Timestamp) {
            return this.convertLocalTime((Timestamp)value);
        }
        if (value instanceof String) {
            return this.convertLocalTime((String)value);
        }
        if (value instanceof Number) {
            return this.convertLocalTime((Number)value);
        }
        if (value instanceof Duration) {
            return this.convertLocalTime((Duration)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to LocalTime");
    }

    default public LocalTime convertLocalTime(LocalDateTime value) {
        return value.toLocalTime();
    }

    default public LocalTime convertLocalTime(Time value) {
        return value.toLocalTime();
    }

    default public LocalTime convertLocalTime(Timestamp value) {
        return LocalTime.of(value.getHours(), value.getMinutes(), value.getSeconds(), value.getNanos());
    }

    default public LocalTime convertLocalTime(java.util.Date value) {
        long millis = (int)(value.getTime() % TimeUnit.SECONDS.toMillis(1L));
        int nanosOfSecond = (int)(millis * TimeUnit.MILLISECONDS.toNanos(1L));
        return LocalTime.of(value.getHours(), value.getMinutes(), value.getSeconds(), nanosOfSecond);
    }

    default public LocalTime convertLocalTime(Duration value) {
        Long nanos = value.toNanos();
        if (nanos >= 0L && nanos <= TimeUnit.DAYS.toNanos(1L)) {
            return LocalTime.ofNanoOfDay(nanos);
        }
        throw new IllegalArgumentException("Time values must use number of milliseconds greater than 0 and less than 86400000000000");
    }

    default public LocalTime convertLocalTime(String value) {
        return LocalTime.parse(value);
    }

    default public LocalTime convertLocalTime(Number value) {
        return LocalTime.ofSecondOfDay(value.longValue());
    }

    default public LocalDate convertLocalDate(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof java.util.Date) {
            return this.convertLocalDate(typeDefine, (java.util.Date)value);
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof String) {
            return this.convertLocalDate(typeDefine, (String)value);
        }
        if (value instanceof Number) {
            return this.convertLocalDate(typeDefine, (Number)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to LocalDate, typeDefine: " + typeDefine);
    }

    default public LocalDate convertLocalDate(T typeDefine, java.util.Date value) {
        return this.convertLocalDate(value);
    }

    default public LocalDate convertLocalDate(T typeDefine, String value) {
        return this.convertLocalDate(value);
    }

    default public LocalDate convertLocalDate(T typeDefine, Number value) {
        return this.convertLocalDate(value);
    }

    default public LocalDate convertLocalDate(Object value) throws UnsupportedOperationException {
        if (value instanceof LocalDate) {
            return (LocalDate)value;
        }
        if (value instanceof java.util.Date) {
            return this.convertLocalDate((java.util.Date)value);
        }
        if (value instanceof LocalDateTime) {
            return ((LocalDateTime)value).toLocalDate();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof String) {
            return this.convertLocalDate((String)value);
        }
        if (value instanceof Number) {
            return this.convertLocalDate((Number)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to LocalDate");
    }

    default public LocalDate convertLocalDate(java.util.Date value) {
        return value.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    default public LocalDate convertLocalDate(String value) {
        return LocalDate.parse(value);
    }

    default public LocalDate convertLocalDate(Number value) {
        if (value.longValue() < 999999999L) {
            return LocalDateTime.ofEpochSecond(value.longValue(), 0, ZoneId.systemDefault().getRules().getOffset(LocalDateTime.now())).toLocalDate();
        }
        return new java.util.Date(value.longValue()).toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
    }

    default public BigDecimal convertDecimal(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return this.convertDecimal(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertDecimal(typeDefine, (String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to BigDecimal, typeDefine: " + typeDefine);
    }

    default public BigDecimal convertDecimal(T typeDefine, Number value) {
        return this.convertDecimal(value);
    }

    default public BigDecimal convertDecimal(T typeDefine, String value) {
        return this.convertDecimal(value);
    }

    default public BigDecimal convertDecimal(Object value) throws UnsupportedOperationException {
        if (value instanceof BigDecimal) {
            return (BigDecimal)value;
        }
        if (value instanceof Number) {
            return this.convertDecimal((Number)value);
        }
        if (value instanceof String) {
            return this.convertDecimal((String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to BigDecimal");
    }

    default public BigDecimal convertDecimal(Number value) {
        return new BigDecimal(value.doubleValue());
    }

    default public BigDecimal convertDecimal(String value) {
        return new BigDecimal(value);
    }

    default public double convertDouble(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return this.convertDouble(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertDouble(typeDefine, (String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Double, typeDefine: " + typeDefine);
    }

    default public double convertDouble(T typeDefine, Number value) {
        return this.convertDouble(value);
    }

    default public double convertDouble(T typeDefine, String value) {
        return this.convertDouble(value);
    }

    default public double convertDouble(Object value) throws UnsupportedOperationException {
        if (value instanceof Double) {
            return (Double)value;
        }
        if (value instanceof Number) {
            return this.convertDouble((Number)value);
        }
        if (value instanceof String) {
            return this.convertDouble((String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Double");
    }

    default public double convertDouble(Number value) {
        return value.doubleValue();
    }

    default public double convertDouble(String value) {
        return Double.parseDouble(value);
    }

    default public float convertFloat(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return this.convertFloat(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertFloat(typeDefine, (String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Float, typeDefine: " + typeDefine);
    }

    default public float convertFloat(T typeDefine, Number value) {
        return this.convertFloat(value);
    }

    default public float convertFloat(T typeDefine, String value) {
        return this.convertFloat(value);
    }

    default public float convertFloat(Object value) throws UnsupportedOperationException {
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Number) {
            return this.convertFloat((Number)value);
        }
        if (value instanceof String) {
            return this.convertFloat((String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Float");
    }

    default public float convertFloat(Number value) {
        return value.floatValue();
    }

    default public float convertFloat(String value) {
        return Float.parseFloat(value);
    }

    default public long convertLong(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return this.convertLong(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertLong(typeDefine, (String)value);
        }
        if (value instanceof Time) {
            return this.convertLong(typeDefine, (Time)value);
        }
        if (value instanceof LocalTime) {
            return this.convertLong(typeDefine, (LocalTime)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertLong(typeDefine, (java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertLong(typeDefine, (LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertLong(typeDefine, (LocalDateTime)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Long, typeDefine: " + typeDefine);
    }

    default public long convertLong(T typeDefine, Number value) {
        return this.convertLong(value);
    }

    default public long convertLong(T typeDefine, String value) {
        return this.convertLong(value);
    }

    default public long convertLong(T typeDefine, Time value) {
        return this.convertLong(value);
    }

    default public long convertLong(T typeDefine, LocalTime value) {
        return this.convertLong(value);
    }

    default public long convertLong(T typeDefine, java.util.Date value) {
        return this.convertLong(value);
    }

    default public long convertLong(T typeDefine, LocalDate value) {
        return this.convertLong(value);
    }

    default public long convertLong(T typeDefine, LocalDateTime value) {
        return this.convertLong(value);
    }

    default public long convertLong(Object value) throws UnsupportedOperationException {
        if (value instanceof Long) {
            return (Long)value;
        }
        if (value instanceof Number) {
            return this.convertLong((Number)value);
        }
        if (value instanceof String) {
            return this.convertLong((String)value);
        }
        if (value instanceof Time) {
            return this.convertLong((Time)value);
        }
        if (value instanceof LocalTime) {
            return this.convertLong((LocalTime)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertLong((java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertLong((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertLong((LocalDateTime)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Long");
    }

    default public long convertLong(Number value) {
        return value.longValue();
    }

    default public long convertLong(String value) {
        return Long.parseLong(value);
    }

    default public long convertLong(Time value) {
        return value.toLocalTime().toSecondOfDay();
    }

    default public long convertLong(LocalTime value) {
        return value.toSecondOfDay();
    }

    default public long convertLong(java.util.Date value) {
        return value.getTime();
    }

    default public long convertLong(LocalDate value) {
        return value.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    default public long convertLong(LocalDateTime value) {
        return value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
    }

    default public int convertInt(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return this.convertInt(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertInt(typeDefine, (String)value);
        }
        if (value instanceof Time) {
            return this.convertInt(typeDefine, (Time)value);
        }
        if (value instanceof LocalTime) {
            return this.convertInt(typeDefine, (LocalTime)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertInt(typeDefine, (java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertInt(typeDefine, (LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertInt(typeDefine, (LocalDateTime)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Integer, typeDefine: " + typeDefine);
    }

    default public int convertInt(T typeDefine, Number value) {
        return this.convertInt(value);
    }

    default public int convertInt(T typeDefine, String value) {
        return this.convertInt(value);
    }

    default public int convertInt(T typeDefine, Time value) {
        return this.convertInt(value);
    }

    default public int convertInt(T typeDefine, LocalTime value) {
        return this.convertInt(value);
    }

    default public int convertInt(T typeDefine, java.util.Date value) {
        return this.convertInt(value);
    }

    default public int convertInt(T typeDefine, LocalDate value) {
        return this.convertInt(value);
    }

    default public int convertInt(T typeDefine, LocalDateTime value) {
        return this.convertInt(value);
    }

    default public int convertInt(Object value) throws UnsupportedOperationException {
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof Number) {
            return this.convertInt((Number)value);
        }
        if (value instanceof String) {
            return this.convertInt((String)value);
        }
        if (value instanceof Time) {
            return this.convertInt((Time)value);
        }
        if (value instanceof LocalTime) {
            return this.convertInt((LocalTime)value);
        }
        if (value instanceof java.util.Date) {
            return this.convertInt((java.util.Date)value);
        }
        if (value instanceof LocalDate) {
            return this.convertInt((LocalDate)value);
        }
        if (value instanceof LocalDateTime) {
            return this.convertInt((LocalDateTime)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Integer");
    }

    default public int convertInt(Number value) {
        return value.intValue();
    }

    default public int convertInt(String value) {
        return Integer.parseInt(value);
    }

    default public int convertInt(Time value) {
        return value.toLocalTime().toSecondOfDay();
    }

    default public int convertInt(LocalTime value) {
        return value.toSecondOfDay();
    }

    default public int convertInt(java.util.Date value) {
        return (int)(value.getTime() / 1000L);
    }

    default public int convertInt(LocalDateTime value) {
        return (int)(value.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli() / 1000L);
    }

    default public int convertInt(LocalDate value) {
        return (int)(value.atStartOfDay(ZoneId.systemDefault()).toInstant().toEpochMilli() / 1000L);
    }

    default public short convertShort(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return this.convertShort(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertShort(typeDefine, (String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Short, typeDefine: " + typeDefine);
    }

    default public short convertShort(T typeDefine, Number value) {
        return this.convertShort(value);
    }

    default public short convertShort(T typeDefine, String value) {
        return this.convertShort(value);
    }

    default public short convertShort(Object value) throws UnsupportedOperationException {
        if (value instanceof Short) {
            return (Short)value;
        }
        if (value instanceof Number) {
            return this.convertShort((Number)value);
        }
        if (value instanceof String) {
            return this.convertShort((String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Short");
    }

    default public short convertShort(Number value) {
        return value.shortValue();
    }

    default public short convertShort(String value) {
        return Short.parseShort(value);
    }

    default public byte convertByte(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return this.convertByte(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertByte(typeDefine, (String)value);
        }
        if (value instanceof Boolean) {
            return this.convertByte(typeDefine, (Boolean)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Byte, typeDefine: " + typeDefine);
    }

    default public byte convertByte(T typeDefine, Number value) {
        return this.convertByte(value);
    }

    default public byte convertByte(T typeDefine, String value) {
        return this.convertByte(value);
    }

    default public byte convertByte(T typeDefine, boolean value) {
        return this.convertByte(value);
    }

    default public byte convertByte(Object value) throws UnsupportedOperationException {
        if (value instanceof Byte) {
            return (Byte)value;
        }
        if (value instanceof Number) {
            return this.convertByte((Number)value);
        }
        if (value instanceof String) {
            return this.convertByte((String)value);
        }
        if (value instanceof Boolean) {
            return this.convertByte((Boolean)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Byte");
    }

    default public byte convertByte(Number value) {
        return value.byteValue();
    }

    default public byte convertByte(String value) {
        return Byte.parseByte(value);
    }

    default public byte convertByte(boolean value) {
        return value ? (byte)1 : 0;
    }

    default public boolean convertBoolean(T typeDefine, Object value) throws UnsupportedOperationException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return this.convertBoolean(typeDefine, (Number)value);
        }
        if (value instanceof String) {
            return this.convertBoolean(typeDefine, (String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Boolean, typeDefine: " + typeDefine);
    }

    default public boolean convertBoolean(T typeDefine, Number value) {
        return this.convertBoolean(value);
    }

    default public boolean convertBoolean(T typeDefine, String value) {
        return this.convertBoolean(value);
    }

    default public boolean convertBoolean(Object value) throws UnsupportedOperationException {
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        if (value instanceof Number) {
            return this.convertBoolean((Number)value);
        }
        if (value instanceof String) {
            return this.convertBoolean((String)value);
        }
        throw new UnsupportedOperationException("Unsupported convert " + value.getClass() + " to Boolean");
    }

    default public boolean convertBoolean(Number value) {
        return value.intValue() != 0;
    }

    default public boolean convertBoolean(String value) {
        return Boolean.parseBoolean(value);
    }
}

