/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.org.everit.json.schema;

import com.hazelcast.org.everit.json.schema.Schema;
import com.hazelcast.org.everit.json.schema.Visitor;
import com.hazelcast.org.everit.json.schema.loader.OrgJsonUtil;
import com.hazelcast.org.json.JSONArray;
import com.hazelcast.org.json.JSONObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class EnumSchema
extends Schema {
    private final List<Object> possibleValues;

    static Object toJavaValue(Object orig) {
        if (orig instanceof JSONArray) {
            return OrgJsonUtil.toList((JSONArray)orig);
        }
        if (orig instanceof JSONObject) {
            return OrgJsonUtil.toMap((JSONObject)orig);
        }
        if (orig == JSONObject.NULL) {
            return null;
        }
        return orig;
    }

    static List<Object> toJavaValues(List<Object> orgJsons) {
        return orgJsons.stream().map(EnumSchema::toJavaValue).collect(Collectors.toList());
    }

    public static Builder builder() {
        return new Builder();
    }

    public EnumSchema(Builder builder) {
        super(builder);
        this.possibleValues = Collections.unmodifiableList(EnumSchema.toJavaValues(builder.possibleValues));
    }

    public Set<Object> getPossibleValues() {
        return this.possibleValues.stream().collect(Collectors.toSet());
    }

    public List<Object> getPossibleValuesAsList() {
        return this.possibleValues;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof EnumSchema) {
            EnumSchema that = (EnumSchema)o;
            return that.canEqual(this) && Objects.equals(this.possibleValues, that.possibleValues) && super.equals(that);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.possibleValues);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.visitEnumSchema(this);
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof EnumSchema;
    }

    public static class Builder
    extends Schema.Builder<EnumSchema> {
        private List<Object> possibleValues = new ArrayList<Object>();

        @Override
        public EnumSchema build() {
            return new EnumSchema(this);
        }

        public Builder possibleValue(Object possibleValue) {
            this.possibleValues.add(possibleValue);
            return this;
        }

        public Builder possibleValues(List<Object> possibleValues) {
            this.possibleValues = possibleValues;
            return this;
        }

        public Builder possibleValues(Set<Object> possibleValues) {
            this.possibleValues = possibleValues.stream().collect(Collectors.toList());
            return this;
        }
    }
}

