/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;

public class EventListenerCounter {
    private final ConcurrentMap<String, AtomicInteger> counterPerMap = new ConcurrentHashMap<String, AtomicInteger>();

    public AtomicInteger getOrCreateCounter(String mapName) {
        return this.counterPerMap.computeIfAbsent(mapName, s2 -> new AtomicInteger());
    }

    public void removeCounter(String mapName, AtomicInteger counter2) {
        this.counterPerMap.remove(mapName, counter2);
    }

    public void incCounter(String mapName) {
        this.getOrCreateCounter(mapName).incrementAndGet();
    }

    public void decCounter(String mapName) {
        AtomicInteger counter2 = (AtomicInteger)this.counterPerMap.get(mapName);
        if (counter2 != null) {
            int count = counter2.decrementAndGet();
            assert (count >= 0);
        }
    }
}

