/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.server.task.operation.source;

import com.hazelcast.cluster.Address;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;
import org.apache.seatunnel.common.utils.RetryUtils;
import org.apache.seatunnel.engine.server.SeaTunnelServer;
import org.apache.seatunnel.engine.server.checkpoint.operation.CheckpointErrorReportOperation;
import org.apache.seatunnel.engine.server.exception.TaskGroupContextNotFoundException;
import org.apache.seatunnel.engine.server.execution.TaskLocation;
import org.apache.seatunnel.engine.server.serializable.TaskDataSerializerHook;
import org.apache.seatunnel.engine.server.task.SourceSplitEnumeratorTask;

public class SourceRegisterOperation
extends Operation
implements IdentifiedDataSerializable {
    private TaskLocation readerTaskID;
    private TaskLocation enumeratorTaskID;

    public SourceRegisterOperation() {
    }

    public SourceRegisterOperation(TaskLocation readerTaskID, TaskLocation enumeratorTaskID) {
        this.readerTaskID = readerTaskID;
        this.enumeratorTaskID = enumeratorTaskID;
    }

    @Override
    public void run() throws Exception {
        SeaTunnelServer server = (SeaTunnelServer)this.getService();
        Address readerAddress = this.getCallerAddress();
        RetryUtils.retryWithException(() -> {
            ClassLoader classLoader = server.getTaskExecutionService().getExecutionContext(this.enumeratorTaskID.getTaskGroupLocation()).getClassLoader();
            ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
            SourceSplitEnumeratorTask task = (SourceSplitEnumeratorTask)server.getTaskExecutionService().getTask(this.enumeratorTaskID);
            task.getExecutionContext().getTaskExecutionService().asyncExecuteFunction(this.enumeratorTaskID.getTaskGroupLocation(), () -> {
                try {
                    Thread.currentThread().setContextClassLoader(classLoader);
                    task.receivedReader(this.readerTaskID, readerAddress);
                }
                catch (Exception e) {
                    task.getExecutionContext().sendToMaster(new CheckpointErrorReportOperation(this.enumeratorTaskID, e));
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            });
            return null;
        }, new RetryUtils.RetryMaterial(30, true, exception -> exception instanceof TaskGroupContextNotFoundException && !server.taskIsEnded(this.enumeratorTaskID.getTaskGroupLocation()), 2000L));
    }

    @Override
    public String getServiceName() {
        return "st:impl:seaTunnelServer";
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.readerTaskID);
        out.writeObject(this.enumeratorTaskID);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.readerTaskID = (TaskLocation)in.readObject();
        this.enumeratorTaskID = (TaskLocation)in.readObject();
    }

    @Override
    public int getFactoryId() {
        return TaskDataSerializerHook.FACTORY_ID;
    }

    @Override
    public int getClassId() {
        return 1;
    }
}

