/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.engine.checkpoint.storage.hdfs;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.seatunnel.engine.checkpoint.storage.PipelineState;
import org.apache.seatunnel.engine.checkpoint.storage.api.AbstractCheckpointStorage;
import org.apache.seatunnel.engine.checkpoint.storage.exception.CheckpointStorageException;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.AbstractConfiguration;
import org.apache.seatunnel.engine.checkpoint.storage.hdfs.common.FileConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HdfsStorage
extends AbstractCheckpointStorage {
    private static final Logger log = LoggerFactory.getLogger(HdfsStorage.class);
    public FileSystem fs;
    private static final String STORAGE_TMP_SUFFIX = "tmp";
    private static final String STORAGE_TYPE_KEY = "storage.type";

    public HdfsStorage(Map<String, String> configuration) throws CheckpointStorageException {
        this.initStorage(configuration);
    }

    @Override
    public void initStorage(Map<String, String> configuration) throws CheckpointStorageException {
        if (StringUtils.isNotBlank(configuration.get("namespace"))) {
            this.setStorageNameSpace(configuration.get("namespace"));
            configuration.remove("namespace");
        }
        Configuration hadoopConf = this.getConfiguration(configuration);
        try {
            this.fs = FileSystem.get((Configuration)hadoopConf);
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to get file system", e);
        }
    }

    private Configuration getConfiguration(Map<String, String> config) throws CheckpointStorageException {
        String storageType = config.getOrDefault(STORAGE_TYPE_KEY, FileConfiguration.LOCAL.toString());
        config.remove(STORAGE_TYPE_KEY);
        AbstractConfiguration configuration = FileConfiguration.valueOf(storageType.toUpperCase()).getConfiguration(storageType);
        return configuration.buildConfiguration(config);
    }

    @Override
    public String storeCheckPoint(PipelineState state) throws CheckpointStorageException {
        byte[] datas;
        try {
            datas = this.serializeCheckPointData(state);
        }
        catch (IOException e) {
            throw new CheckpointStorageException(String.format("Failed to serialize checkpoint data, state: %s", state), e);
        }
        Path filePath = new Path(this.getStorageParentDirectory() + state.getJobId() + "/" + this.getCheckPointName(state));
        Path tmpFilePath = new Path(this.getStorageParentDirectory() + state.getJobId() + "/" + this.getCheckPointName(state) + STORAGE_TMP_SUFFIX);
        try (FSDataOutputStream out = this.fs.create(tmpFilePath, false);){
            out.write(datas);
        }
        catch (IOException e) {
            throw new CheckpointStorageException(String.format("Failed to write checkpoint data, file: %s, state: %s", tmpFilePath, state), e);
        }
        try {
            boolean success = this.fs.rename(tmpFilePath, filePath);
            if (!success) {
                throw new CheckpointStorageException("Failed to rename tmp file to final file");
            }
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to rename tmp file to final file");
        }
        finally {
            try {
                if (this.fs.exists(tmpFilePath)) {
                    this.fs.delete(tmpFilePath, false);
                }
            }
            catch (IOException ioe) {
                log.error("Failed to delete tmp file", ioe);
            }
        }
        return filePath.getName();
    }

    @Override
    public List<PipelineState> getAllCheckpoints(String jobId) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            log.info("No checkpoint found for this job, the job id is: " + jobId);
            return new ArrayList<PipelineState>();
        }
        ArrayList<PipelineState> states = new ArrayList<PipelineState>();
        fileNames.forEach(file -> {
            try {
                states.add(this.readPipelineState((String)file, jobId));
            }
            catch (CheckpointStorageException e) {
                log.error("Failed to read checkpoint data from file: " + file, e);
            }
        });
        if (states.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job, job id is: " + jobId);
        }
        return states;
    }

    @Override
    public List<PipelineState> getLatestCheckpoint(String jobId) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            log.info("No checkpoint found for this  job, the job id is: " + jobId);
            return new ArrayList<PipelineState>();
        }
        Set<String> latestPipelineNames = this.getLatestPipelineNames(fileNames);
        ArrayList<PipelineState> latestPipelineStates = new ArrayList<PipelineState>();
        latestPipelineNames.forEach(fileName -> {
            try {
                latestPipelineStates.add(this.readPipelineState((String)fileName, jobId));
            }
            catch (CheckpointStorageException e) {
                log.error("Failed to read pipeline state for file: {}", fileName, (Object)e);
            }
        });
        if (latestPipelineStates.isEmpty()) {
            log.info("No checkpoint found for this job,  the job id:{} " + jobId);
        }
        return latestPipelineStates;
    }

    @Override
    public PipelineState getLatestCheckpointByJobIdAndPipelineId(String jobId, String pipelineId) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            log.info("No checkpoint found for job, job id is: " + jobId);
            return null;
        }
        String latestFileName = this.getLatestCheckpointFileNameByJobIdAndPipelineId(fileNames, pipelineId);
        if (latestFileName == null) {
            log.info("No checkpoint found for this job, the job id is: " + jobId + ", pipeline id is: " + pipelineId);
            return null;
        }
        return this.readPipelineState(latestFileName, jobId);
    }

    @Override
    public List<PipelineState> getCheckpointsByJobIdAndPipelineId(String jobId, String pipelineId) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            log.info("No checkpoint found for this job, the job id is: " + jobId);
            return new ArrayList<PipelineState>();
        }
        ArrayList<PipelineState> pipelineStates = new ArrayList<PipelineState>();
        fileNames.forEach(file -> {
            String filePipelineId = this.getPipelineIdByFileName((String)file);
            if (pipelineId.equals(filePipelineId)) {
                try {
                    pipelineStates.add(this.readPipelineState((String)file, jobId));
                }
                catch (Exception e) {
                    log.error("Failed to read checkpoint data from file " + file, e);
                }
            }
        });
        return pipelineStates;
    }

    @Override
    public void deleteCheckpoint(String jobId) {
        String jobPath = this.getStorageParentDirectory() + jobId;
        try {
            this.fs.delete(new Path(jobPath), true);
        }
        catch (IOException e) {
            log.warn("Failed to delete checkpoint for job {}", (Object)jobId, (Object)e);
        }
    }

    @Override
    public PipelineState getCheckpoint(String jobId, String pipelineId, String checkpointId) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            log.info("No checkpoint found for this job,  the job id is: " + jobId);
            return null;
        }
        for (String fileName : fileNames) {
            if (!pipelineId.equals(this.getPipelineIdByFileName(fileName)) || !checkpointId.equals(this.getCheckpointIdByFileName(fileName))) continue;
            try {
                return this.readPipelineState(fileName, jobId);
            }
            catch (Exception e) {
                log.error("Failed to get checkpoint {} for job {}, pipeline {}", checkpointId, jobId, pipelineId, e);
            }
        }
        throw new CheckpointStorageException(String.format("No checkpoint found, job(%s), pipeline(%s), checkpoint(%s)", jobId, pipelineId, checkpointId));
    }

    @Override
    public synchronized void deleteCheckpoint(String jobId, String pipelineId, String checkpointId) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job, job id is: " + jobId);
        }
        fileNames.forEach(fileName -> {
            if (pipelineId.equals(this.getPipelineIdByFileName((String)fileName)) && checkpointId.equals(this.getCheckpointIdByFileName((String)fileName))) {
                try {
                    this.fs.delete(new Path(path + "/" + fileName), false);
                }
                catch (Exception e) {
                    log.error("Failed to delete checkpoint {} for job {}, pipeline {}", checkpointId, jobId, pipelineId, e);
                }
            }
        });
    }

    @Override
    public void deleteCheckpoint(String jobId, String pipelineId, List<String> checkpointIdList) throws CheckpointStorageException {
        String path = this.getStorageParentDirectory() + jobId;
        List<String> fileNames = this.getFileNames(path);
        if (fileNames.isEmpty()) {
            throw new CheckpointStorageException("No checkpoint found for job, job id is: " + jobId);
        }
        fileNames.forEach(fileName -> {
            String checkpointIdByFileName = this.getCheckpointIdByFileName((String)fileName);
            if (pipelineId.equals(this.getPipelineIdByFileName((String)fileName)) && checkpointIdList.contains(checkpointIdByFileName)) {
                try {
                    this.fs.delete(new Path(path + "/" + fileName), false);
                }
                catch (Exception e) {
                    log.error("Failed to delete checkpoint {} for job {}, pipeline {}", checkpointIdByFileName, jobId, pipelineId, e);
                }
            }
        });
    }

    private List<String> getFileNames(String path) throws CheckpointStorageException {
        try {
            Path parentPath = new Path(path);
            if (!this.fs.exists(parentPath)) {
                log.info("Path " + path + " is not a directory");
                return new ArrayList<String>();
            }
            FileStatus[] fileStatus = this.fs.listStatus(parentPath, path1 -> path1.getName().endsWith("ser"));
            ArrayList<String> fileNames = new ArrayList<String>();
            for (FileStatus status : fileStatus) {
                fileNames.add(status.getPath().getName());
            }
            return fileNames;
        }
        catch (IOException e) {
            throw new CheckpointStorageException("Failed to list files from names" + path, e);
        }
    }

    /*
     * Exception decompiling
     */
    private PipelineState readPipelineState(String fileName, String jobId) throws CheckpointStorageException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

